/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageObjectFactory
implements ModuleFactory {
    private final Set<String> mPackages;
    private final ClassLoader mModuleClassLoader;

    public PackageObjectFactory(Set<String> aPackageNames, ClassLoader aModuleClassLoader) {
        if (aModuleClassLoader == null) {
            throw new IllegalArgumentException("aModuleClassLoader must not be null");
        }
        this.mPackages = Sets.newLinkedHashSet(aPackageNames);
        this.mModuleClassLoader = aModuleClassLoader;
    }

    void addPackage(String aPackageName) {
        this.mPackages.add(aPackageName);
    }

    private Object doMakeObject(String aName) throws CheckstyleException {
        try {
            return this.createObject(aName);
        }
        catch (CheckstyleException ex) {
            for (String packageName : this.mPackages) {
                String className = packageName + aName;
                try {
                    return this.createObject(className);
                }
                catch (CheckstyleException ex2) {
                }
            }
            throw new CheckstyleException("Unable to instantiate " + aName);
        }
    }

    private Object createObject(String aClassName) throws CheckstyleException {
        try {
            Class<?> clazz = Class.forName(aClassName, true, this.mModuleClassLoader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CheckstyleException("Unable to find class for " + aClassName, e);
        }
        catch (InstantiationException e) {
            throw new CheckstyleException("Unable to instantiate " + aClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new CheckstyleException("Unable to instantiate " + aClassName, e);
        }
    }

    @Override
    public Object createModule(String aName) throws CheckstyleException {
        try {
            return this.doMakeObject(aName);
        }
        catch (CheckstyleException ex) {
            try {
                return this.doMakeObject(aName + "Check");
            }
            catch (CheckstyleException ex2) {
                throw new CheckstyleException("Unable to instantiate " + aName, ex2);
            }
        }
    }
}

