/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import java.util.BitSet;

public final class DetailAST
extends CommonAST {
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int mLineNo = Integer.MIN_VALUE;
    private int mColumnNo = Integer.MIN_VALUE;
    private int mChildCount = Integer.MIN_VALUE;
    private DetailAST mParent;
    private DetailAST mPreviousSibling;
    private BitSet mBranchTokenTypes;

    public void initialize(Token aTok) {
        super.initialize(aTok);
        this.mLineNo = aTok.getLine();
        this.mColumnNo = aTok.getColumn() - 1;
    }

    public void initialize(AST aAST) {
        DetailAST da = (DetailAST)aAST;
        this.setText(da.getText());
        this.setType(da.getType());
        this.mLineNo = da.getLineNo();
        this.mColumnNo = da.getColumnNo();
    }

    public void setFirstChild(AST aAST) {
        this.mChildCount = Integer.MIN_VALUE;
        super.setFirstChild(aAST);
        if (aAST != null) {
            ((DetailAST)aAST).setParent(this);
        }
    }

    public void setNextSibling(AST aAST) {
        super.setNextSibling(aAST);
        if (aAST != null && this.mParent != null) {
            ((DetailAST)aAST).setParent(this.mParent);
        }
        if (aAST != null) {
            ((DetailAST)aAST).setPreviousSibling(this);
        }
    }

    void setPreviousSibling(DetailAST aAST) {
        this.mPreviousSibling = aAST;
    }

    public void addChild(AST aAST) {
        super.addChild(aAST);
        if (aAST != null) {
            ((DetailAST)aAST).setParent(this);
            this.getFirstChild().setParent(this);
        }
    }

    public int getChildCount() {
        if (this.mChildCount == Integer.MIN_VALUE) {
            this.mChildCount = 0;
            for (AST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                ++this.mChildCount;
            }
        }
        return this.mChildCount;
    }

    void setParent(DetailAST aParent) {
        this.mParent = aParent;
        DetailAST nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            nextSibling.setParent(aParent);
            nextSibling.setPreviousSibling(this);
        }
    }

    public DetailAST getParent() {
        return this.mParent;
    }

    public int getLineNo() {
        if (this.mLineNo == Integer.MIN_VALUE) {
            DetailAST child = this.getFirstChild();
            DetailAST sibling = this.getNextSibling();
            if (child != null) {
                return child.getLineNo();
            }
            if (sibling != null) {
                return sibling.getLineNo();
            }
        }
        return this.mLineNo;
    }

    public int getColumnNo() {
        if (this.mColumnNo == Integer.MIN_VALUE) {
            DetailAST child = this.getFirstChild();
            DetailAST sibling = this.getNextSibling();
            if (child != null) {
                return child.getColumnNo();
            }
            if (sibling != null) {
                return sibling.getColumnNo();
            }
        }
        return this.mColumnNo;
    }

    public DetailAST getLastChild() {
        DetailAST ast;
        for (ast = this.getFirstChild(); ast != null && ast.getNextSibling() != null; ast = ast.getNextSibling()) {
        }
        return ast;
    }

    private BitSet getBranchTokenTypes() {
        if (this.mBranchTokenTypes == null) {
            this.mBranchTokenTypes = new BitSet();
            this.mBranchTokenTypes.set(this.getType());
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.mBranchTokenTypes.or(childTypes);
            }
        }
        return this.mBranchTokenTypes;
    }

    public boolean branchContains(int aType) {
        return this.getBranchTokenTypes().get(aType);
    }

    public int getChildCount(int aType) {
        int count = 0;
        for (AST i = this.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getType() != aType) continue;
            ++count;
        }
        return count;
    }

    public DetailAST getPreviousSibling() {
        return this.mPreviousSibling;
    }

    public DetailAST findFirstToken(int aType) {
        DetailAST retVal = null;
        for (DetailAST i = this.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getType() != aType) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    public String toString() {
        return super.toString() + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }

    public DetailAST getNextSibling() {
        return (DetailAST)super.getNextSibling();
    }

    public DetailAST getFirstChild() {
        return (DetailAST)super.getFirstChild();
    }
}

