/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NS
extends AbstractTemplateFunction {
    public static final String[] NAMESPACE = new String[]{"Media", "Special", "", "Talk", "User", "User_talk", "Meta", "Meta_talk", "Image", "Image_talk", "MediaWiki", "MediaWiki_talk", "Template", "Template_talk", "Help", "Help_talk", "Category", "Category_talk"};
    public static final String[] NAMESPACE_LOWERCASE = new String[]{"media", "special", "", "talk", "user", "user_talk", "project", "project_talk", "image", "image_talk", "mediawiki", "mediawiki_talk", "template", "template_talk", "help", "help_talk", "category", "category_talk"};
    public static final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();
    public static final ITemplateFunction CONST = new NS();

    static {
        int i = 0;
        while (i < NAMESPACE_LOWERCASE.length) {
            NAMESPACE_MAP.put(NAMESPACE_LOWERCASE[i], NAMESPACE[i]);
            ++i;
        }
    }

    public String parseFunction(char[] src, int beginIndex, int endIndex, IWikiModel model) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        WikipediaScanner.splitByPipe(src, beginIndex, endIndex, list);
        if (list.size() > 0) {
            String arg0 = this.parse((String)list.get(0), model);
            try {
                int numberCode = Integer.valueOf(arg0);
                if (numberCode >= -2 || numberCode <= 15) {
                    return NAMESPACE[numberCode + 2];
                }
            }
            catch (NumberFormatException nfe) {
                arg0 = arg0.replaceAll(" ", "_");
                String value = NAMESPACE_MAP.get(arg0.toLowerCase());
                if (value != null) {
                    return value;
                }
                return "[[:Template:Ns:" + arg0 + "]]";
            }
        }
        return null;
    }
}

