/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.expr;

import info.bliki.wiki.template.expr.SyntaxError;
import info.bliki.wiki.template.expr.ast.IParserFactory;
import info.bliki.wiki.template.expr.operator.Operator;
import java.util.List;

public class Scanner {
    protected String fInputString;
    protected char fCurrentChar;
    protected int fCurrentPosition;
    protected int fToken;
    protected String fOperatorString;
    protected List fOperList;
    protected int rowCount;
    protected int fCurrentColumnStartPosition;
    public static final int TT_EOF = 0;
    public static final int TT_FLOATING_POINT = 10;
    public static final int TT_PRECEDENCE_OPEN = 14;
    public static final int TT_PRECEDENCE_CLOSE = 15;
    public static final int TT_OPERATOR = 31;
    public static final int TT_STRING = 136;
    public static final int TT_DIGIT = 139;
    protected int numFormat = 0;
    protected IParserFactory fFactory;

    public Scanner() {
        this.initializeNullScanner();
    }

    protected void initialize(String s) throws SyntaxError {
        this.initializeNullScanner();
        this.fInputString = s;
        if (s != null) {
            this.getNextToken();
        }
    }

    private void initializeNullScanner() {
        this.fInputString = null;
        this.fToken = 0;
        this.fCurrentPosition = 0;
        this.rowCount = 0;
        this.fCurrentColumnStartPosition = 0;
    }

    private void getChar() {
        if (this.fInputString.length() > this.fCurrentPosition) {
            this.fCurrentChar = this.fInputString.charAt(this.fCurrentPosition++);
            return;
        }
        this.fCurrentPosition = this.fInputString.length() + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    protected List getOperator() {
        int startPosition = this.fCurrentPosition - 1;
        this.fOperatorString = this.fInputString.substring(startPosition, this.fCurrentPosition);
        List<Operator> list = this.fFactory.getOperatorList(this.fOperatorString);
        List<Operator> lastList = null;
        int lastOperatorPosition = -1;
        if (list != null) {
            lastList = list;
            lastOperatorPosition = this.fCurrentPosition;
        }
        this.getChar();
        while (this.fFactory.getOperatorCharacters().indexOf(this.fCurrentChar) >= 0) {
            this.fOperatorString = this.fInputString.substring(startPosition, this.fCurrentPosition);
            list = this.fFactory.getOperatorList(this.fOperatorString);
            if (list != null) {
                lastList = list;
                lastOperatorPosition = this.fCurrentPosition;
            }
            this.getChar();
        }
        if (lastOperatorPosition > 0) {
            this.fCurrentPosition = lastOperatorPosition;
            return lastList;
        }
        int endPosition = this.fCurrentPosition--;
        this.fCurrentPosition = startPosition;
        this.throwSyntaxError("Operator token not found: " + this.fInputString.substring(startPosition, endPosition - 1));
        return null;
    }

    protected void getNextToken() throws SyntaxError {
        while (this.fInputString.length() > this.fCurrentPosition) {
            this.fCurrentChar = this.fInputString.charAt(this.fCurrentPosition++);
            this.fToken = 0;
            if (this.fFactory.getOperatorCharacters().indexOf(this.fCurrentChar) >= 0) {
                this.fOperList = this.getOperator();
                this.fToken = 31;
                return;
            }
            if (this.fCurrentChar >= 'a' && this.fCurrentChar <= 'z' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'Z') {
                String ident = this.getIdentifier().toLowerCase();
                this.fOperList = this.fFactory.getOperatorList(ident);
                if (this.fOperList == null || this.fOperList.size() == 0) {
                    this.throwSyntaxError("unexpected operator: '" + ident + "'");
                }
                this.fOperatorString = ident;
                this.fToken = 31;
                return;
            }
            if (this.fCurrentChar == '\t' || this.fCurrentChar == '\r' || this.fCurrentChar == ' ') continue;
            if (this.fCurrentChar == '\n') {
                ++this.rowCount;
                this.fCurrentColumnStartPosition = this.fCurrentPosition;
                continue;
            }
            if (this.fCurrentChar >= '0' && this.fCurrentChar <= '9') {
                this.fToken = 139;
                return;
            }
            switch (this.fCurrentChar) {
                case '(': {
                    this.fToken = 14;
                    break;
                }
                case ')': {
                    this.fToken = 15;
                    break;
                }
                case '.': {
                    if (this.fInputString.length() <= this.fCurrentPosition || this.fInputString.charAt(this.fCurrentPosition) < '0' || this.fInputString.charAt(this.fCurrentPosition) > '9') break;
                    this.fToken = 139;
                    break;
                }
                case '\"': {
                    this.fToken = 136;
                    break;
                }
                default: {
                    this.throwSyntaxError("unexpected character: '" + this.fCurrentChar + "'");
                }
            }
            if (this.fToken == 0) {
                this.throwSyntaxError("token not found");
            }
            return;
        }
        this.fCurrentPosition = this.fInputString.length() + 1;
        this.fCurrentChar = (char)32;
        this.fToken = 0;
    }

    protected void throwSyntaxError(String error) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - 1, this.rowCount, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, 1);
    }

    protected void throwSyntaxError(String error, int errorLength) throws SyntaxError {
        throw new SyntaxError(this.fCurrentPosition - errorLength, this.rowCount, this.fCurrentPosition - this.fCurrentColumnStartPosition, this.getErrorLine(), error, errorLength);
    }

    private String getErrorLine() {
        if (this.fInputString.length() < this.fCurrentPosition) {
            --this.fCurrentPosition;
        }
        int eol = this.fCurrentPosition;
        while (this.fInputString.length() > eol) {
            this.fCurrentChar = this.fInputString.charAt(eol++);
            if (this.fCurrentChar != '\n') continue;
            --eol;
            break;
        }
        String line = this.fInputString.substring(this.fCurrentColumnStartPosition, eol);
        return line;
    }

    protected String getIdentifier() {
        int startPosition = this.fCurrentPosition - 1;
        this.getChar();
        while (this.fCurrentChar >= 'a' && this.fCurrentChar <= 'z' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'Z') {
            this.getChar();
        }
        int endPosition = this.fCurrentPosition--;
        int length = --endPosition - startPosition;
        return this.fInputString.substring(startPosition, endPosition);
    }

    /*
     * Unable to fully structure code
     */
    protected Object[] getNumberString() {
        block20: {
            block21: {
                block19: {
                    result = new Object[2];
                    this.numFormat = 10;
                    startPosition = this.fCurrentPosition - 1;
                    firstCh = this.fCurrentChar;
                    dFlag = 32;
                    if (this.fCurrentChar == '.') {
                        dFlag = this.fCurrentChar;
                    }
                    this.getChar();
                    if (firstCh == '0') {
                        switch (this.fCurrentChar) {
                            case 'b': {
                                this.numFormat = 2;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                                break;
                            }
                            case 'B': {
                                this.numFormat = 2;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                                break;
                            }
                            case 'o': {
                                this.numFormat = 8;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                                break;
                            }
                            case 'O': {
                                this.numFormat = 8;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                                break;
                            }
                            case 'x': {
                                this.numFormat = 16;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                                break;
                            }
                            case 'X': {
                                this.numFormat = 16;
                                startPosition = this.fCurrentPosition;
                                this.getChar();
                            }
                        }
                    }
                    if (this.numFormat != 2) break block19;
                    while (this.fCurrentChar >= '0' && this.fCurrentChar <= '1') {
                        this.getChar();
                    }
                    break block20;
                }
                if (this.numFormat != 8) break block21;
                while (this.fCurrentChar >= '0' && this.fCurrentChar <= '7') {
                    this.getChar();
                }
                break block20;
            }
            if (this.numFormat != 16) ** GOTO lbl63
            while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9' || this.fCurrentChar >= 'a' && this.fCurrentChar <= 'f' || this.fCurrentChar >= 'A' && this.fCurrentChar <= 'F') {
                this.getChar();
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                if (this.fCurrentChar == '.') {
                    if (this.fCurrentChar == '.' && dFlag != 32) break;
                    dFlag = this.fCurrentChar;
                    this.getChar();
                    continue;
                }
                this.getChar();
lbl63:
                // 3 sources

                ** while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9' || this.fCurrentChar == '.')
            }
lbl64:
            // 2 sources

            if (dFlag != 32) {
                this.numFormat = -1;
            }
        }
        if (this.numFormat < 0 && (this.fCurrentChar == 'E' || this.fCurrentChar == 'e')) {
            this.getChar();
            if (this.fCurrentChar == '+' || this.fCurrentChar == '-') {
                this.getChar();
                while (this.fCurrentChar >= '0' && this.fCurrentChar <= '9') {
                    this.getChar();
                }
            }
        }
        endPosition = this.fCurrentPosition--;
        result[0] = this.fInputString.substring(startPosition, --endPosition);
        result[1] = this.numFormat;
        return result;
    }

    protected StringBuffer getStringBuffer() throws SyntaxError {
        StringBuffer ident = new StringBuffer();
        this.getChar();
        if (this.fCurrentChar == '\n' || this.fToken == 0) {
            this.throwSyntaxError("string -" + ident.toString() + "- contains no character.");
        }
        while (this.fCurrentChar != '\"') {
            if (this.fCurrentChar == '\\') {
                this.getChar();
                switch (this.fCurrentChar) {
                    case '\\': {
                        ident.append(this.fCurrentChar);
                        break;
                    }
                    case 'n': {
                        ident.append("\n");
                        break;
                    }
                    case 't': {
                        ident.append("\t");
                        break;
                    }
                    default: {
                        this.throwSyntaxError("string - unknown character after back-slash.");
                    }
                }
                this.getChar();
                continue;
            }
            if (this.fCurrentChar != '\"' && (this.fCurrentChar == '\n' || this.fToken == 0)) {
                this.throwSyntaxError("string -" + ident.toString() + "- not closed.");
            }
            ident.append(this.fCurrentChar);
            this.getChar();
        }
        return ident;
    }
}

