/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.util;

import com.sardak.antform.interfaces.ActionComponent;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;

public class TargetInvoker
extends CallTarget
implements Runnable,
SubBuildListener {
    private boolean background = false;
    private boolean newProject = true;
    private Thread createdThread;
    private ActionComponent actionSource = null;

    public TargetInvoker(Task parentTask, ActionComponent actionSource) {
        this.actionSource = actionSource;
        this.setProject(parentTask.getProject());
        this.setOwningTarget(parentTask.getOwningTarget());
        this.setTaskName(parentTask.getTaskName());
        this.setLocation(parentTask.getLocation());
        this.setTarget(actionSource.getTarget());
        this.setBackground(actionSource.isBackground());
        this.setNewProject(actionSource.isNewProject());
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean isNewProject() {
        return this.newProject;
    }

    public void setNewProject(boolean newProject) {
        this.newProject = newProject;
    }

    public void run() {
        super.execute();
    }

    public void execute() throws BuildException {
        if (this.background) {
            this.getProject().addBuildListener((BuildListener)this);
            this.createdThread = new Thread(this);
            this.createdThread.start();
        } else if (this.isNewProject()) {
            this.run();
        } else if (this.findTargetByName(this.actionSource.getTarget()) != null) {
            this.getProject().executeTarget(this.actionSource.getTarget());
        } else {
            this.log("Target " + this.actionSource.getTarget() + " not found.");
        }
    }

    public void buildStarted(BuildEvent evt) {
    }

    public void buildFinished(BuildEvent evt) {
        this.log("buildFinished event received by TargetInvoker", 4);
        this.waitForThread(evt);
    }

    public void targetStarted(BuildEvent evt) {
    }

    public void targetFinished(BuildEvent evt) {
    }

    public void taskStarted(BuildEvent evt) {
    }

    public void taskFinished(BuildEvent evt) {
    }

    public void messageLogged(BuildEvent evt) {
    }

    public void subBuildStarted(BuildEvent evt) {
    }

    public void subBuildFinished(BuildEvent evt) {
        this.log("subBuildFinished event received by TargetInvoker", 4);
        this.waitForThread(evt);
    }

    private void waitForThread(BuildEvent evt) {
        if (this.createdThread != null && this.getProject().equals(evt.getProject()) && this.createdThread.isAlive()) {
            this.log("Waiting for background threads completion...", 3);
            try {
                this.createdThread.join();
            }
            catch (InterruptedException ie) {
                this.log("Thread " + this.createdThread.getName() + " got interrupted: " + ie.getMessage(), 4);
            }
        }
    }

    private Target findTargetByName(String target) {
        Target targetToFind = null;
        Hashtable targets = this.getProject().getTargets();
        Iterator i = targets.keySet().iterator();
        while (i.hasNext()) {
            String targetName = (String)i.next();
            Target aTarget = (Target)targets.get(targetName);
            if (!aTarget.getName().equals(target)) continue;
            targetToFind = aTarget;
        }
        return targetToFind;
    }
}

