/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParenPadCheck
extends AbstractOptionCheck<PadOption> {
    AbstractParenPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    protected void processLeft(DetailAST aAST) {
        String line = this.getLines()[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + 1;
        if (after < line.length()) {
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                this.log(aAST.getLineNo(), after, "ws.followed", "(");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after)) && line.charAt(after) != ')') {
                this.log(aAST.getLineNo(), after, "ws.notFollowed", "(");
            }
        }
    }

    protected void processRight(DetailAST aAST) {
        String line = this.getLines()[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before >= 0) {
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.log(aAST.getLineNo(), before, "ws.preceded", ")");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(before)) && line.charAt(before) != '(') {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "ws.notPreceded", ")");
            }
        }
    }
}

