/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class SoftValueMap
implements Map {
    private final ReferenceQueue m_valueReferenceQueue;
    private final float m_loadFactor;
    private final int m_readClearCheckFrequency;
    private final int m_writeClearCheckFrequency;
    private SoftEntry[] m_buckets;
    private int m_size;
    private int m_sizeThreshold;
    private int m_readAccessCount;
    private int m_writeAccessCount;
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final boolean IDENTITY_OPTIMIZATION = true;
    private static final boolean ENQUEUE_FOUND_CLEARED_ENTRIES = true;
    private static final boolean DEBUG = false;

    public SoftValueMap() {
        this(1, 1);
    }

    public SoftValueMap(int readClearCheckFrequency, int writeClearCheckFrequency) {
        this(11, 0.75f, readClearCheckFrequency, writeClearCheckFrequency);
    }

    public SoftValueMap(int initialCapacity, float loadFactor, int readClearCheckFrequency, int writeClearCheckFrequency) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative input: initialCapacity [" + initialCapacity + "]");
        }
        if ((double)loadFactor <= 0.0 || (double)loadFactor >= 1.000001) {
            throw new IllegalArgumentException("loadFactor not in (0.0, 1.0] range: " + loadFactor);
        }
        if (readClearCheckFrequency < 1) {
            throw new IllegalArgumentException("readClearCheckFrequency not in [1, +inf) range: " + readClearCheckFrequency);
        }
        if (writeClearCheckFrequency < 1) {
            throw new IllegalArgumentException("writeClearCheckFrequency not in [1, +inf) range: " + writeClearCheckFrequency);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.m_valueReferenceQueue = new ReferenceQueue();
        this.m_loadFactor = loadFactor;
        this.m_sizeThreshold = (int)((float)initialCapacity * loadFactor);
        this.m_readClearCheckFrequency = readClearCheckFrequency;
        this.m_writeClearCheckFrequency = writeClearCheckFrequency;
        this.m_buckets = new SoftEntry[initialCapacity];
    }

    public boolean equals(Object rhs) {
        throw new UnsupportedOperationException("not implemented: equals");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("not implemented: hashCode");
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.debugDump(s);
        return s.toString();
    }

    public int size() {
        return this.m_size;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (++this.m_readAccessCount % this.m_readClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        int keyHashCode = key.hashCode();
        SoftEntry[] buckets = this.m_buckets;
        int bucketIndex = (keyHashCode & Integer.MAX_VALUE) % buckets.length;
        Object result = null;
        SoftEntry entry = buckets[bucketIndex];
        while (entry != null) {
            Object entryKey = entry.m_key;
            if (key == entryKey || keyHashCode == entryKey.hashCode() && key.equals(entryKey)) {
                IndexedSoftReference ref = entry.m_softValue;
                result = ((Reference)ref).get();
                if (result == null) {
                    ref.enqueue();
                }
                return result;
            }
            entry = entry.m_next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        SoftEntry newEntry;
        if (key == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null input: value");
        }
        if (++this.m_writeAccessCount % this.m_writeClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        SoftEntry currentKeyEntry = null;
        int keyHashCode = key.hashCode();
        SoftEntry[] buckets = this.m_buckets;
        int bucketIndex = (keyHashCode & Integer.MAX_VALUE) % buckets.length;
        SoftEntry entry = buckets[bucketIndex];
        while (entry != null) {
            Object entryKey = entry.m_key;
            if (key == entryKey || keyHashCode == entryKey.hashCode() && key.equals(entryKey)) {
                currentKeyEntry = entry;
                break;
            }
            entry = entry.m_next;
        }
        if (currentKeyEntry != null) {
            IndexedSoftReference ref = currentKeyEntry.m_softValue;
            Object currentKeyValue = ref.get();
            if (currentKeyValue == null) {
                ref.m_bucketIndex = -1;
            }
            currentKeyEntry.m_softValue = new IndexedSoftReference(value, this.m_valueReferenceQueue, bucketIndex);
            return currentKeyValue;
        }
        if (this.m_size >= this.m_sizeThreshold) {
            this.rehash();
        }
        buckets = this.m_buckets;
        bucketIndex = (keyHashCode & Integer.MAX_VALUE) % buckets.length;
        SoftEntry bucketListHead = buckets[bucketIndex];
        buckets[bucketIndex] = newEntry = new SoftEntry(this.m_valueReferenceQueue, key, value, bucketListHead, bucketIndex);
        ++this.m_size;
        return null;
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null input: key");
        }
        if (++this.m_writeAccessCount % this.m_writeClearCheckFrequency == 0) {
            this.removeClearedValues();
        }
        int keyHashCode = key.hashCode();
        SoftEntry[] buckets = this.m_buckets;
        int bucketIndex = (keyHashCode & Integer.MAX_VALUE) % buckets.length;
        Object result = null;
        SoftEntry entry = buckets[bucketIndex];
        SoftEntry prev = null;
        while (entry != null) {
            Object entryKey = entry.m_key;
            if (entryKey == key || keyHashCode == entryKey.hashCode() && key.equals(entryKey)) {
                if (prev == null) {
                    buckets[bucketIndex] = entry.m_next;
                } else {
                    prev.m_next = entry.m_next;
                }
                IndexedSoftReference ref = entry.m_softValue;
                result = ref.get();
                ref.m_bucketIndex = -1;
                entry.m_softValue = null;
                entry.m_key = null;
                entry.m_next = null;
                entry = null;
                --this.m_size;
                break;
            }
            prev = entry;
            entry = entry.m_next;
        }
        return result;
    }

    public void clear() {
        SoftEntry[] buckets = this.m_buckets;
        int bLimit = buckets.length;
        for (int b = 0; b < bLimit; ++b) {
            SoftEntry entry = buckets[b];
            while (entry != null) {
                SoftEntry next = entry.m_next;
                entry.m_softValue.m_bucketIndex = -1;
                entry.m_softValue = null;
                entry.m_next = null;
                entry.m_key = null;
                entry = next;
            }
            buckets[b] = null;
        }
        this.m_size = 0;
        this.m_readAccessCount = 0;
        this.m_writeAccessCount = 0;
    }

    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("not implemented: containsKey");
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("not implemented: containsValue");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("not implemented: putAll");
    }

    public Set keySet() {
        throw new UnsupportedOperationException("not implemented: keySet");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("not implemented: entrySet");
    }

    public Collection values() {
        throw new UnsupportedOperationException("not implemented: values");
    }

    void debugDump(StringBuffer out) {
        if (out != null) {
            out.append(this.getClass().getName().concat("@").concat(Integer.toHexString(System.identityHashCode(this))));
            out.append(EOL);
            out.append("size = " + this.m_size + ", bucket table size = " + this.m_buckets.length + ", load factor = " + this.m_loadFactor + EOL);
            out.append("size threshold = " + this.m_sizeThreshold + ", get clear frequency = " + this.m_readClearCheckFrequency + ", put clear frequency = " + this.m_writeClearCheckFrequency + EOL);
            out.append("get count: " + this.m_readAccessCount + ", put count: " + this.m_writeAccessCount + EOL);
        }
    }

    private void rehash() {
        SoftEntry[] buckets = this.m_buckets;
        int newBucketCount = (this.m_buckets.length << 1) + 1;
        SoftEntry[] newBuckets = new SoftEntry[newBucketCount];
        int newSize = 0;
        int bLimit = buckets.length;
        for (int b = 0; b < bLimit; ++b) {
            SoftEntry entry = buckets[b];
            while (entry != null) {
                SoftEntry next = entry.m_next;
                IndexedSoftReference ref = entry.m_softValue;
                Object entryValue = ref.get();
                if (entryValue != null) {
                    SoftEntry bucketListHead;
                    int entryKeyHashCode = entry.m_key.hashCode();
                    int newBucketIndex = (entryKeyHashCode & Integer.MAX_VALUE) % newBucketCount;
                    entry.m_next = bucketListHead = newBuckets[newBucketIndex];
                    newBuckets[newBucketIndex] = entry;
                    ref.m_bucketIndex = newBucketIndex;
                    ++newSize;
                    entryValue = null;
                } else {
                    ref.m_bucketIndex = -1;
                }
                entry = next;
            }
        }
        this.m_size = newSize;
        this.m_sizeThreshold = (int)((float)newBucketCount * this.m_loadFactor);
        this.m_buckets = newBuckets;
    }

    private void removeClearedValues() {
        Reference _ref;
        boolean count = false;
        block0: while ((_ref = this.m_valueReferenceQueue.poll()) != null) {
            int bucketIndex = ((IndexedSoftReference)_ref).m_bucketIndex;
            if (bucketIndex < 0) continue;
            SoftEntry entry = this.m_buckets[bucketIndex];
            SoftEntry prev = null;
            while (entry != null) {
                if (entry.m_softValue == _ref) {
                    if (prev == null) {
                        this.m_buckets[bucketIndex] = entry.m_next;
                    } else {
                        prev.m_next = entry.m_next;
                    }
                    entry.m_softValue = null;
                    entry.m_key = null;
                    entry.m_next = null;
                    entry = null;
                    --this.m_size;
                    continue block0;
                }
                prev = entry;
                entry = entry.m_next;
            }
            StringBuffer msg = new StringBuffer("removeClearedValues(): soft reference [" + _ref + "] did not match within bucket #" + bucketIndex + EOL);
            this.debugDump(msg);
            throw new Error(msg.toString());
        }
    }

    static class SoftEntry {
        IndexedSoftReference m_softValue;
        Object m_key;
        SoftEntry m_next;

        SoftEntry(ReferenceQueue valueReferenceQueue, Object key, Object value, SoftEntry next, int bucketIndex) {
            this.m_key = key;
            this.m_softValue = new IndexedSoftReference(value, valueReferenceQueue, bucketIndex);
            value = null;
            this.m_next = next;
        }
    }

    static class IndexedSoftReference
    extends SoftReference {
        int m_bucketIndex;

        IndexedSoftReference(Object referent, ReferenceQueue queue, int bucketIndex) {
            super(referent, queue);
            this.m_bucketIndex = bucketIndex;
        }
    }
}

