/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureParameterMetadata
extends ORMetadata {
    private MetadataClass m_type;
    private String m_direction;
    private Integer m_jdbcType;
    private String m_jdbcTypeName;
    private String m_name;
    private String m_queryParameter;
    private String m_typeName;

    public StoredProcedureParameterMetadata() {
        super("<stored-procedure-parameter>");
    }

    public StoredProcedureParameterMetadata(MetadataAnnotation storedProcedureParameter, MetadataAccessibleObject accessibleObject) {
        super(storedProcedureParameter, accessibleObject);
        this.m_direction = (String)storedProcedureParameter.getAttribute("direction");
        this.m_name = (String)storedProcedureParameter.getAttribute("name");
        this.m_queryParameter = (String)storedProcedureParameter.getAttribute("queryParameter");
        this.m_type = this.getMetadataClass((String)storedProcedureParameter.getAttribute("type"));
        this.m_jdbcType = (Integer)storedProcedureParameter.getAttribute("jdbcType");
        this.m_jdbcTypeName = (String)storedProcedureParameter.getAttribute("jdbcTypeName");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StoredProcedureParameterMetadata) {
            StoredProcedureParameterMetadata parameter = (StoredProcedureParameterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, parameter.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, parameter.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcType, parameter.getJdbcType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcTypeName, parameter.getJdbcTypeName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, parameter.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, parameter.getQueryParameter());
        }
        return false;
    }

    public String getDirection() {
        return this.m_direction;
    }

    public Integer getJdbcType() {
        return this.m_jdbcType;
    }

    public String getJdbcTypeName() {
        return this.m_jdbcTypeName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public MetadataClass getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    protected boolean hasJdbcType() {
        return this.m_jdbcType != null && this.m_jdbcType.equals(-1);
    }

    protected boolean hasJdbcTypeName() {
        return this.m_jdbcTypeName != null && !this.m_jdbcTypeName.equals("");
    }

    protected boolean hasType() {
        return !this.m_type.isVoid();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_type = this.initXMLClassName(this.m_typeName);
    }

    public List<String> process(StoredProcedureCall call) {
        ArrayList<String> queryArguments = new ArrayList<String>();
        String procedureParameterName = this.m_name;
        if (this.m_name == null || this.m_name.equals("")) {
            procedureParameterName = this.m_queryParameter;
        }
        if (this.m_direction == null || this.m_direction.equals(Direction.IN.name())) {
            if (this.hasType()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.getJavaClass(this.m_type));
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedArgument(procedureParameterName, this.m_queryParameter);
            }
            queryArguments.add(this.m_queryParameter);
        } else if (this.m_direction.equals(Direction.OUT.name())) {
            if (this.hasType()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.getJavaClass(this.m_type));
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedOutputArgument(procedureParameterName, this.m_queryParameter);
            }
        } else if (this.m_direction.equals(Direction.IN_OUT.name())) {
            if (this.hasType()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.getJavaClass(this.m_type));
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType, this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType);
            } else {
                call.addNamedInOutputArgument(procedureParameterName, this.m_queryParameter);
            }
            queryArguments.add(this.m_queryParameter);
        } else if (this.m_direction.equals(Direction.OUT_CURSOR.name())) {
            call.useNamedCursorOutputAsResultSet(this.m_queryParameter);
        }
        return queryArguments;
    }

    public void setDirection(String direction) {
        this.m_direction = direction;
    }

    public void setJdbcType(Integer jdbcType) {
        this.m_jdbcType = jdbcType;
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.m_jdbcTypeName = jdbcTypeName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setType(MetadataClass type) {
        this.m_type = type;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

