/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class DBasePlatform
extends DatabasePlatform {
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("NUMBER", 1));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("NUMBER", 11));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("NUMBER", 6));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("NUMBER", 4));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 19));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("CHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BINARY"));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("MEMO"));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("CHAR", 15));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("CHAR", 25));
        return fieldTypeMapping;
    }

    public Object convertToDatabaseType(Object value) {
        Object databaseValue = super.convertToDatabaseType(value);
        if (databaseValue instanceof Time || databaseValue instanceof Timestamp) {
            databaseValue = databaseValue.toString();
        }
        return databaseValue;
    }

    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        Object databaseValue = super.convertToDatabaseType(parameter);
        if (databaseValue instanceof Time || databaseValue instanceof Timestamp) {
            databaseValue = databaseValue.toString();
        }
        super.setParameterValueInDatabaseCall(databaseValue, statement, index, session);
    }

    public int getMaxFieldNameSize() {
        return 10;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE OF *";
    }

    public boolean isDBase() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, Long.valueOf("922337203685478000"));
        values.put(Double.class, new Double("99999999.999999999"));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(Float.class, new Float("99999999.999999999"));
        values.put(BigInteger.class, new BigInteger("922337203685478000"));
        values.put(BigDecimal.class, new BigDecimal("999999.999999999"));
        return values;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, Long.valueOf("-922337203685478000"));
        values.put(Double.class, new Double("-99999999.999999999"));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(Float.class, new Float("-99999999.999999999"));
        values.put(BigInteger.class, new BigInteger("-922337203685478000"));
        values.put(BigDecimal.class, new BigDecimal("-999999.999999999"));
        return values;
    }

    public void printFieldNotNullClause(Writer writer) {
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsForeignKeyConstraints() {
        return false;
    }

    public boolean supportsPrimaryKeyConstraint() {
        return false;
    }
}

