/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.ArrayList;
import jep.JepException;
import jep.Util;
import jep.python.PyModule;
import jep.python.PyObject;

public final class Jep {
    private boolean closed = false;
    private long tstate = 0L;
    private Thread thread = null;
    private ClassLoader classLoader = null;
    private StringBuffer evalLines = null;
    private boolean interactive = false;
    private static final String LINE_SEP = "\n";
    private ArrayList<PyObject> pythonObjects = new ArrayList();

    public Jep() throws JepException {
        this(false, null, null);
    }

    public Jep(boolean bl) throws JepException {
        this(bl, null, null);
    }

    public Jep(boolean bl, String string) throws JepException {
        this(bl, string, null);
    }

    public Jep(boolean bl, String string, ClassLoader classLoader) throws JepException {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.interactive = bl;
        this.tstate = this.init(this.classLoader);
        this.thread = Thread.currentThread();
        if (string != null) {
            this.eval("import sys");
            this.eval("sys.path += '" + string + "'.split('" + File.pathSeparator + "')");
        }
    }

    private native long init(ClassLoader var1) throws JepException;

    public void isValidThread() throws JepException {
        if (this.thread != Thread.currentThread()) {
            throw new JepException("Invalid thread access.");
        }
        if (this.tstate == 0L) {
            throw new JepException("Initialization failed.");
        }
    }

    public void runScript(String string) throws JepException {
        this.runScript(string, null);
    }

    public void runScript(String string, ClassLoader classLoader) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        if (string == null) {
            throw new JepException("Script filename cannot be null.");
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new JepException("Invalid file: " + file.getAbsolutePath());
        }
        this.setClassLoader(classLoader);
        this.run(this.tstate, string);
    }

    private native void run(long var1, String var3) throws JepException;

    public Object invoke(String string, Object ... objectArray) throws JepException {
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = Util.getTypeId(objectArray[i]);
        }
        return this.invoke(this.tstate, string, objectArray, nArray);
    }

    private native Object invoke(long var1, String var3, Object[] var4, int[] var5);

    public boolean eval(String string) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        try {
            if (string != null) {
                string = string.replaceAll("\r", "");
            }
            if (string == null || string.trim().equals("")) {
                if (!this.interactive) {
                    return false;
                }
                if (this.evalLines == null) {
                    return true;
                }
                this.eval(this.tstate, this.evalLines.toString());
                this.evalLines = null;
                return true;
            }
            if (!this.interactive || this.evalLines == null && this.compileString(this.tstate, string) == 1) {
                this.eval(this.tstate, string);
                return true;
            }
            if (this.evalLines == null) {
                this.evalLines = new StringBuffer();
            } else {
                this.evalLines.append(LINE_SEP);
            }
            this.evalLines.append(string);
            return false;
        }
        catch (JepException jepException) {
            this.evalLines = null;
            throw new JepException(jepException);
        }
    }

    private native int compileString(long var1, String var3) throws JepException;

    private native void eval(long var1, String var3) throws JepException;

    public Object getValue(String string) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        return this.getValue(this.tstate, string);
    }

    private native Object getValue(long var1, String var3) throws JepException;

    public float[] getValue_floatarray(String string) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        return this.getValue_floatarray(this.tstate, string);
    }

    private native float[] getValue_floatarray(long var1, String var3) throws JepException;

    public byte[] getValue_bytearray(String string) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        return this.getValue_bytearray(this.tstate, string);
    }

    private native byte[] getValue_bytearray(long var1, String var3) throws JepException;

    public PyObject trackObject(PyObject pyObject) throws JepException {
        return this.trackObject(pyObject, true);
    }

    public PyObject trackObject(PyObject pyObject, boolean bl) throws JepException {
        if (bl) {
            pyObject.incref();
        }
        this.pythonObjects.add(pyObject);
        return pyObject;
    }

    public PyModule createModule(String string) throws JepException {
        return (PyModule)this.trackObject(new PyModule(this.tstate, this.createModule(this.tstate, string), this));
    }

    private native long createModule(long var1, String var3) throws JepException;

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null && classLoader != this.classLoader) {
            this.classLoader = classLoader;
            this.setClassLoader(this.tstate, classLoader);
        }
    }

    private native void setClassLoader(long var1, ClassLoader var3);

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void set(String string, Object object) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        if (object instanceof Class) {
            this.set(this.tstate, string, (Class)object);
        } else {
            this.set(this.tstate, string, object);
        }
    }

    private native void set(long var1, String var3, Object var4) throws JepException;

    private native void set(long var1, String var3, Class var4) throws JepException;

    public void set(String string, String string2) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, string2);
    }

    private native void set(long var1, String var3, String var4) throws JepException;

    public void set(String string, boolean bl) throws JepException {
        if (bl) {
            this.set(string, 1);
        } else {
            this.set(string, 0);
        }
    }

    public void set(String string, int n) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, n);
    }

    public void set(String string, short s) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, s);
    }

    private native void set(long var1, String var3, int var4) throws JepException;

    public void set(String string, char[] cArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, new String(cArray));
    }

    public void set(String string, char c) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, new String(new char[]{c}));
    }

    public void set(String string, byte by) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, by);
    }

    public void set(String string, long l) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, l);
    }

    private native void set(long var1, String var3, long var4) throws JepException;

    public void set(String string, double d) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, d);
    }

    private native void set(long var1, String var3, double var4) throws JepException;

    public void set(String string, float f) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, f);
    }

    private native void set(long var1, String var3, float var4) throws JepException;

    public void set(String string, boolean[] blArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, blArray);
    }

    private native void set(long var1, String var3, boolean[] var4) throws JepException;

    public void set(String string, int[] nArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, nArray);
    }

    private native void set(long var1, String var3, int[] var4) throws JepException;

    public void set(String string, short[] sArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, sArray);
    }

    private native void set(long var1, String var3, short[] var4) throws JepException;

    public void set(String string, byte[] byArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, byArray);
    }

    private native void set(long var1, String var3, byte[] var4) throws JepException;

    public void set(String string, long[] lArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, lArray);
    }

    private native void set(long var1, String var3, long[] var4) throws JepException;

    public void set(String string, double[] dArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, dArray);
    }

    private native void set(long var1, String var3, double[] var4) throws JepException;

    public void set(String string, float[] fArray) throws JepException {
        if (this.closed) {
            throw new JepException("Jep has been closed.");
        }
        this.isValidThread();
        this.set(this.tstate, string, fArray);
    }

    private native void set(long var1, String var3, float[] var4) throws JepException;

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        for (int i = 0; i < this.pythonObjects.size(); ++i) {
            this.pythonObjects.get(i).close();
        }
        this.closed = true;
        this.close(this.tstate);
        this.tstate = 0L;
    }

    private native void close(long var1);

    protected void finalize() {
        this.close();
    }

    static {
        System.loadLibrary("jep");
    }
}

