/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PackageRenamer {
    int numberOfTotalFile = 0;
    int numberOfChangedFile = 0;
    boolean specifyLogFile = false;
    PrintWriter outLog = null;
    String logFileString = null;
    File logFile;
    File sourceRootDirFile;
    File destinationRootDir;
    String sourceProperties;
    Properties properties = null;
    String propertiesFileName;
    boolean VERBOSE = true;
    protected static final String SYSTEM_OUT = "System.out";
    BufferedReader reader = null;
    String[] UNSUPPORTED_EXTENSIONS = new String[]{"jar", "zip", "ear", "war", "dll", "class", "exe"};
    int BUFSIZ = 4096;
    String CR = System.getProperty("line.separator");

    public PackageRenamer() {
        this(PackageRenamer.getDefaultPropertiesFileName());
    }

    public PackageRenamer(String propertiesFileName) {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println(this.bannerText());
        this.sourceRootDirFile = this.existingDirectoryFromPrompt();
        System.out.println("");
        this.destinationRootDir = this.promptForDestinationDirectory();
        System.out.println("");
        this.propertiesFileName = propertiesFileName;
        this.outLog = this.streamForNonExistentFilePrompt();
        this.properties = this.readChangesFile(propertiesFileName);
    }

    public PackageRenamer(String[] args) {
        this.propertiesFileName = args[0];
        this.sourceRootDirFile = this.buildAndCheckExistingDirFile(args[1]);
        this.destinationRootDir = this.buildAndCheckDestinationFile(args[2]);
        this.outLog = args.length == 4 ? this.buildAndCheckLogWriter(args[3]) : this.buildAndCheckLogWriter(SYSTEM_OUT);
        this.properties = this.readChangesFile(args[0]);
        this.logln(this.bannerText());
    }

    protected String bannerText() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(this.CR);
        stringBuffer.append("NOTE: The package renamer is meant to be run on plain text files. ");
        stringBuffer.append(this.CR);
        stringBuffer.append("A rename will NOT be done on binary files.");
        stringBuffer.append(this.CR);
        return stringBuffer.toString();
    }

    public void binaryCopy(File inFile, File outFile) throws FileNotFoundException, IOException {
        int nBytesRead;
        byte[] buf = new byte[this.BUFSIZ];
        FileInputStream in = new FileInputStream(inFile);
        FileOutputStream out = new FileOutputStream(outFile);
        while ((nBytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, nBytesRead);
        }
        in.close();
        out.close();
    }

    protected boolean bufferContainsNullChar(byte[] buffer, int bufferLength) {
        for (int i = 0; i < bufferLength; ++i) {
            if (buffer[i] != 0) continue;
            return true;
        }
        return false;
    }

    public File buildAndCheckDestinationFile(String aDirString) {
        if (aDirString == null) {
            throw new PackageRenamerException("Invalid destination directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (aDirFile.exists() && aDirFile.listFiles().length != 0) {
            throw new PackageRenamerException("Output Directory:" + this.CR + "  '" + aDirString + "'" + this.CR + "exists and is not empty.");
        }
        if (!aDirFile.isAbsolute()) {
            throw new PackageRenamerException("A relative destination directory was entered:" + this.CR + "  '" + aDirString + "'" + this.CR + "The directory must be absolute.");
        }
        if (PackageRenamer.directoryIsSubdirectory(this.sourceRootDirFile, aDirFile)) {
            throw new PackageRenamerException("Invalid destination directory entered:" + this.CR + "  '" + aDirString + "'" + this.CR + "It cannot be a sub-directory of the source directory.");
        }
        return aDirFile;
    }

    public File buildAndCheckExistingDirFile(String aDirString) {
        if (aDirString == null) {
            throw new PackageRenamerException("Invalid source directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (!aDirFile.exists() || !aDirFile.isDirectory()) {
            throw new PackageRenamerException("Input Directory:" + this.CR + "  '" + aDirString + "'" + this.CR + "does not exist or is not a directory.");
        }
        if (!aDirFile.isAbsolute()) {
            throw new PackageRenamerException("A relative source directory was entered:" + this.CR + "  '" + aDirString + "'" + this.CR + "The directory must be absolute.");
        }
        return aDirFile;
    }

    public PrintWriter buildAndCheckLogWriter(String logFileString) {
        if (logFileString == null) {
            throw new PackageRenamerException("Invalid log file name entered.");
        }
        try {
            if (logFileString.equals(SYSTEM_OUT)) {
                return new PrintWriter(System.out);
            }
            File aLogFile = new File(logFileString);
            if (aLogFile.exists()) {
                throw new PackageRenamerException("Specified log file cannot be created:" + this.CR + "  '" + logFileString + "'");
            }
            FileWriter writerLog = new FileWriter(logFileString);
            return new PrintWriter(writerLog);
        }
        catch (IOException ioException) {
            throw new PackageRenamerException("Unhandled IOException occurred while configuring log file: '" + logFileString + "', " + ioException.getMessage());
        }
    }

    protected void cleanup() {
        if (this.outLog != null) {
            this.outLog.close();
        }
    }

    public void createDestinationDirectory(File aDirectory) {
        if (!aDirectory.exists()) {
            if (!aDirectory.mkdirs()) {
                throw new PackageRenamerException("Error while creating directory:" + this.CR + "  '" + aDirectory.toString() + "'");
            }
        } else {
            throw new PackageRenamerException("Error directory: '" + aDirectory.toString() + "' already exists but shouldn't.");
        }
    }

    public static boolean directoryIsSubdirectory(File directory1, File directory2) {
        if (directory2 == null) {
            return false;
        }
        if (directory1.equals(directory2)) {
            return true;
        }
        return PackageRenamer.directoryIsSubdirectory(directory1, directory2.getParentFile());
    }

    public File existingDirectoryFromPrompt() {
        System.out.print("Enter the path of the directory which contains the files to rename:" + this.CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the source directory: " + exception.getMessage());
        }
        return this.buildAndCheckExistingDirFile(aLine);
    }

    public static String getDefaultPropertiesFileName() {
        String currentDirectory = System.getProperty("user.dir");
        return currentDirectory + File.separator + "packageRename.properties";
    }

    public synchronized BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.reader;
    }

    public boolean isExtensionSupported(String extension) {
        return true;
    }

    public void logln(String str) {
        this.outLog.println(str);
        this.outLog.flush();
    }

    public static void main(String[] args) {
        PackageRenamer instance = null;
        try {
            if (args.length == 0) {
                instance = new PackageRenamer();
                instance.run();
            } else if (args.length == 1) {
                instance = new PackageRenamer(args[0]);
                instance.run();
            } else if (args.length == 3 || args.length == 4) {
                instance = new PackageRenamer(args);
                instance.run();
            } else {
                PackageRenamer.usage();
                System.exit(-1);
            }
        }
        catch (PackageRenamerException exception) {
            PackageRenamer.usage();
            System.err.println("**************************************************************************");
            System.err.println("Error during package rename. PACKAGE RENAME FAILED.");
            System.err.println(exception.getMessage());
            System.err.println("**************************************************************************");
            System.exit(-1);
        }
        catch (Throwable unknowException) {
            System.err.println("Unhandled exception was thrown during rename:");
            unknowException.printStackTrace();
            System.exit(-1);
        }
        instance.logln("");
        instance.logln("PACKAGE RENAME WAS SUCCESSFUL");
        instance.cleanup();
    }

    public String parseFileExtension(File aFile) {
        int index = aFile.getName().lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return aFile.getName().substring(index + 1);
    }

    protected File promptForDestinationDirectory() {
        System.out.print("Enter the path of the directory to which files are to be copied:" + this.CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the destination directory specified: " + exception.getMessage());
        }
        return this.buildAndCheckDestinationFile(aLine);
    }

    public Properties readChangesFile(String filename) {
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(filename);
            props.load(in);
            ((InputStream)in).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PackageRenamerException("Properties file was not found:" + this.CR + "  '" + filename + "'");
        }
        catch (IOException ioException) {
            throw new PackageRenamerException("IO error occurred while reading the properties file:'" + filename + "'" + ioException.getMessage());
        }
        this.logln("Using properties file: " + filename);
        return props;
    }

    public void run() {
        this.logln("LOG MESSAGES FROM packageRenamer");
        this.logln("" + new Date());
        this.logln("");
        this.logln("INPUT: -----------------> " + this.sourceRootDirFile.toString());
        this.logln("OUTPUT: ----------------> " + this.destinationRootDir.toString());
        this.logln("");
        this.logln("Verifying root output directory...");
        if (!this.destinationRootDir.exists()) {
            this.logln("");
            this.logln("Creating root output directory...");
            this.createDestinationDirectory(this.destinationRootDir);
            this.logln("");
        }
        this.logln("Verifying root output directory...DONE");
        this.logln("");
        this.logln("List of changed file(s): ");
        this.logln("");
        this.traverseSourceDirectory(this.sourceRootDirFile);
        this.logln("");
        this.logln("Total Changed File(s): ------> " + this.numberOfChangedFile);
        this.logln("Total File(s):         ------> " + this.numberOfTotalFile);
        this.logln("");
    }

    protected PrintWriter streamForNonExistentFilePrompt() {
        System.out.print("Enter the absolute path of the log file [Hit Enter for SYSTEM.OUT]:" + this.CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the name of the log file: " + exception.getMessage());
        }
        if (aLine != null && aLine.length() == 0) {
            return this.buildAndCheckLogWriter(SYSTEM_OUT);
        }
        return this.buildAndCheckLogWriter(aLine);
    }

    public void runSearchAndReplacePackageName(File sourceFile) {
        String stringContainAllFile = "";
        String sourceFileName = sourceFile.toString();
        String sourceFileNameWithoutRoot = sourceFile.toString().substring(this.sourceRootDirFile.toString().length() + 1);
        sourceFileNameWithoutRoot = this.returnNewFileNameIfRequired(sourceFileNameWithoutRoot);
        String destinationFileName = this.destinationRootDir.toString() + File.separator + sourceFileNameWithoutRoot;
        try {
            FileInputStream fis = new FileInputStream(new File(sourceFileName));
            byte[] buf = new byte[this.BUFSIZ];
            StringBuffer strBuf = new StringBuffer((int)new File(sourceFileName).length());
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                if (this.bufferContainsNullChar(buf, i)) {
                    fis.close();
                    this.binaryCopy(sourceFile, new File(destinationFileName));
                    return;
                }
                String str = new String(buf, 0, i);
                strBuf.append(str);
            }
            fis.close();
            stringContainAllFile = new String(strBuf);
        }
        catch (IOException ioException) {
            throw new PackageRenamerException("Unexpected exception was thrown during file manipulation." + ioException.getMessage());
        }
        Vector<Object> aVector = new Vector<Object>();
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            aVector.addElement(e.nextElement());
        }
        Object[] aStringArrayOfSortedKeyPackageName = new String[aVector.size()];
        aVector.copyInto(aStringArrayOfSortedKeyPackageName);
        Object anArray = null;
        Arrays.sort(aStringArrayOfSortedKeyPackageName);
        boolean alreadyPrint = false;
        int index = aStringArrayOfSortedKeyPackageName.length;
        Enumeration<Object> enumtr = this.properties.keys();
        while (enumtr.hasMoreElements()) {
            String garbage = (String)enumtr.nextElement();
            Object key = aStringArrayOfSortedKeyPackageName[index - 1];
            String value = (String)this.properties.get(key);
            --index;
            int found = stringContainAllFile.indexOf((String)key);
            if (found != -1 && !alreadyPrint) {
                alreadyPrint = true;
                this.logln(this.numberOfChangedFile + 1 + ". " + destinationFileName);
                ++this.numberOfChangedFile;
            }
            stringContainAllFile = PackageRenamer.replace(stringContainAllFile, (String)key, value);
        }
        try {
            FileWriter writer = new FileWriter(destinationFileName);
            PrintWriter out = new PrintWriter(writer);
            out.print(stringContainAllFile);
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PackageRenamerException("Could not find file to write:" + this.CR + "  '" + destinationFileName + "'" + this.CR + fileNotFoundException.getMessage());
        }
        catch (IOException ioException) {
            throw new PackageRenamerException("Unexpected exception was thrown while writing the file: '" + destinationFileName + "', " + ioException.getMessage());
        }
    }

    public static String replace(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = str.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = str.indexOf(oldChars, lastPos);
        }
        return str;
    }

    public String returnNewFileNameIfRequired(String aSourceFileNameWithoutRoot) {
        Enumeration<Object> enumtr = this.properties.keys();
        while (enumtr.hasMoreElements()) {
            String key = (String)enumtr.nextElement();
            if (aSourceFileNameWithoutRoot.indexOf(key) == -1) continue;
            aSourceFileNameWithoutRoot = PackageRenamer.replace(aSourceFileNameWithoutRoot, key, (String)this.properties.get(key));
        }
        return aSourceFileNameWithoutRoot;
    }

    public void traverseSourceDirectory(File aDirectoryString) {
        File[] filesAndDirectories = aDirectoryString.listFiles();
        for (int i = 0; i < filesAndDirectories.length; ++i) {
            File fileOrDirectory = filesAndDirectories[i];
            if (fileOrDirectory.isDirectory()) {
                String sourceDirectoryName = fileOrDirectory.toString();
                String destinationDirectoryName = this.destinationRootDir.toString() + sourceDirectoryName.substring(this.sourceRootDirFile.toString().length(), sourceDirectoryName.length());
                this.createDestinationDirectory(new File(destinationDirectoryName));
                this.traverseSourceDirectory(fileOrDirectory);
                continue;
            }
            ++this.numberOfTotalFile;
            String fileExtension = this.parseFileExtension(fileOrDirectory);
            if (!this.isExtensionSupported(fileExtension)) continue;
            this.runSearchAndReplacePackageName(fileOrDirectory);
        }
    }

    public static void usage() {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println("");
        System.out.println("The package  renamer should  be run  once on user source code, configuration");
        System.out.println("files,  and   Mapping  Workbench  project  files  that  have  references  to");
        System.out.println("pre-Oracle 9iAS TopLink 9.0.3  API  packages.  The package renamer  works on");
        System.out.println("plain text files and should NOT be run on binary files such as JAR files.");
        System.out.println("");
        System.out.println("The package renamer supports two command line usages. A call which specifies");
        System.out.println("all the required arguments, and  a  call which takes only one parameter.  In");
        System.out.println("this last case, the user is prompted for the missing arguments.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file>");
        System.out.println("");
        System.out.println("OR");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file> <source-root-directory> <destination-root-directory> [ <log-file> ]");
        System.out.println("");
        System.out.println("where:");
        System.out.println("\t<properties-file> - File containing  a list of  old and new package");
        System.out.println("\tnames.");
        System.out.println("");
        System.out.println("\t<source-root-directory> - Absolute path name of the directory which");
        System.out.println("\tcontains all the file to be converted.  The <source-root-directory>");
        System.out.println("\twill be searched recursively for files  to convert.  This directory");
        System.out.println("\tshould contain only the plain text files to be converted.");
        System.out.println("");
        System.out.println("\t<destination-root-directory> - Absolute path name of  the directory");
        System.out.println("\twhere the converted directory  structure will be copied.  All files");
        System.out.println("\twill be copied to  the new directory structure whether changes were");
        System.out.println("\tmade or not. This directory must either not exist or be empty.");
        System.out.println("");
        System.out.println("\t<log-file> - The logging  of  the  renaming process will be written");
        System.out.println("\tto the <log-file>.  If no  <log-file>  is  specified  then  logging");
        System.out.println("\twill be written to standard output.");
        System.out.println("");
    }

    public class PackageRenamerException
    extends RuntimeException {
        public PackageRenamerException(String aMessage) {
            super(aMessage);
        }
    }
}

