/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private MessageDispatcher mDispatcher;
    private String[] mFileExtensions = new String[0];
    private final LocalizedMessages mMessages = new LocalizedMessages();

    protected abstract void processFiltered(File var1, List<String> var2);

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void beginProcessing(String aCharset) {
    }

    @Override
    public final TreeSet<LocalizedMessage> process(File aFile, List<String> aLines) {
        this.getMessageCollector().reset();
        if (this.fileExtensionMatches(aFile)) {
            this.processFiltered(aFile, aLines);
        }
        return this.getMessageCollector().getMessages();
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher aDispatcher) {
        this.mDispatcher = aDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.mDispatcher;
    }

    public final void setFileExtensions(String[] aExtensions) {
        if (aExtensions == null) {
            this.mFileExtensions = null;
            return;
        }
        this.mFileExtensions = new String[aExtensions.length];
        for (int i = 0; i < aExtensions.length; ++i) {
            String extension = aExtensions[i];
            this.mFileExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
        }
    }

    protected final LocalizedMessages getMessageCollector() {
        return this.mMessages;
    }

    @Override
    public final void log(int aLine, String aKey, Object ... aArgs) {
        this.log(aLine, 0, aKey, aArgs);
    }

    @Override
    public final void log(int aLineNo, int aColNo, String aKey, Object ... aArgs) {
        this.getMessageCollector().add(new LocalizedMessage(aLineNo, aColNo, this.getMessageBundle(), aKey, aArgs, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(aKey)));
    }

    protected final void fireErrors(String aFileName) {
        TreeSet<LocalizedMessage> errors = this.getMessageCollector().getMessages();
        this.getMessageCollector().reset();
        this.getMessageDispatcher().fireErrors(aFileName, errors);
    }

    private boolean fileExtensionMatches(File aFile) {
        if (null == this.mFileExtensions || this.mFileExtensions.length == 0) {
            return true;
        }
        String[] withDotExtensions = new String[this.mFileExtensions.length];
        for (int i = 0; i < this.mFileExtensions.length; ++i) {
            String extension = this.mFileExtensions[i];
            withDotExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
        }
        String fileName = aFile.getName();
        for (String fileExtension : withDotExtensions) {
            if (!fileName.endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }
}

