/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.filters.CSVFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressElement
implements Filter {
    private static final int HASH_MULT = 29;
    private final Pattern mFileRegexp;
    private final String mFilePattern;
    private Pattern mCheckRegexp;
    private String mCheckPattern;
    private String mModuleId;
    private CSVFilter mLineFilter;
    private String mLinesCSV;
    private CSVFilter mColumnFilter;
    private String mColumnsCSV;

    public SuppressElement(String aFiles) throws PatternSyntaxException {
        this.mFilePattern = aFiles;
        this.mFileRegexp = Utils.getPattern(aFiles);
    }

    public void setChecks(String aChecks) {
        this.mCheckPattern = aChecks;
        this.mCheckRegexp = Utils.getPattern(aChecks);
    }

    public void setModuleId(String aModuleId) {
        this.mModuleId = aModuleId;
    }

    public void setLines(String aLines) {
        this.mLinesCSV = aLines;
        this.mLineFilter = aLines != null ? new CSVFilter(aLines) : null;
    }

    public void setColumns(String aColumns) {
        this.mColumnsCSV = aColumns;
        this.mColumnFilter = aColumns != null ? new CSVFilter(aColumns) : null;
    }

    public boolean accept(AuditEvent aEvent) {
        if (aEvent.getFileName() == null || !this.mFileRegexp.matcher(aEvent.getFileName()).find() || aEvent.getLocalizedMessage() == null || this.mModuleId != null && !this.mModuleId.equals(aEvent.getModuleId()) || this.mCheckRegexp != null && !this.mCheckRegexp.matcher(aEvent.getSourceName()).find()) {
            return true;
        }
        if (this.mLineFilter == null && this.mColumnFilter == null) {
            return false;
        }
        if (this.mLineFilter != null && this.mLineFilter.accept(aEvent.getLine())) {
            return false;
        }
        return this.mColumnFilter == null || !this.mColumnFilter.accept(aEvent.getColumn());
    }

    public String toString() {
        return "SupressElement[files=" + this.mFilePattern + ",checks=" + this.mCheckPattern + ",lines=" + this.mLinesCSV + ",columns=" + this.mColumnsCSV + "]";
    }

    public int hashCode() {
        int result = 29 * this.mFilePattern.hashCode();
        if (this.mCheckPattern != null) {
            result = 29 * result + this.mCheckPattern.hashCode();
        }
        if (this.mModuleId != null) {
            result = 29 * result + this.mModuleId.hashCode();
        }
        if (this.mLinesCSV != null) {
            result = 29 * result + this.mLinesCSV.hashCode();
        }
        if (this.mColumnsCSV != null) {
            result = 29 * result + this.mColumnsCSV.hashCode();
        }
        return result;
    }

    public boolean equals(Object aObject) {
        if (aObject instanceof SuppressElement) {
            SuppressElement other = (SuppressElement)aObject;
            if (!this.mFilePattern.equals(other.mFilePattern)) {
                return false;
            }
            if (this.mCheckPattern != null ? !this.mCheckPattern.equals(other.mCheckPattern) : other.mCheckPattern != null) {
                return false;
            }
            if (this.mModuleId != null ? !this.mModuleId.equals(other.mModuleId) : other.mModuleId != null) {
                return false;
            }
            if (this.mLineFilter != null ? !this.mLineFilter.equals(other.mLineFilter) : other.mLineFilter != null) {
                return false;
            }
            return !(this.mColumnFilter != null ? !this.mColumnFilter.equals(other.mColumnFilter) : other.mColumnFilter != null);
        }
        return false;
    }
}

