/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant;

import com.nokia.helium.core.ant.HlmDefinition;
import com.nokia.helium.core.ant.HlmExceptionHandler;
import com.nokia.helium.core.ant.types.HlmDefList;
import com.nokia.helium.core.ant.types.HlmPostDefImpl;
import com.nokia.helium.core.ant.types.HlmPreDefImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.helper.DefaultExecutor;
import org.apache.tools.ant.taskdefs.ImportTask;

public class HeliumExecutor
extends DefaultExecutor {
    private HashMap<String, Vector<HlmDefinition>> preOperations = new HashMap();
    private HashMap<String, Vector<HlmDefinition>> postOperations = new HashMap();
    private HashMap<String, Vector<HlmExceptionHandler>> exceptionHandlers = new HashMap();
    private Project project;
    private Logger log = Logger.getLogger(HeliumExecutor.class);

    public void executeTargets(Project project, String[] targetNames) {
        this.project = project;
        this.log.debug((Object)"Running executeTargets");
        BuildException failure = null;
        try {
            this.loadModules(project);
            this.doOperations(this.preOperations, project, targetNames);
            super.executeTargets(project, targetNames);
        }
        catch (BuildException e) {
            failure = e;
        }
        try {
            this.doOperations(this.postOperations, project, targetNames);
        }
        catch (BuildException e) {
            failure = failure != null ? new BuildException(e.toString() + failure.toString()) : e;
        }
        if (failure != null) {
            this.handleExceptions(project, (Exception)((Object)failure));
            throw failure;
        }
    }

    private void loadModules(Project prj) {
        List<File> moduleList = this.loadAvailableModules();
        for (File moduleName : moduleList) {
            this.loadModule(moduleName, prj);
        }
    }

    private void loadModule(File moduleLib, Project prj) {
        String file = this.getHlmAntLibFile(moduleLib);
        if (file == null) {
            return;
        }
        this.log.debug((Object)("Loading " + moduleLib.getName()));
        ImportTask task = new ImportTask();
        Target target = new Target();
        target.setName("");
        target.setProject(prj);
        task.setOwningTarget(target);
        task.setLocation(new Location(file));
        task.setFile(file);
        task.setProject(prj);
        task.execute();
        String moduleName = this.getModuleName(moduleLib);
        Object refObject = prj.getReference(moduleName + ".list");
        if (refObject == null) {
            this.log.debug((Object)(moduleName + ".list not found"));
        }
        if (refObject != null && refObject instanceof HlmDefList) {
            Vector<HlmExceptionHandler> tempExceptionDefList;
            Vector<HlmPostDefImpl> tempPostDefList;
            HlmDefList defList = (HlmDefList)((Object)refObject);
            Vector<HlmPreDefImpl> tempDefList = new Vector<HlmPreDefImpl>(defList.getPreDefList());
            if (tempDefList != null) {
                this.preOperations.put(moduleName, tempDefList);
            }
            if ((tempPostDefList = new Vector<HlmPostDefImpl>(defList.getPostDefList())) != null) {
                this.postOperations.put(moduleName, tempPostDefList);
            }
            if ((tempExceptionDefList = defList.getExceptionHandlerList()) != null) {
                this.exceptionHandlers.put(moduleName, tempExceptionDefList);
            }
            this.log.debug((Object)("loadModule:pre-opsize" + this.preOperations.size()));
            this.log.debug((Object)("loadModule:post-opsize" + this.postOperations.size()));
            this.log.debug((Object)("loadModule:exception-opsize" + this.exceptionHandlers.size()));
            this.log.debug((Object)("Checking " + moduleLib));
        }
    }

    protected URL findHeliumAntlibXml(File moduleLib) throws IOException {
        JarFile jarFile = new JarFile(moduleLib);
        Enumeration<JarEntry> jee = jarFile.entries();
        while (jee.hasMoreElements()) {
            JarEntry je = jee.nextElement();
            if (!je.getName().endsWith("/helium.antlib.xml")) continue;
            return new URL("jar:" + moduleLib.toURI().toString() + "!/" + je.getName());
        }
        return null;
    }

    private String getHlmAntLibFile(File moduleLib) {
        this.log.debug((Object)("[HeliumExecutor] Checking " + moduleLib));
        try {
            String line;
            URL url = this.findHeliumAntlibXml(moduleLib);
            if (url == null) {
                return null;
            }
            this.log.debug((Object)("Getting " + url));
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarEntry jarEntry = jarConnection.getJarEntry();
            JarFile jarFile = new JarFile(moduleLib);
            InputStream is = jarFile.getInputStream(jarEntry);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(isr);
            File file = File.createTempFile("helium", "antlib.xml");
            file.deleteOnExit();
            FileWriter writer = new FileWriter(file);
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
            writer.close();
            reader.close();
            this.log.debug((Object)("Temp file " + file.getAbsolutePath()));
            return file.getAbsolutePath();
        }
        catch (Exception ex) {
            this.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private void doOperations(HashMap<String, Vector<HlmDefinition>> operations, Project prj, String[] targetNames) {
        this.log.debug((Object)"doOperations: start");
        for (String moduleName : operations.keySet()) {
            this.log.debug((Object)("doOperations: module" + moduleName));
            for (HlmDefinition definition : operations.get(moduleName)) {
                definition.execute(prj, moduleName, targetNames);
            }
        }
    }

    private void handleExceptions(Project prj, Exception e) {
        for (String moduleName : this.exceptionHandlers.keySet()) {
            this.log.debug((Object)("handleExceptions: module" + moduleName));
            for (HlmExceptionHandler exceptionHandler : this.exceptionHandlers.get(moduleName)) {
                exceptionHandler.handleException(prj, moduleName, e);
            }
        }
    }

    private String getModuleName(File moduleLib) {
        String name = moduleLib.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    private List<File> loadAvailableModules() {
        ArrayList<File> moduleList = new ArrayList<File>();
        String classpathString = System.getProperty("java.class.path");
        StringTokenizer tokenizier = new StringTokenizer(classpathString, File.pathSeparator);
        while (tokenizier.hasMoreTokens()) {
            String token = tokenizier.nextToken();
            if (!new File(token).isFile() || !token.endsWith(".jar")) continue;
            moduleList.add(new File(token));
        }
        return moduleList;
    }

    protected Project getProject() {
        return this.project;
    }
}

