/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.ant.types;

import com.nokia.helium.imaker.ant.types.MakefileSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class Product
extends DataType
implements MakefileSelector {
    private String list;
    private boolean ui;
    private boolean failOnError = true;

    public void setList(String list) {
        this.list = list;
    }

    public String[] getNames() {
        Vector<String> names = new Vector<String>();
        for (String name : this.list.split(",")) {
            if ((name = name.trim()).length() <= 0) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public void setUi(boolean ui) {
        this.ui = ui;
    }

    public boolean isUi() {
        return this.ui;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public List<String> selectMakefile(List<String> configurations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String product : this.getNames()) {
            String endOfString = "image_conf_" + product + (this.ui ? "_ui" : "") + ".mk";
            boolean foundConfig = false;
            for (String config : configurations) {
                if (!config.endsWith(endOfString)) continue;
                foundConfig = true;
                result.add(config);
                break;
            }
            if (foundConfig) continue;
            if (this.isFailOnError()) {
                throw new BuildException("Could not find a valid configuration for " + product);
            }
            this.log("Could not find a valid configuration for " + product, 0);
        }
        return result;
    }
}

