/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data;

import com.nokia.helium.ant.data.AntObjectMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public class TaskContainerMeta
extends AntObjectMeta {
    private ArrayList<String> antcallTargets;
    private ArrayList<String> logs;
    private ArrayList<String> signals;
    private ArrayList<String> executables;

    public TaskContainerMeta(AntObjectMeta parent, Node node) throws IOException {
        super(parent, node);
        this.callAntTargetVisitor();
    }

    public List<String> getExecTargets() {
        return this.antcallTargets;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public List<String> getSignals() {
        return this.signals;
    }

    public List<String> getExecutables() {
        return this.executables;
    }

    private void callAntTargetVisitor() throws IOException {
        this.antcallTargets = new ArrayList();
        this.logs = new ArrayList();
        this.signals = new ArrayList();
        this.executables = new ArrayList();
        AntTargetVisitor visitorTarget = new AntTargetVisitor(this.antcallTargets, this.logs, this.signals, this.executables);
        this.getNode().accept((Visitor)visitorTarget);
    }

    private class AntTargetVisitor
    extends VisitorSupport {
        private List<String> targetList;
        private List<String> logList;
        private List<String> signalList;
        private List<String> executableList;

        public AntTargetVisitor(List<String> targetList, List<String> logList, List<String> signalList, List<String> executableList) {
            this.targetList = targetList;
            this.logList = logList;
            this.signalList = signalList;
            this.executableList = executableList;
        }

        public void visit(Element node) {
            String text;
            String name = node.getName();
            if (name.equals("antcall") || name.equals("runtarget")) {
                text = node.attributeValue("target");
                this.targetList.add(text);
            }
            if (!name.equals("include") && !name.equals("exclude")) {
                text = node.attributeValue("name");
                this.addLog(text);
                text = node.attributeValue("output");
                this.addLog(text);
                text = node.attributeValue("value");
                this.addLog(text);
                text = node.attributeValue("log");
                this.addLog(text);
                text = node.attributeValue("line");
                this.addLog(text);
                text = node.attributeValue("file");
                this.addLog(text);
            }
            if (name.endsWith("signal") || name.endsWith("execSignal")) {
                String signalid = node.attributeValue("name");
                if (this.signalList != null) {
                    this.signalList.add(signalid);
                }
            }
            if (name.equals("exec") || name.equals("preset.exec")) {
                text = node.attributeValue("executable");
                this.executableList.add(text);
                TaskContainerMeta.this.log("Executable: " + text, 4);
            }
        }

        private void addLog(String text) {
            if (text != null && this.logList != null) {
                String[] arr$ = text.split(" ");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String log;
                    String fulllogname = log = arr$[i$];
                    if (this.logList.contains(log) || !fulllogname.endsWith(".log") && !fulllogname.endsWith(".html")) continue;
                    log = log.replace("--log=", "");
                    this.logList.add(log);
                }
            }
        }
    }
}

