/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;

public class HeliumLogger
extends DefaultLogger {
    private static boolean stopLogToConsole;
    private Project project;
    private Log log = LogFactory.getLog(HeliumLogger.class);

    public void buildStarted(BuildEvent event) {
        this.project = event.getProject();
        super.buildStarted(event);
    }

    public void targetStarted(BuildEvent event) {
        String ifCondition = "";
        String unlessCondition = "";
        String targetName = event.getTarget().getName();
        this.logTargetEvent(targetName, "start");
        ifCondition = event.getTarget().getIf();
        unlessCondition = event.getTarget().getUnless();
        this.project = event.getProject();
        super.targetStarted(event);
        if (!this.testIfCondition(ifCondition) && ifCondition != null) {
            this.project.log("Skipped because property '" + this.project.replaceProperties(ifCondition) + "' not set.", 2);
        } else if (!this.testUnlessCondition(unlessCondition) && unlessCondition != null) {
            this.project.log("Skipped because property '" + this.project.replaceProperties(unlessCondition) + "' set.", 2);
        }
    }

    private void logTargetEvent(String targetName, String event) {
        String logTargetProperty = this.project.getProperty("log.target");
        if (logTargetProperty != null && logTargetProperty.equals("yes")) {
            this.log.info((Object)("Target #### " + targetName + " ####: " + event));
        }
    }

    public void targetFinished(BuildEvent event) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = sdf.format(Calendar.getInstance().getTime());
        String targetName = time + "," + event.getTarget().getName();
        this.logTargetEvent(targetName, "finish");
    }

    public void buildFinished(BuildEvent event) {
        stopLogToConsole = false;
        this.cleanup();
        super.buildFinished(event);
    }

    private void cleanup() {
        File f;
        String loggingoutputfile = this.project.getProperty("logging.output.file");
        if (loggingoutputfile != null && (f = new File(loggingoutputfile)).exists()) {
            f.delete();
        }
        if (this.project.getProperty("call.cleanup") != null && this.project.getProperty("call.cleanup").equals("yes")) {
            this.project.executeTarget("cleanup-all");
        }
    }

    public static boolean getStopLogToConsole() {
        return stopLogToConsole;
    }

    public static void setStopLogToConsole(boolean stop) {
        stopLogToConsole = stop;
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        if (!stopLogToConsole) {
            stream.println(message);
        }
    }

    private boolean testIfCondition(String ifCondition) {
        if ("".equals(ifCondition)) {
            return true;
        }
        String test = this.project.replaceProperties(ifCondition);
        return this.project.getProperty(test) != null;
    }

    private boolean testUnlessCondition(String unlessCondition) {
        if ("".equals(unlessCondition)) {
            return true;
        }
        String test = this.project.replaceProperties(unlessCondition);
        return this.project.getProperty(test) == null;
    }
}

