/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.TextLogMetaDataInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class AbldLogMetaDataInput
extends TextLogMetaDataInput {
    private Logger log = Logger.getLogger(AbldLogMetaDataInput.class);
    private Pattern abldFinishedPattern = Pattern.compile("^===\\s+.+\\s+finished.*");
    private Pattern abldStartedPattern = Pattern.compile("^===\\s+(.+)\\s+started.*");
    private Pattern abldComponentPattern = Pattern.compile("^===\\s+(.+?)\\s+==\\s+(.+)");
    private String currentComponent;
    private boolean entryCreated;
    private boolean recordText;

    @Override
    public boolean isEntryAvailable() {
        String exceptions = "";
        int currentFileIndex = this.getCurrentFileIndex();
        int lineNumber = this.getLineNumber();
        BufferedReader currentReader = this.getCurrentReader();
        this.log.debug((Object)"Getting next set of log entries for Abld Input");
        List<File> fileList = this.getFileList();
        int fileListSize = fileList.size();
        this.log.debug((Object)("fileList.size" + fileListSize));
        while (currentFileIndex < fileListSize) {
            try {
                File currentFile = fileList.get(currentFileIndex);
                if (currentReader == null) {
                    lineNumber = 0;
                    this.setLineNumber(lineNumber);
                    this.log.debug((Object)("Current abld log file name:" + currentFile));
                    this.log.info((Object)("Processing file: " + currentFile));
                    currentReader = new BufferedReader(new FileReader(currentFile));
                    this.setCurrentReader(currentReader);
                }
                String logText = null;
                while ((logText = currentReader.readLine()) != null) {
                    String severity;
                    this.setLineNumber(++lineNumber);
                    logText = logText.replaceFirst("'^\\s*\\[.+?\\]\\s*", "");
                    if (logText.startsWith("++ Finished at")) {
                        if (this.currentComponent != null && !this.entryCreated) {
                            this.addEntry("DEFAULT", this.currentComponent, currentFile.toString(), 0, "");
                            this.entryCreated = true;
                            this.recordText = false;
                            return true;
                        }
                        this.entryCreated = false;
                        continue;
                    }
                    if (logText.startsWith("=== ")) {
                        Matcher startMatch;
                        Matcher finishMatch = this.abldFinishedPattern.matcher(logText);
                        if (finishMatch.matches()) {
                            if (this.currentComponent != null && !this.entryCreated) {
                                this.addEntry("DEFAULT", this.currentComponent, currentFile.toString(), 0, "");
                                this.entryCreated = true;
                                this.recordText = false;
                                return true;
                            }
                            this.entryCreated = false;
                            continue;
                        }
                        Matcher componentMatch = this.abldComponentPattern.matcher(logText);
                        if (componentMatch.matches()) {
                            this.currentComponent = componentMatch.group(2);
                            this.recordText = true;
                        }
                        if (!(startMatch = this.abldStartedPattern.matcher(logText)).matches()) continue;
                        this.currentComponent = startMatch.group(1);
                        this.recordText = true;
                        continue;
                    }
                    if (!this.recordText || (severity = this.getSeverity(logText)) == null) continue;
                    this.entryCreated = true;
                    this.addEntry(severity, this.currentComponent, currentFile.toString(), lineNumber, logText);
                    return true;
                }
                currentReader.close();
                currentReader = null;
                this.setCurrentReader(currentReader);
                this.setCurrentFileIndex(++currentFileIndex);
            }
            catch (Exception ex) {
                this.log.debug((Object)"Exception in AbldLogMetadata", (Throwable)ex);
                try {
                    currentReader.close();
                }
                catch (IOException iex) {
                    this.log.debug((Object)"Exception in closing reader");
                }
                currentReader = null;
                this.setCurrentReader(null);
                exceptions = exceptions + ex.getMessage() + "\n";
                return false;
            }
        }
        if (!exceptions.equals("")) {
            throw new BuildException(exceptions);
        }
        return false;
    }
}

