/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask.ant;

import com.oopsconsultancy.xmltask.InsertAction;
import com.oopsconsultancy.xmltask.XmlReplace;
import com.oopsconsultancy.xmltask.ant.Instruction;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Insert
implements Instruction {
    private XmlTask task = null;
    private String path = null;
    private String text = null;
    private InsertAction action = null;
    private InsertAction.Position position = InsertAction.Position.UNDER;
    private boolean expandProperties = true;
    private String buffer;
    private String xml;
    private File file;
    private String ifProperty;
    private String unlessProperty;

    public void setPath(String path) {
        this.path = path;
    }

    public void setPosition(String pos) {
        if ("before".equals(pos)) {
            this.position = InsertAction.Position.BEFORE;
        } else if ("after".equals(pos)) {
            this.position = InsertAction.Position.AFTER;
        } else if ("under".equals(pos)) {
            this.position = InsertAction.Position.UNDER;
        } else {
            this.log("Don't recognise position '" + pos + "'", 1);
        }
        if (this.action != null) {
            this.action.setPosition(this.position);
        }
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }

    public void setXml(String xml) throws Exception {
        this.xml = xml;
    }

    public void setFile(File file) throws Exception {
        this.file = file;
    }

    public void setExpandProperties(boolean expandProperties) {
        this.expandProperties = expandProperties;
    }

    public void addText(String text) throws Exception {
        this.text = text;
    }

    public void setBuffer(String buffer) throws Exception {
        this.buffer = buffer;
    }

    private void register() {
        try {
            if (this.xml != null) {
                this.action = InsertAction.fromString(this.xml, this.task);
            } else if (this.file != null) {
                this.action = InsertAction.fromFile(this.file, this.task);
            } else if (this.buffer != null) {
                this.action = InsertAction.fromBuffer(this.buffer, this.task);
            } else if (this.text != null) {
                if (this.expandProperties) {
                    this.text = ProjectHelper.replaceProperties((Project)this.task.getProject(), (String)this.text, (Hashtable)this.task.getProject().getProperties());
                }
                this.action = InsertAction.fromString(this.text, this.task);
            }
        }
        catch (Exception e) {
            throw new BuildException("Failed to add text to insert/paste", (Throwable)e);
        }
        if (this.action != null && this.path != null) {
            this.action.setPosition(this.position);
            XmlReplace xmlReplace = new XmlReplace(this.path, this.action);
            xmlReplace.setIf(this.ifProperty);
            xmlReplace.setUnless(this.unlessProperty);
            this.task.add(xmlReplace);
        }
    }

    public void process(XmlTask task) {
        this.task = task;
        this.register();
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }
}

