/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.core.resolve.VisitNode;

public class ResolveData {
    private ResolveEngine engine;
    private Map visitData;
    private ConfigurationResolveReport report;
    private ResolveOptions options;

    public ResolveData(ResolveData data, boolean validate) {
        this(data.engine, new ResolveOptions(data.options).setValidate(validate), data.report, data.visitData);
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options) {
        this(engine, options, null, new LinkedHashMap());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options, ConfigurationResolveReport report) {
        this(engine, options, report, new LinkedHashMap());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options, ConfigurationResolveReport report, Map visitData) {
        this.engine = engine;
        this.report = report;
        this.visitData = visitData;
        this.options = options;
    }

    public ConfigurationResolveReport getReport() {
        return this.report;
    }

    public IvyNode getNode(ModuleRevisionId mrid) {
        VisitData visitData = this.getVisitData(mrid);
        return visitData == null ? null : visitData.getNode();
    }

    public Collection getNodes() {
        ArrayList<IvyNode> nodes = new ArrayList<IvyNode>();
        Iterator iter = this.visitData.values().iterator();
        while (iter.hasNext()) {
            VisitData vdata = (VisitData)iter.next();
            nodes.add(vdata.getNode());
        }
        return nodes;
    }

    public Collection getNodeIds() {
        return this.visitData.keySet();
    }

    public VisitData getVisitData(ModuleRevisionId mrid) {
        return (VisitData)this.visitData.get(mrid);
    }

    public void register(VisitNode node) {
        this.register(node.getId(), node);
    }

    public void register(ModuleRevisionId mrid, VisitNode node) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            visitData = new VisitData(node.getNode());
            visitData.addVisitNode(node);
            this.visitData.put(mrid, visitData);
        } else {
            visitData.setNode(node.getNode());
            visitData.addVisitNode(node);
        }
    }

    void replaceNode(ModuleRevisionId mrid, IvyNode node, String rootModuleConf) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            throw new IllegalArgumentException("impossible to replace node for id " + mrid + ". No registered node found.");
        }
        VisitData keptVisitData = this.getVisitData(node.getId());
        if (keptVisitData == null) {
            throw new IllegalArgumentException("impossible to replace node with " + node + ". No registered node found for " + node.getId() + ".");
        }
        this.visitData.put(mrid, keptVisitData);
        keptVisitData.addVisitNodes(rootModuleConf, visitData.getVisitNodes(rootModuleConf));
    }

    public void setReport(ConfigurationResolveReport report) {
        this.report = report;
    }

    public Date getDate() {
        return this.options.getDate();
    }

    public boolean isValidate() {
        return this.options.isValidate();
    }

    public boolean isTransitive() {
        return this.options.isTransitive();
    }

    public ResolveOptions getOptions() {
        return this.options;
    }

    public ResolveEngineSettings getSettings() {
        return this.engine.getSettings();
    }

    public EventManager getEventManager() {
        return this.engine.getEventManager();
    }

    public ResolveEngine getEngine() {
        return this.engine;
    }

    void blacklist(IvyNode node) {
        Iterator iter = this.visitData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            VisitData vdata = (VisitData)entry.getValue();
            if (vdata.getNode() != node || node.getResolvedId().equals(entry.getKey())) continue;
            iter.remove();
        }
    }

    public boolean isBlacklisted(String rootModuleConf, ModuleRevisionId mrid) {
        IvyNode node = this.getNode(mrid);
        return node != null && node.isBlacklisted(rootModuleConf);
    }
}

