/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateInputSource;
import com.nokia.helium.core.TemplateProcessor;
import com.nokia.helium.core.ant.HlmExceptionHandler;
import com.nokia.helium.diamonds.DiamondsClient;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListenerImpl;
import com.nokia.helium.diamonds.DiamondsProperties;
import com.nokia.helium.signal.SignalStatus;
import com.nokia.helium.signal.SignalStatusList;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;

public class DiamondsExceptionStatusUpdate
implements HlmExceptionHandler {
    private Logger log = Logger.getLogger(DiamondsExceptionStatusUpdate.class);
    private String buildStatus = "failed";
    private SimpleDateFormat timeFormat;
    private TemplateProcessor templateProcessor;
    private Hashtable<String, String> signalInformation = new Hashtable();
    private String outputFile;
    private String templateFile;
    private List<TemplateInputSource> sourceList = new ArrayList<TemplateInputSource>();

    public void handleException(Project project, String module, Exception e) {
        this.templateProcessor = new TemplateProcessor();
        Properties tempProperties = new Properties();
        String templateDir = DiamondsConfig.getTemplateDir();
        DiamondsProperties diamondsProperties = DiamondsConfig.getDiamondsProperties();
        if (DiamondsListenerImpl.isInitialized()) {
            int i;
            Vector signalList;
            this.timeFormat = new SimpleDateFormat(DiamondsConfig.getDiamondsProperties().getProperty("tstampformat"));
            DiamondsClient diamondsClient = new DiamondsClient(project.getProperty(diamondsProperties.getProperty("host")), project.getProperty(diamondsProperties.getProperty("port")), project.getProperty(diamondsProperties.getProperty("path")), project.getProperty(diamondsProperties.getProperty("mail")));
            if (SignalStatusList.getDeferredSignalList().hasSignalInList()) {
                signalList = SignalStatusList.getDeferredSignalList().getSignalStatusList();
                this.timeFormat = new SimpleDateFormat(DiamondsConfig.getDiamondsProperties().getProperty("tstampformat"));
                this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => Build Status = " + this.buildStatus));
                i = 0;
                for (SignalStatus status : signalList) {
                    this.signalInformation.put("diamond.signal.name." + i, status.getName());
                    this.signalInformation.put("diamond.error.message." + i, status.getMessage());
                    this.signalInformation.put("diamond.time.stamp." + i, new String(this.timeFormat.format(status.getTimestamp())));
                    ++i;
                }
                this.templateFile = "diamonds_signal.xml.ftl";
                this.outputFile = DiamondsConfig.getOutputDir() + File.separator + "diamonds-signal.xml";
                this.sourceList.add((TemplateInputSource)new PropertiesSource("diamondSignal", this.signalInformation));
                this.templateProcessor.convertTemplate(templateDir, this.templateFile, this.outputFile, this.sourceList);
                this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => sending data to diamonds ..." + this.outputFile));
                diamondsClient.sendData(this.outputFile, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
                try {
                    DiamondsListenerImpl.mergeToFullResults(new File(this.outputFile));
                }
                catch (DiamondsException de) {
                    this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => " + de.getMessage()));
                }
            }
            if (SignalStatusList.getNowSignalList().hasSignalInList()) {
                signalList = SignalStatusList.getNowSignalList().getSignalStatusList();
                this.buildStatus = "failed";
                this.timeFormat = new SimpleDateFormat(DiamondsConfig.getDiamondsProperties().getProperty("tstampformat"));
                this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => Build Status = " + this.buildStatus));
                i = 0;
                for (SignalStatus status : signalList) {
                    this.signalInformation.put("diamond.signal.name." + i, status.getName());
                    this.signalInformation.put("diamond.error.message." + i, status.getMessage());
                    this.signalInformation.put("diamond.time.stamp." + i, new String(this.timeFormat.format(status.getTimestamp())));
                    ++i;
                }
                this.templateFile = "diamonds_signal.xml.ftl";
                this.outputFile = DiamondsConfig.getOutputDir() + File.separator + "diamonds-signal.xml";
                this.sourceList.add((TemplateInputSource)new PropertiesSource("diamondSignal", this.signalInformation));
                this.templateProcessor.convertTemplate(templateDir, this.templateFile, this.outputFile, this.sourceList);
                this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => sending data to diamonds ..." + this.outputFile));
                diamondsClient.sendData(this.outputFile, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
                try {
                    DiamondsListenerImpl.mergeToFullResults(new File(this.outputFile));
                }
                catch (DiamondsException de) {
                    this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => " + de.getMessage()));
                }
            }
            tempProperties.put("build.status", this.buildStatus);
            this.sourceList.add((TemplateInputSource)new PropertiesSource("ant", (Map)project.getProperties()));
            this.sourceList.add((TemplateInputSource)new PropertiesSource("diamonds", tempProperties));
            this.outputFile = DiamondsConfig.getOutputDir() + File.separator + "diamonds-status.xml";
            this.templateFile = "diamonds_status.xml.ftl";
            this.templateProcessor.convertTemplate(templateDir, this.templateFile, this.outputFile, this.sourceList);
            this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => sending data to diamonds ..." + this.outputFile));
            diamondsClient.sendData(this.outputFile, DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
            try {
                DiamondsListenerImpl.mergeToFullResults(new File(this.outputFile));
            }
            catch (DiamondsException de) {
                this.log.debug((Object)("[DiamondsExceptionStatusUpdate] => " + de.getMessage()));
            }
        }
    }
}

