/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class DualResolver
extends AbstractResolver {
    private DependencyResolver ivyResolver;
    private DependencyResolver artifactResolver;
    private boolean allownomd = true;

    public void add(DependencyResolver resolver) {
        if (this.ivyResolver == null) {
            this.ivyResolver = resolver;
        } else if (this.artifactResolver == null) {
            this.artifactResolver = resolver;
        } else {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        ResolvedModuleRevision mr = this.ivyResolver.getDependency(dd, data = new ResolveData(data, this.doValidate(data)));
        if (mr == null) {
            this.checkInterrupted();
            if (this.isAllownomd()) {
                Message.verbose("ivy resolver didn't find " + dd.getDependencyRevisionId() + ": trying with artifact resolver");
                return this.artifactResolver.getDependency(dd, data);
            }
            return null;
        }
        return new ResolvedModuleRevision(mr.getResolver(), this, mr.getDescriptor(), mr.getReport());
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        return this.ivyResolver.findIvyFileRef(dd, data);
    }

    public void reportFailure() {
        this.ivyResolver.reportFailure();
        this.artifactResolver.reportFailure();
    }

    public void reportFailure(Artifact art) {
        this.ivyResolver.reportFailure(art);
        this.artifactResolver.reportFailure(art);
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        return this.artifactResolver.download(artifacts, options);
    }

    public DependencyResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(DependencyResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public DependencyResolver getIvyResolver() {
        return this.ivyResolver;
    }

    public void setIvyResolver(DependencyResolver ivyResolver) {
        this.ivyResolver = ivyResolver;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        if ("ivy".equals(artifact.getType())) {
            this.ivyResolver.publish(artifact, src, overwrite);
        } else {
            this.artifactResolver.publish(artifact, src, overwrite);
        }
    }

    public void abortPublishTransaction() throws IOException {
        this.ivyResolver.abortPublishTransaction();
        this.artifactResolver.abortPublishTransaction();
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
        this.ivyResolver.beginPublishTransaction(module, overwrite);
        this.artifactResolver.beginPublishTransaction(module, overwrite);
    }

    public void commitPublishTransaction() throws IOException {
        this.ivyResolver.commitPublishTransaction();
        this.artifactResolver.commitPublishTransaction();
    }

    public void dumpSettings() {
        if (this.ivyResolver == null || this.artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        Message.verbose("\t" + this.getName() + " [dual " + this.ivyResolver.getName() + " " + this.artifactResolver.getName() + "]");
    }

    public boolean exists(Artifact artifact) {
        return this.artifactResolver.exists(artifact);
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }

    public void setAllownomd(boolean allownomd) {
        this.allownomd = allownomd;
    }
}

