/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

final class Identifier
extends Expression {
    private final String name;

    Identifier(String name) {
        this.name = name;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        try {
            return env.getVariable(this.name);
        }
        catch (NullPointerException e) {
            if (env == null) {
                throw new TemplateException("Variables are not available (certainly you are in a parse-time executed directive). The name of the variable you tried to read: " + this.name, null);
            }
            throw e;
        }
    }

    public String toString() {
        return this.name;
    }

    public String getCanonicalForm() {
        return this.name;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        if (this.name.equals(name)) {
            return subst.deepClone(null, null);
        }
        return new Identifier(this.name);
    }
}

