/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.expose.ExposedType;
import org.python.modules._codecs$EncodingMap$PyExposer;

public class _codecs {
    public static void register(PyObject search_function) {
        codecs.register(search_function);
    }

    public static PyTuple lookup(String encoding) {
        return codecs.lookup(encoding);
    }

    public static PyObject lookup_error(String handlerName) {
        return codecs.lookup_error(handlerName);
    }

    public static void register_error(String name, PyObject errorHandler) {
        codecs.register_error(name, errorHandler);
    }

    public static PyObject charmap_build(PyUnicode map) {
        return EncodingMap.buildEncodingMap(map);
    }

    private static PyTuple decode_tuple(String s, int len) {
        return new PyTuple(new PyUnicode(s), Py.newInteger(len));
    }

    private static PyTuple decode_tuple_str(String s, int len) {
        return new PyTuple(new PyString(s), Py.newInteger(len));
    }

    private static PyTuple encode_tuple(String s, int len) {
        return new PyTuple(new PyString(s), Py.newInteger(len));
    }

    public static PyTuple utf_8_decode(String str) {
        return _codecs.utf_8_decode(str, null);
    }

    public static PyTuple utf_8_decode(String str, String errors) {
        return _codecs.utf_8_decode(str, errors, false);
    }

    public static PyTuple utf_8_decode(String str, String errors, boolean final_) {
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF8Stateful(str, errors, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_8_encode(String str) {
        return _codecs.utf_8_encode(str, null);
    }

    public static PyTuple utf_8_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF8(str, errors), size);
    }

    public static PyTuple utf_7_decode(String str) {
        return _codecs.utf_7_decode(str, null);
    }

    public static PyTuple utf_7_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF7(str, errors), size);
    }

    public static PyTuple utf_7_encode(String str) {
        return _codecs.utf_7_encode(str, null);
    }

    public static PyTuple utf_7_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF7(str, false, false, errors), size);
    }

    public static PyTuple escape_decode(String str) {
        return _codecs.escape_decode(str, null);
    }

    public static PyTuple escape_decode(String str, String errors) {
        return _codecs.decode_tuple_str(PyString.decode_UnicodeEscape(str, 0, str.length(), errors, true), str.length());
    }

    public static PyTuple escape_encode(String str) {
        return _codecs.escape_encode(str, null);
    }

    public static PyTuple escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple charmap_decode(String str, String errors, PyObject mapping) {
        return _codecs.charmap_decode(str, errors, mapping, false);
    }

    public static PyTuple charmap_decode(String str, String errors, PyObject mapping, boolean ignoreUnmapped) {
        int size = str.length();
        StringBuilder v = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u00ff') {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger w = Py.newInteger(ch);
            PyObject x = mapping.__finditem__(w);
            if (x == null) {
                if (ignoreUnmapped) {
                    v.append(ch);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "no mapping found") - 1;
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                v.append((char)value);
                continue;
            }
            if (x == Py.None) {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (x instanceof PyString) {
                v.append(x.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.decode_tuple(v.toString(), size);
    }

    public static PyTuple translate_charmap(String str, String errors, PyObject mapping, boolean ignoreUnmapped) {
        int size = str.length();
        StringBuilder v = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u00ff') {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger w = Py.newInteger(ch);
            PyObject x = mapping.__finditem__(w);
            if (x == null) {
                if (ignoreUnmapped) {
                    v.append(ch);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "no mapping found") - 1;
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                v.append((char)value);
                continue;
            }
            if (x == Py.None) {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", str, i, i + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (x instanceof PyUnicode) {
                v.append(x.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return _codecs.decode_tuple(v.toString(), size);
    }

    public static PyTuple charmap_encode(String str, String errors, PyObject mapping) {
        if (mapping == null) {
            return _codecs.latin_1_encode(str, errors);
        }
        return _codecs.charmap_encode_internal(str, errors, mapping, new StringBuilder(str.length()), true);
    }

    /*
     * WARNING - void declaration
     */
    private static PyTuple charmap_encode_internal(String str, String errors, PyObject mapping, StringBuilder v, boolean letLookupHandleError) {
        EncodingMap encodingMap = mapping instanceof EncodingMap ? (EncodingMap)mapping : null;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            void var10_10;
            int x;
            int n;
            char ch = str.charAt(i);
            Object result = encodingMap != null ? ((n = encodingMap.lookup(ch)) == -1 ? null : Py.newInteger(x)) : mapping.__finditem__(Py.newInteger(ch));
            if (result == null) {
                if (letLookupHandleError) {
                    i = _codecs.handleBadMapping(str, errors, mapping, v, size, i);
                    continue;
                }
                throw Py.UnicodeEncodeError("charmap", str, i, i + 1, "character maps to <undefined>");
            }
            if (result instanceof PyInteger) {
                x = ((PyInteger)result).getValue();
                if (x < 0 || x > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                v.append((char)x);
                continue;
            }
            if (var10_10 instanceof PyString && !(var10_10 instanceof PyUnicode)) {
                v.append(var10_10.toString());
                continue;
            }
            if (var10_10 instanceof PyNone) {
                i = _codecs.handleBadMapping(str, errors, mapping, v, size, i);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.encode_tuple(v.toString(), size);
    }

    private static int handleBadMapping(String str, String errors, PyObject mapping, StringBuilder v, int size, int i) {
        if (errors != null) {
            if (errors.equals("ignore")) {
                return i;
            }
            if (errors.equals("replace")) {
                _codecs.charmap_encode_internal("?", errors, mapping, v, false);
                return i;
            }
            if (errors.equals("xmlcharrefreplace")) {
                _codecs.charmap_encode_internal(codecs.xmlcharrefreplace(i, i + 1, str).toString(), errors, mapping, v, false);
                return i;
            }
            if (errors.equals("backslashreplace")) {
                _codecs.charmap_encode_internal(codecs.backslashreplace(i, i + 1, str).toString(), errors, mapping, v, false);
                return i;
            }
        }
        PyObject replacement = codecs.encoding_error(errors, "charmap", str, i, i + 1, "character maps to <undefined>");
        String replStr = replacement.__getitem__(0).toString();
        _codecs.charmap_encode_internal(replStr, errors, mapping, v, false);
        return codecs.calcNewPosition(size, replacement) - 1;
    }

    public static PyTuple ascii_decode(String str) {
        return _codecs.ascii_decode(str, null);
    }

    public static PyTuple ascii_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeASCII(str, size, errors), size);
    }

    public static PyTuple ascii_encode(String str) {
        return _codecs.ascii_encode(str, null);
    }

    public static PyTuple ascii_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeASCII(str, size, errors), size);
    }

    public static PyTuple latin_1_decode(String str) {
        return _codecs.latin_1_decode(str, null);
    }

    public static PyTuple latin_1_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeLatin1(str, size, errors), size);
    }

    public static PyTuple latin_1_encode(String str) {
        return _codecs.latin_1_encode(str, null);
    }

    public static PyTuple latin_1_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeLatin1(str, size, errors), size);
    }

    public static PyTuple utf_16_encode(String str) {
        return _codecs.utf_16_encode(str, null);
    }

    public static PyTuple utf_16_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 0), str.length());
    }

    public static PyTuple utf_16_encode(String str, String errors, int byteorder) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, byteorder), str.length());
    }

    public static PyTuple utf_16_le_encode(String str) {
        return _codecs.utf_16_le_encode(str, null);
    }

    public static PyTuple utf_16_le_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, -1), str.length());
    }

    public static PyTuple utf_16_be_encode(String str) {
        return _codecs.utf_16_be_encode(str, null);
    }

    public static PyTuple utf_16_be_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 1), str.length());
    }

    public static String encode_UTF16(String str, String errors, int byteorder) {
        Charset utf16 = byteorder == 0 ? Charset.forName("UTF-16") : (byteorder == -1 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-16BE"));
        ByteBuffer bbuf = utf16.encode(str);
        StringBuilder v = new StringBuilder(bbuf.limit());
        while (bbuf.remaining() > 0) {
            int val = bbuf.get();
            if (val < 0) {
                val = 256 + val;
            }
            v.appendCodePoint(val);
        }
        return v.toString();
    }

    public static PyTuple utf_16_decode(String str) {
        return _codecs.utf_16_decode(str, null);
    }

    public static PyTuple utf_16_decode(String str, String errors) {
        return _codecs.utf_16_decode(str, errors, false);
    }

    public static PyTuple utf_16_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_le_decode(String str) {
        return _codecs.utf_16_le_decode(str, null);
    }

    public static PyTuple utf_16_le_decode(String str, String errors) {
        return _codecs.utf_16_le_decode(str, errors, false);
    }

    public static PyTuple utf_16_le_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{-1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_be_decode(String str) {
        return _codecs.utf_16_be_decode(str, null);
    }

    public static PyTuple utf_16_be_decode(String str, String errors) {
        return _codecs.utf_16_be_decode(str, errors, false);
    }

    public static PyTuple utf_16_be_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_ex_decode(String str) {
        return _codecs.utf_16_ex_decode(str, null);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors) {
        return _codecs.utf_16_ex_decode(str, errors, 0);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder) {
        return _codecs.utf_16_ex_decode(str, errors, byteorder, false);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        String decoded = _codecs.decode_UTF16(str, errors, bo, consumed);
        return new PyTuple(Py.newString(decoded), Py.newInteger(final_ ? str.length() : consumed[0]), Py.newInteger(bo[0]));
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder) {
        return _codecs.decode_UTF16(str, errors, byteorder, null);
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder, int[] consumed) {
        int i;
        int bo = 0;
        if (byteorder != null) {
            bo = byteorder[0];
        }
        int size = str.length();
        StringBuilder v = new StringBuilder(size / 2);
        for (i = 0; i < size; i += 2) {
            char ch1 = str.charAt(i);
            if (i + 1 == size) {
                if (consumed != null) break;
                i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "truncated data");
                continue;
            }
            char ch2 = str.charAt(i + 1);
            if (ch1 == '\u00fe' && ch2 == '\u00ff') {
                bo = 1;
                continue;
            }
            if (ch1 == '\u00ff' && ch2 == '\u00fe') {
                bo = -1;
                continue;
            }
            int W1 = bo == -1 ? ch2 << 8 | ch1 : ch1 << 8 | ch2;
            if (W1 < 55296 || W1 > 57343) {
                v.appendCodePoint(W1);
                continue;
            }
            if (W1 >= 55296 && W1 <= 56319 && i < size - 1) {
                char ch3 = str.charAt(i += 2);
                char ch4 = str.charAt(i + 1);
                int W2 = bo == -1 ? ch4 << 8 | ch3 : ch3 << 8 | ch4;
                if (W2 >= 56320 && W2 <= 57343) {
                    int U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                    v.appendCodePoint(U);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "illegal UTF-16 surrogate");
                continue;
            }
            i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "illegal encoding");
        }
        if (byteorder != null) {
            byteorder[0] = bo;
        }
        if (consumed != null) {
            consumed[0] = i;
        }
        return v.toString();
    }

    public static PyTuple raw_unicode_escape_encode(String str) {
        return _codecs.raw_unicode_escape_encode(str, null);
    }

    public static PyTuple raw_unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(str, errors, false), str.length());
    }

    public static PyTuple raw_unicode_escape_decode(String str) {
        return _codecs.raw_unicode_escape_decode(str, null);
    }

    public static PyTuple raw_unicode_escape_decode(String str, String errors) {
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(str, errors), str.length());
    }

    public static PyTuple unicode_escape_encode(String str) {
        return _codecs.unicode_escape_encode(str, null);
    }

    public static PyTuple unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple unicode_escape_decode(String str) {
        return _codecs.unicode_escape_decode(str, null);
    }

    public static PyTuple unicode_escape_decode(String str, String errors) {
        int n = str.length();
        return _codecs.decode_tuple(PyString.decode_UnicodeEscape(str, 0, n, errors, true), n);
    }

    public static PyTuple unicode_internal_encode(String str) {
        return _codecs.unicode_internal_encode(str, null);
    }

    public static PyTuple unicode_internal_encode(String str, String errors) {
        return _codecs.encode_tuple(str, str.length());
    }

    public static PyTuple unicode_internal_decode(String str) {
        return _codecs.unicode_internal_decode(str, null);
    }

    public static PyTuple unicode_internal_decode(String str, String errors) {
        return _codecs.decode_tuple(str, str.length());
    }

    @ExposedType(name="EncodingMap", isBaseType=false)
    public static class EncodingMap
    extends PyObject {
        char[] level1;
        char[] level23;
        int count2;
        int count3;

        private EncodingMap(char[] level1, char[] level23, int count2, int count3) {
            this.level1 = level1;
            this.level23 = level23;
            this.count2 = count2;
            this.count3 = count3;
        }

        /*
         * WARNING - void declaration
         */
        public static PyObject buildEncodingMap(PyObject string) {
            void result;
            int length3;
            void i;
            int l22;
            int charAt;
            int decode;
            if (!(string instanceof PyUnicode) || string.__len__() != 256) {
                throw Py.TypeError("bad argument type for built-in operation");
            }
            boolean needDict = false;
            char[] level1 = new char[32];
            char[] level23 = new char[512];
            boolean bl = false;
            int count2 = 0;
            String count3 = string.toString();
            for (decode = 0; decode < level1.length; ++decode) {
                level1[decode] = 255;
            }
            for (decode = 0; decode < level23.length; ++decode) {
                level23[decode] = 255;
            }
            if (count3.charAt(0) != '\u0000') {
                needDict = true;
            }
            for (decode = 1; decode < 256; ++decode) {
                void l1;
                char c = count3.charAt(decode);
                if (c == '\u0000') {
                    needDict = true;
                }
                if (c == '\ufffe') continue;
                int n = c >> 11;
                charAt = l1 >> 7;
                if (level1[l22] == '\u00ff') {
                    level1[l22] = (char)(++i);
                }
                if (level23[charAt] != '\u00ff') continue;
                level23[charAt] = (char)count2++;
            }
            if (i > 255 || count2 > 255) {
                needDict = true;
            }
            if (needDict) {
                PyDictionary l22 = new PyDictionary();
                for (decode = 0; decode < 256; ++decode) {
                    ((PyObject)l22).__setitem__(Py.newInteger(count3.charAt(decode)), (PyObject)Py.newInteger(decode));
                }
                return l22;
            }
            l22 = 16 * i;
            charAt = 128 * count2;
            level23 = new char[length3 + charAt];
            EncodingMap length2 = new EncodingMap(level1, level23, (int)i, count2);
            for (decode = 0; decode < length3; ++decode) {
                level23[decode] = 255;
            }
            for (decode = length3; decode < length3 + result; ++decode) {
                level23[decode] = '\u0000';
            }
            count2 = 0;
            for (decode = 1; decode < 256; ++decode) {
                void o2;
                void o1;
                char c = count3.charAt(decode);
                if (c == '\ufffe') continue;
                int n = c >> 11;
                int n2 = o1 >> 7 & 0xF;
                int i2 = 16 * level1[o2] + n2;
                if (level23[i2] == '\u00ff') {
                    level23[i2] = (char)count2++;
                }
                int n3 = o1 & 0x7F;
                int charAt2 = 128 * level23[i2] + n3;
                level23[length3 + charAt2] = (char)decode;
            }
            return length2;
        }

        public int lookup(char c) {
            int l1 = c >> 11;
            int l2 = c >> 7 & 0xF;
            int l3 = c & 0x7F;
            if (c == '\u0000') {
                return 0;
            }
            char i = this.level1[l1];
            if (i == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * i + l2]) == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * this.count2 + 128 * i + l3]) == '\u0000') {
                return -1;
            }
            return i;
        }

        static {
            PyType.addBuilder(EncodingMap.class, new _codecs$EncodingMap$PyExposer());
        }
    }
}

