/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class GroupByNode
extends MajorNode {
    List groupByItems = null;

    public void validate(ParseTreeContext context, SelectNode selectNode) {
        for (Node item : this.groupByItems) {
            item.validate(context);
        }
        List selectExprs = selectNode.getSelectExpressions();
        for (Node selectExpr : selectExprs) {
            if (this.isValidSelectExpr(selectExpr)) continue;
            throw JPQLException.invalidSelectForGroupByQuery(context.getQueryInfo(), selectExpr.getLine(), selectExpr.getColumn(), selectExpr.getAsString(), this.getAsString());
        }
    }

    private void addGroupByItem(Object theNode) {
        this.getGroupByItems().add(theNode);
    }

    public void addGroupingToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            for (Node nextNode : this.getGroupByItems()) {
                ((ReportQuery)theQuery).addGrouping(nextNode.generateExpression(context));
            }
        }
    }

    public boolean isValidHavingExpr(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            return this.isGroupbyItem(expr);
        }
        Node left = expr.getLeft();
        Node right = expr.getRight();
        return !(left != null && !this.isValidHavingExpr(left) || right != null && !this.isValidHavingExpr(right));
    }

    private boolean isValidSelectExpr(Node expr) {
        if (expr.isAggregateNode()) {
            return true;
        }
        if (expr.isConstructorNode()) {
            List args = ((ConstructorNode)expr).getConstructorItems();
            for (Node arg : args) {
                if (this.isValidSelectExpr(arg)) continue;
                return false;
            }
            return true;
        }
        return this.isGroupbyItem(expr);
    }

    private boolean isGroupbyItem(Node expr) {
        if (expr.isDotNode() || expr.isVariableNode()) {
            String exprRepr = expr.getAsString();
            for (Node item : this.groupByItems) {
                String itemRepr = item.getAsString();
                if (!exprRepr.equals(itemRepr)) continue;
                return true;
            }
        }
        return false;
    }

    public List getGroupByItems() {
        if (this.groupByItems == null) {
            this.setGroupByItems(new Vector());
        }
        return this.groupByItems;
    }

    public void setGroupByItems(List newItems) {
        this.groupByItems = newItems;
    }

    public String getAsString() {
        StringBuffer repr = new StringBuffer();
        for (Node expr : this.groupByItems) {
            if (repr.length() > 0) {
                repr.append(", ");
            }
            repr.append(expr.getAsString());
        }
        return "GROUP BY " + repr.toString();
    }
}

