package de.jeckle.AntExtension;

import com.elharo.xml.xinclude.SAXXIncluder;
import com.elharo.xml.xinclude.XIncludeFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class XIncludeTask extends Task {
    private String file;
    private String tofile;

    public void execute() throws BuildException {
        //code adapted from Elliotte Rusty Harold's XInclude engine
        //The engine could be found at: http://xincluder.sourceforge.net/
        XMLReader parser;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tofile);
        } catch (FileNotFoundException e) {
            System.err.println("Could not open output file");
        }
        try {
            parser = XMLReaderFactory.createXMLReader();
        } catch (SAXException e) {
            try {
                parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            } catch (SAXException e2) {
                System.err.println("Could not find an XML parser");
                return;
            }
        }

        // Need better namespace handling
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        } catch (SAXException e) {
            System.err.println(e);
            return;
        }

        try {
            XIncludeFilter includer = new XIncludeFilter();
            includer.setParent(parser);
            SAXXIncluder s = new SAXXIncluder(fos);
            includer.setContentHandler(s);
            try {
                includer.setProperty("http://xml.org/sax/properties/lexical-handler", s);
                s.setFilter(includer);
            } catch (SAXException e) {
                // Will not support comments
            }
            includer.parse(file);
        } catch (SAXParseException e) {
            System.err.println(e);
            System.err.println("Problem in " + e.getSystemId() + " at line " + e.getLineNumber());
        } catch (Exception e) { // be specific about exceptions????
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTofile(String tofile) {
        this.tofile = tofile;
    }
}
