/*
 * Decompiled with CFR 0.152.
 */
package fmpp.tools;

import fmpp.Engine;
import fmpp.ProcessingException;
import fmpp.progresslisteners.ConsoleProgressListener;
import fmpp.progresslisteners.LoggerProgressListener;
import fmpp.progresslisteners.StatisticsProgressListener;
import fmpp.progresslisteners.TerseConsoleProgressListener;
import fmpp.setting.FileWithSettingValue;
import fmpp.setting.SettingException;
import fmpp.setting.Settings;
import fmpp.util.ArgsParser;
import fmpp.util.FileUtil;
import fmpp.util.MiscUtil;
import fmpp.util.NullOutputStream;
import fmpp.util.RuntimeExceptionCC;
import fmpp.util.StringUtil;
import freemarker.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CommandLine {
    private static final String OPTION_CONFIGURATION = "configuration";
    private static final String OPTION_PRINT_LOCALES = "print-locales";
    private static final String OPTION_VERSION = "version";
    private static final String OPTION_HELP = "help";
    private static final String OPTION_LONG_HELP = "long-help";
    private static final String RC_FILE_NAME = ".fmpprc";
    private static final int EF_NORMAL = 0;
    private static final int EF_TERSE = 1;
    private static final int EF_QUIET = 2;
    private boolean quiet;
    private boolean snip;
    private PrintWriter stdout;
    private PrintWriter stderr;
    private PrintWriter tOut;
    private PrintWriter eOut;
    private int screenCols = 80;
    private boolean loggingStarted = false;
    private LoggerProgressListener logListener;
    static /* synthetic */ Class class$fmpp$Engine;

    public static void main(String[] args) {
        int exitCode = CommandLine.execute(args, null, null);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int execute(String[] args, PrintWriter stdout, PrintWriter stderr) {
        CommandLine tool = new CommandLine();
        tool.stdout = stdout == null ? new PrintWriter(System.out, true) : stdout;
        tool.stderr = stderr == null ? new PrintWriter(System.err, true) : stderr;
        tool.eOut = tool.tOut = tool.stdout;
        return tool.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        int exitCode;
        block84: {
            exitCode = 0;
            try {
                Logger.selectLoggerLibrary((int)0);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeExceptionCC("Failed to disable FreeMarker logging", e);
            }
            File rcFile = null;
            String s = System.getProperty("user.home");
            if (s != null && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
                rcFile = null;
            }
            if (rcFile == null && (s = System.getProperty("fmpp.userHome")) != null && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
                rcFile = null;
            }
            if (rcFile == null && (s = System.getProperty("fmpp.home")) != null && !s.startsWith("%") && !(rcFile = new File(s, RC_FILE_NAME)).isFile()) {
                rcFile = null;
            }
            int impliedEchoFormat = 0;
            boolean impliedSnip = true;
            boolean impliedAppendLogFile = false;
            int impliedColumns = 80;
            int impliedQuiet = 0;
            if (rcFile != null) {
                try {
                    Settings fmpprc = new Settings(new File("."));
                    fmpprc.load(rcFile);
                    Iterator it = fmpprc.getNames();
                    while (it.hasNext()) {
                        String value;
                        String key = (String)it.next();
                        if (key.equals("echoFormat")) {
                            value = (String)fmpprc.get(key);
                            impliedEchoFormat = CommandLine.echoFormatOpToInt(value, false, key);
                            continue;
                        }
                        if (key.equals("snip")) {
                            impliedSnip = (Boolean)fmpprc.get(key);
                            continue;
                        }
                        if (key.equals("appendLogFile")) {
                            impliedAppendLogFile = (Boolean)fmpprc.get(key);
                            continue;
                        }
                        if (key.equals("columns")) {
                            this.screenCols = impliedColumns = ((Integer)fmpprc.get(key)).intValue();
                            continue;
                        }
                        if (key.equals("quiet")) {
                            value = (String)fmpprc.get(key);
                            impliedQuiet = Settings.quietSettingValueToInt(value, key);
                            continue;
                        }
                        throw new SettingException("Setting \"" + key + "\" is not allowed in " + ".fmpprc. In general, not setting that " + "could influence the output files can be " + "set here.");
                    }
                }
                catch (SettingException e) {
                    this.pt("Error loading .fmpprc.");
                    this.pt(MiscUtil.causeMessages(e));
                    return -1;
                }
            }
            File defaultCfg = Settings.getDefaultConfigurationFile(new File("."));
            if (args.length == 0 && defaultCfg == null) {
                this.printHelp(null, false);
                return -1;
            }
            try {
                File f;
                Properties ops;
                ArgsParser ap = new ArgsParser();
                ap.addOption("S DIR", this.dn("sourceRoot")).desc("Sets the root directory of source files. In bulk-mode it defaults to the current working directory.");
                ap.addOption("O DIR", this.dn("outputRoot")).desc("Sets the root directory of output files.");
                ap.addOption("o FILE", this.dn("outputFile")).desc("The output file. This switches FMPP to single-file mode.");
                ap.addOption(null, this.dn("freemarkerLinks") + "=MAP").desc("The map of FreeMarker links (external includes).");
                ap.addOption("U WHAT", this.dn("skipUnchanged")).desc("Skip <WHAT> files if the source was not modified after the output file was last modified. <WHAT> can be \"all\", \"none\" or \"static\"");
                ap.addOption(null, this.dn("dataRoot") + "=DIR").desc("Sets the root directory of data files. The reserved value \"source\" means that the data root is the same as the source root. The default value is \"source\".");
                ap.addOption("C FILE", OPTION_CONFIGURATION).desc("Load settings from a configuration file. Settings given with command-line options have higher priority (note that some settings are merged, rather than overridden). Be default fmpp will use ./config.fmpp or ./fmpp.cfg if that exists. Use value \"none\" (-C none) to prevent this.");
                ap.addOption(null, this.dn("inheritConfiguration") + " FILE").desc("Inherits options from a configuration file. The options in the primary configuration file (-C) has higher precednece.");
                ap.addOption("M SEQ", this.dn("modes")).desc("The list of TDD function calls that choose the file processing mode, e.g.:\n-M \"ignore(**/tmp/), execute(**/*.htm, **/*.html), copy(**/*)\"");
                ap.addOption(null, this.dn("turns") + "=SEQ").desc("The list of turn(...)-s that choose the turns of processings, e.g.:\n--turns \"turn(2, **/*_t2.*, ), turn(3, **/*_t3.*, **/*.toc)\"\nBy default all files will be procesed in the first turn.");
                ap.addOption(null, this.dn("borders") + "=SEQ").desc("The list of TDD function calls that choose header and footer for templates, e.g.:\n-M 'border(\"<#escape x as x?html>\", \"</#escape>\", *.htm, *.html), header(\"<#include \\\"/css.ftl\\\">\", *.css)'");
                ap.addOption("D TDD", this.dn("data")).desc("Creates shared data that all template will see. <TDD> is the Textual Data Definition, e.g.:\n-D \"properties(style.properties), onLine:true\"\nNote that paths like \"style.properties\" are relatve to the data root directory.");
                ap.addOption(null, this.dn("objectWrapper") + "=BSH").desc("Specifies the ObjectWrapper to use with a BeanShell expression that must evaluate to an object that extends BeansWrapper. The default value is a BeansWrapper instance with simpleMapWrapper set to true.");
                ap.addOption(null, this.dn("localData") + "=SEQ").desc("Creates data that is visible only for certain templates. This is a list of case(...) and layer() function calls.");
                ap.addOption(null, this.dn("templateData") + "=CLASS").desc("Creates Java object that builds data for individual templates.").hide();
                ap.addOption("s", this.dn("stopOnError")).propertyValue("true").implied().desc("Terminate fmpp on failed file processing. This is the default behaviour. Use -c to override this.");
                ap.addOption("c", "continue-on-error").property(this.dn("stopOnError"), "false").implied().desc("Skip to the next file on failed file processing (and log the error: see -L)");
                ap.addOption("E ENC", this.dn("sourceEncoding")).desc("The encoding of textual sources (templates). Use the special value \"host\" (-E host) if the default encoding of the host machine should be used. The default value of the option is \"ISO-8859-1.\"");
                ap.addOption(null, this.dn("outputEncoding") + "=ENC").desc("The encoding of template output. Use the special value \"source\" if the encoding of the template file should be used. Use the special value \"host\" if the default encoding of the host machine should be used. The default is \"source\".");
                ap.addOption(null, this.dn("urlEscapingCharset") + "=ENC").desc("The charset used for URL escaping. Use the special value \"output\" if the encoding of the output file should be used. The default is \"output\".");
                ap.addOption("A LOC", this.dn("locale")).desc("The locale (as ar_SA). Use the special value \"host\" (-A host) if the default locale of the host machine should be used. The default value of the option is en_US.");
                ap.addOption(null, this.dn("numberFormat") + "=FORMAT").desc("The number format used to show numerical values. The default is 0.############");
                ap.addOption(null, this.dn("dateFormat") + "=FORMAT").desc("The format used to show date (year+month+day) values. The default is locale dependent.");
                ap.addOption(null, this.dn("timeFormat") + "=FORMAT").desc("The format used to show time values. The default is locale dependent.");
                ap.addOption(null, this.dn("datetimeFormat") + "=FORMAT").desc("The format used to show date-time values. The default is locale dependent.");
                ap.addOption(null, this.dn("timeZone") + "=ZONE").desc("Sets the time zone used to show time. The default is the time zone of the host machine. Example: GMT+02");
                ap.addOption(null, this.dn("tagSyntax") + "=WHAT").desc("Sets the tag syntax for templates that doesn't start with the ftl directive. Possible values are: angleBracket, squareBracket, autoDetect. The default depends on the FreeMarker version. The recommended value is autoDetect.");
                ap.addOption(null, this.dn("caseSensitive")).propertyValue("true").desc("Upper- and lower-case letters are considered as different characters when comparing or matching paths.");
                ap.addOption(null, "ignore-case").property(this.dn("caseSensitive"), "false").implied().desc("Upper- and lower-case letters are considered as the same characters when comparing or matching paths. This is the default.");
                ap.addOption(null, this.dn("ignoreCvsFiles")).implied().desc("Ignore CVS files in the source root directory. This is the default.");
                ap.addOption(null, "dont-" + this.dn("ignoreCvsFiles")).property(this.dn("ignoreCvsFiles"), "false").desc("Don't ignore CVS files in the source root directory.");
                ap.addOption(null, this.dn("ignoreSvnFiles")).implied().desc("Ignore SVN files in the source root directory. This is the default.");
                ap.addOption(null, "dont-" + this.dn("ignoreSvnFiles")).property(this.dn("ignoreSvnFiles"), "false").desc("Don't ignore SVN files in the source root directory.");
                ap.addOption(null, this.dn("ignoreTemporaryFiles")).implied().desc("Ignore well-known temporary files (e.g. **/?*~) in the source root directory. This is the default.");
                ap.addOption(null, "dont-" + this.dn("ignoreTemporaryFiles")).property(this.dn("ignoreTemporaryFiles"), "false").desc("Don't ignore well-known temporary files in the source root directory.");
                ap.addOption("R SEQ", this.dn("removeExtensions")).desc("These extensions will be removed from the output file name. <SEQ> contains the extensions without the dot.");
                ap.addOption(null, this.dn("removeExtension") + "=L").hide();
                ap.addOption(null, this.dn("replaceExtensions") + "=SEQ").desc("Replaces the extensions with another exensions. The list contains the old and new extensions alternately; old1, new1, old2, new2, etc. The extensions in the <SEQ> do not contain the dot.");
                ap.addOption(null, this.dn("replaceExtension") + "=L").hide();
                ap.addOption(null, this.dn("removePostfixes") + "=SEQ").desc("If the source file name without the extension ends with a string in the <SEQ>, then that string will be removed from the output file name.");
                ap.addOption(null, this.dn("removePostfix") + "=L").hide();
                ap.addOption("L FILE", this.dn("logFile")).implied("none").desc("Sets the log file. Use \"none\" (-L none) to disable logging. The default is \"none\".");
                ArgsParser.OptionDefinition od = ap.addOption(null, this.dn("appendLogFile")).desc("If the log file already exists, it will be continuted, instead of restarting it.");
                if (impliedAppendLogFile) {
                    CommandLine.setAsDefault(od);
                }
                od = ap.addOption(null, "dont-" + this.dn("appendLogFile")).property(this.dn("appendLogFile"), "false").desc("If the log file already exists, it will be restarted.");
                if (!impliedAppendLogFile) {
                    CommandLine.setAsDefault(od);
                }
                ap.addOption(null, this.dn("configurationBase") + "=DIR").desc("The directory used as base to resolve relative paths in the configuration file. It defaults to the directory of the configuration file.");
                ap.addOption("x", this.dn("expert")).propertyValue("true").desc("Expert mode.");
                ap.addOption(null, "not-expert").property(this.dn("expert"), "false").desc("Disables expert mode. This is the default.");
                ap.addOption(null, this.dn("xmlRenderings") + "=SEQ").desc("Sets the sequence of XML renderings. Each item is hash, that stores the options of an XML rendering configuration.");
                ap.addOption(null, this.dn("xpathEngine") + " NAME").desc("Sets the XPath engine to be used. Legal values are: dontSet, default, jaxen, xalan, and any adapter class name.");
                ap.addOption(null, this.dn("xmlCatalogFiles") + "=SEQ").desc("Sets the catalog files used for XML entity resolution. Catalog based resolution is enabled if and only if this settings is specified.");
                ap.addOption(null, this.dn("xmlCatalogPrefer") + "=WHAT").desc("Sets if catalog file based XML entity resolution prefers public or system identifiers. Valid values are: public, system, globalDefault. Defaults to public.");
                ap.addOption(null, this.dn("validateXml")).desc("Sets that XML files will be validated by default.");
                ap.addOption(null, "dont-" + this.dn("validateXml")).property(this.dn("validateXml"), "false").desc("Sets that XML files will not be validated by default. This is the default.");
                od = ap.addOption("v", "verbose").property(this.dn("quiet"), "false").desc("The opposite of -Q: prints everything to the stdout.");
                if (impliedQuiet == 0) {
                    CommandLine.setAsDefault(od);
                }
                od = ap.addOption("q", this.dn("quiet")).property(this.dn("quiet"), "true").desc("Don't write to the stdout, unless the command-line arguments are wrong. Print warning and error messages to the stderr.");
                if (impliedQuiet == 1) {
                    CommandLine.setAsDefault(od);
                }
                od = ap.addOption("Q", "really-quiet").property(this.dn("quiet"), "reallyQuiet").desc("As -q, but doesn't even write to the stderr.");
                if (impliedQuiet == 2) {
                    CommandLine.setAsDefault(od);
                }
                ap.addOption("F FORMAT", this.dn("echoFormat")).implied(CommandLine.echoFormatToString(impliedEchoFormat)).desc("The format used for displaying the progress. <FORMAT> is n[ormal], t[erse] or q[uiet] (or v[erbose], which is the same as normal). The default is " + CommandLine.echoFormatToString(impliedEchoFormat) + ".");
                ap.addOption(null, this.dn("columns") + "=COLS").implied(String.valueOf(impliedColumns)).desc("The number of columns on the console screen. Defaults to " + impliedColumns + ".");
                od = ap.addOption(null, this.dn("snip")).property(this.dn("snip"), "true").desc("Snip (--8<--) long messages.");
                if (impliedSnip) {
                    CommandLine.setAsDefault(od);
                }
                od = ap.addOption(null, "dont-snip").property(this.dn("snip"), "false").desc("Don't snip (--8<--) long messages.");
                if (!impliedSnip) {
                    CommandLine.setAsDefault(od);
                }
                ap.addOption(null, OPTION_PRINT_LOCALES).desc("Prints the locale codes that Java platform knows.");
                ap.addOption(null, OPTION_VERSION).desc("Prints version information.");
                ap.addOption("h", OPTION_HELP).desc("Prints help on options.");
                ap.addOption(null, OPTION_LONG_HELP).desc("Prints long help.");
                Properties impliedOps = new Properties();
                ap.setDefaultProperties(impliedOps);
                try {
                    ops = ap.parse(args);
                    args = ap.getNonOptions();
                }
                catch (ArgsParser.BadArgsException e) {
                    throw new SettingException("Bad command-line: " + MiscUtil.causeMessages(e));
                }
                Settings.fixVersion08SettingNames(ops);
                int i = Settings.quietSettingValueToInt(ops.getProperty(this.dn("quiet")), this.dn("quiet"));
                if (i > 0) {
                    this.quiet = true;
                    this.tOut.flush();
                    this.tOut = new PrintWriter(NullOutputStream.INSTANCE);
                    this.eOut = i == 1 ? this.stderr : this.tOut;
                } else {
                    this.quiet = false;
                }
                this.screenCols = CommandLine.opToInt(ops.getProperty(this.dn("columns")), this.dn("columns"));
                if (ops.containsKey(OPTION_LONG_HELP)) {
                    this.printHelp(ap, true);
                    throw new FinishedException();
                }
                if (ops.containsKey(OPTION_HELP)) {
                    this.printHelp(ap, false);
                    throw new FinishedException();
                }
                if (ops.containsKey(OPTION_VERSION)) {
                    this.pt("FMPP version " + Engine.getVersionNumber() + ", build " + Engine.getBuildInfo());
                    this.pt("Currently using FreeMarker version " + Engine.getFreeMarkerVersionNumber());
                    this.pt("For the latest version visit: http://fmpp.sourceforge.net/");
                    throw new FinishedException();
                }
                if (ops.containsKey(OPTION_PRINT_LOCALES)) {
                    Locale[] ls = Locale.getAvailableLocales();
                    StringBuffer sb = new StringBuffer();
                    for (i = 0; i < ls.length; ++i) {
                        sb.setLength(0);
                        String la = ls[i].getLanguage();
                        String co = ls[i].getCountry();
                        String va = ls[i].getVariant();
                        sb.append(la);
                        if (co.length() != 0) {
                            sb.append("_");
                            sb.append(co);
                            if (va.length() != 0) {
                                sb.append("_");
                                sb.append(va);
                            }
                        }
                        sb.append(" (");
                        sb.append(ls[i].getDisplayLanguage());
                        if (co.length() != 0) {
                            sb.append(", ");
                            sb.append(ls[i].getDisplayCountry());
                            if (va.length() != 0) {
                                sb.append(", ");
                                sb.append(ls[i].getDisplayVariant());
                            }
                        }
                        sb.append(")");
                        this.tOut.println(StringUtil.wrap(sb.toString(), this.screenCols, 0, 7));
                    }
                    throw new FinishedException();
                }
                Properties savedImpliedOps = new Properties();
                savedImpliedOps.putAll((Map<?, ?>)impliedOps);
                impliedOps.clear();
                String opC = ops.getProperty(OPTION_CONFIGURATION);
                ops.remove(OPTION_CONFIGURATION);
                Settings settings = new Settings(new File("."));
                settings.undashNames(ops);
                settings.addWithStrings(ops);
                ops = null;
                if (!(opC == null && defaultCfg == null || opC != null && opC.equals("none"))) {
                    if (opC == null) {
                        f = defaultCfg;
                        this.pt("Note: Using the " + f.getName() + " in the working directory.");
                    } else {
                        f = new File(opC);
                    }
                    settings.loadDefaults(f);
                }
                settings.undashNames(savedImpliedOps);
                settings.addDefaultsWithStrings(savedImpliedOps);
                savedImpliedOps = null;
                i = Settings.quietSettingValueToInt((String)settings.get("quiet"), "quiet");
                if (i > 0) {
                    this.quiet = true;
                    this.tOut.flush();
                    this.tOut = new PrintWriter(NullOutputStream.INSTANCE);
                    this.eOut = i == 1 ? this.stderr : this.tOut;
                } else {
                    this.quiet = false;
                }
                this.screenCols = (Integer)settings.get("columns");
                boolean singleFileMode = settings.get("outputFile") != null;
                f = (File)settings.get("logFile");
                if (!((FileWithSettingValue)f).getSettingValue().equals("none")) {
                    this.startLogging(f, (Boolean)settings.get("appendLogFile"));
                }
                if (this.logListener != null) {
                    settings.addProgressListener(this.logListener);
                }
                if (args.length != 0) {
                    settings.add("sources", args);
                }
                int ef = CommandLine.echoFormatOpToInt((String)settings.get("echoFormat"), true, "echoFormat");
                if (!singleFileMode && !this.quiet) {
                    if (ef == 0) {
                        settings.addProgressListener(new ConsoleProgressListener(this.tOut));
                    } else if (ef == 1) {
                        settings.addProgressListener(new TerseConsoleProgressListener(this.tOut));
                    } else if (ef == 2) {
                        settings.addProgressListener(new ConsoleProgressListener(this.tOut, true));
                    }
                } else {
                    settings.addProgressListener(new ConsoleProgressListener(this.eOut, true));
                }
                this.snip = (Boolean)settings.get("snip");
                StatisticsProgressListener stats = new StatisticsProgressListener();
                settings.addProgressListener(stats);
                if (!singleFileMode) {
                    settings.addDefault("sourceRoot", ".");
                }
                Throwable abortingExc = null;
                try {
                    settings.execute();
                }
                catch (ProcessingException e) {
                    abortingExc = e;
                }
                if (!singleFileMode) {
                    this.pt();
                }
                if (abortingExc != null) {
                    this.pe(">>> ABORTED! <<<");
                } else if (stats.getFailed() == 0) {
                    this.pt("*** DONE ***");
                } else {
                    this.pt(">>> DONE WITH ERRORS <<<");
                }
                if (!singleFileMode) {
                    this.pt();
                    this.pt(stats.getExecuted() + " executed + " + stats.getXmlRendered() + " rendered + " + stats.getCopied() + " copied = " + stats.getSuccesful() + " successfully processed\n" + stats.getFailed() + " failed, " + stats.getWarnings() + " warning(s) ");
                    this.pt("Time elapsed: " + (double)stats.getProcessingTime() / 1000.0 + " seconds");
                }
                if (abortingExc == null) break block84;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    pw.println();
                    pw.println("The cause of aborting was: ");
                    if (abortingExc instanceof ProcessingException) {
                        ProcessingException pexc = abortingExc;
                        if (!singleFileMode && pexc.getSourceFile() != null) {
                            pw.println("Error when processing this file: " + FileUtil.getRelativePath(pexc.getSourceRoot(), pexc.getSourceFile()));
                        }
                        abortingExc = pexc.getCause();
                    }
                    pw.println(MiscUtil.causeMessages(abortingExc));
                    pw.println();
                    pw.println("--- Java stack trace: ---");
                    StringWriter sw2 = new StringWriter();
                    PrintWriter pw2 = new PrintWriter(sw2);
                    abortingExc.printStackTrace(pw2);
                    pw2.flush();
                    pw.print(StringUtil.wrapTrace(sw2.toString(), this.screenCols));
                    pw.flush();
                    LineNumberReader pr = new LineNumberReader(new StringReader(StringUtil.wrap(sw.toString(), this.screenCols)));
                    try {
                        int maxCnt = this.snip ? 15 : Integer.MAX_VALUE;
                        String line = pr.readLine();
                        for (int lineCnt = 0; line != null && lineCnt < maxCnt; ++lineCnt) {
                            this.pe(line);
                            line = pr.readLine();
                        }
                        if (line != null) {
                            this.pe("---8<--- Long message... Snip! ---8<---");
                        }
                    }
                    finally {
                        pr.close();
                    }
                }
                finally {
                    pw.close();
                }
                exitCode = -2;
            }
            catch (IOException e) {
                this.pe("I/O error:");
                this.pe(e);
                this.pl(">>> TERMINATED WITH I/O ERROR <<<");
                this.pl(MiscUtil.causeMessages(e));
                if (this.logListener != null) {
                    this.logListener.printStackTrace(e);
                }
                exitCode = -2;
            }
            catch (SettingException e) {
                this.pe("Failed!");
                this.pe(MiscUtil.causeMessages(e));
                this.pl(">>> TERMINATED WITH SETTING ERROR <<<");
                this.pl(MiscUtil.causeMessages(e));
                if (this.logListener != null) {
                    this.logListener.printStackTrace(e);
                }
                exitCode = -1;
            }
            catch (FinishedException e) {
                exitCode = 0;
            }
            catch (Throwable e) {
                this.pe("INTERNAL ERROR:");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                this.peTrace(sw.toString());
                this.pl(">>> TERMINATED WITH INTERNAL ERROR <<<");
                if (this.logListener != null) {
                    this.logListener.printStackTrace(e);
                }
                exitCode = -2;
            }
            finally {
                this.tOut.println();
                this.tOut.flush();
                this.eOut.flush();
                if (this.logListener != null) {
                    this.logListener.close();
                }
            }
        }
        return exitCode;
    }

    private void printHelp(ArgsParser ap, boolean longHelp) {
        this.tOut.println(StringUtil.wrap("Typical usages:\nfmpp -C configfile\nfmpp -S sourcedir -O outputdir\nfmpp sourcefile -o outputfile\n", this.screenCols, 0, 3));
        if (ap == null) {
            this.pt("For more help: fmpp -h");
            this.pt("For even more help: fmpp --long-help");
        } else if (longHelp) {
            String s;
            try {
                InputStream in = (class$fmpp$Engine == null ? (class$fmpp$Engine = CommandLine.class$("fmpp.Engine")) : class$fmpp$Engine).getClassLoader().getResourceAsStream("fmpp/tools/help.txt");
                if (in == null) {
                    throw new FileNotFoundException();
                }
                s = FileUtil.loadString(in, "UTF-8");
                this.pt();
            }
            catch (IOException e) {
                s = "Faled to load <CLASSES>/fmpp/tools/help.txt:\n" + e;
            }
            this.pt(s);
            this.pt();
            this.pt();
            this.pt("Options");
            this.pt("-------");
            this.pt();
            this.tOut.println(ap.getOptionsHelp(this.screenCols));
        } else {
            this.pt("Options:");
            this.tOut.println(ap.getOptionsHelp(this.screenCols));
            this.pt();
            this.pt("Most of the above command-line options directly correspond to FMPP settings. The detailed description of the FMPP settings is in the FMPP Manual.");
        }
        this.pt();
        this.tOut.flush();
    }

    private void pt() {
        this.tOut.println();
    }

    private void pt(String text) {
        this.pt(text, 0);
    }

    private void pt(String text, int indent) {
        this.tOut.println(StringUtil.wrap(text, this.screenCols, indent));
    }

    private void pe(Object obj) {
        this.pe(obj.toString());
    }

    private void pe(String text) {
        this.pe(text, 0);
    }

    private void peTrace(String text) {
        this.eOut.println(StringUtil.wrapTrace(text, this.screenCols));
    }

    private void pe(String text, int indent) {
        this.eOut.println(StringUtil.wrap(text, this.screenCols, indent));
    }

    private void pl(Object obj) {
        if (this.logListener == null) {
            return;
        }
        this.logListener.println(obj);
    }

    private void startLogging(File logFile, boolean append) throws SettingException {
        if (this.loggingStarted) {
            return;
        }
        try {
            this.logListener = new LoggerProgressListener(logFile, append);
        }
        catch (IOException e) {
            throw new SettingException("Failed to create log file.", e);
        }
        this.loggingStarted = true;
    }

    private static void setAsDefault(ArgsParser.OptionDefinition od) {
        od.implied();
        od.desc(od.getDescription() + " This is the default.");
    }

    private static int echoFormatOpToInt(String s, boolean ignoreError, String name) throws SettingException {
        if ((s = s.toLowerCase()).equals("n") || s.equals("normal") || s.equals("verbose") || s.equals("v")) {
            return 0;
        }
        if (s.equals("t") || s.equals("terse")) {
            return 1;
        }
        if (s.equals("q") || s.equals("quiet")) {
            return 2;
        }
        if (ignoreError) {
            return 0;
        }
        throw new SettingException("Invalid value " + StringUtil.jQuote(s) + " for setting " + StringUtil.jQuote(name) + ". " + " Valid values are (case insensitive): " + "\"normal\", \"n\", \"terse\", \"t\", \"quiet\", \"q\".");
    }

    private static String echoFormatToString(int ef) {
        if (ef == 0) {
            return "normal";
        }
        if (ef == 1) {
            return "terse";
        }
        if (ef == 2) {
            return "quiet";
        }
        return null;
    }

    private static int opToInt(String value, String name) throws SettingException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SettingException("The value of setting \"" + name + "\" has to be a valid integer.");
        }
    }

    private String dn(String name) {
        return Settings.getDashedName(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FinishedException
    extends Exception {
        private FinishedException() {
        }
    }
}

