/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.Category;
import info.bliki.api.Link;
import info.bliki.api.Revision;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class Page {
    List<Link> links = new ArrayList<Link>();
    List<Category> categories = new ArrayList<Category>();
    String pageid = "";
    String ns = "";
    String title = "";
    String imageUrl = "";
    Revision revision = null;
    protected static final int BLOCK_SIZE = 8192;

    public boolean equals(Object obj) {
        if (obj instanceof Category) {
            return this.title.equals(((Category)obj).title) && this.ns.equals(((Category)obj).ns);
        }
        return false;
    }

    public int hashCode() {
        return this.title.hashCode();
    }

    public String getNs() {
        return this.ns;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setNs(String ns) {
        this.ns = ns;
    }

    public String getPageid() {
        return this.pageid;
    }

    public void setPageid(String pageid) {
        this.pageid = pageid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String toString() {
        String content = "";
        if (this.revision != null) {
            content = this.revision.getContent();
        }
        return "PageID: " + this.pageid + "; NS: " + this.ns + "; Title: " + this.title + "; \nImage url: " + this.imageUrl + "\nContent:\n" + content;
    }

    public boolean addCategory(Category arg0) {
        return this.categories.add(arg0);
    }

    public boolean containsCategory(Category o) {
        return this.categories.contains(o);
    }

    public Category getCategory(int index) {
        return this.categories.get(index);
    }

    public int sizeOfCategoryList() {
        return this.categories.size();
    }

    public boolean addLink(Link arg0) {
        return this.links.add(arg0);
    }

    public boolean containsLink(Link o) {
        return this.links.contains(o);
    }

    public Link getLink(int index) {
        return this.links.get(index);
    }

    /*
     * Loose catch block
     */
    public void downloadImageUrl(OutputStream outputStream) {
        if (this.imageUrl != null && this.imageUrl.length() > 3) {
            BufferedInputStream bis = null;
            GetMethod method = null;
            try {
                try {
                    String extension2;
                    HttpClient client = new HttpClient();
                    client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
                    client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
                    String extension = "jpg";
                    int index = this.imageUrl.lastIndexOf(46);
                    if (index > 0 && ((extension2 = this.imageUrl.substring(index + 1).toLowerCase()).equals("svg") || extension2.equals("gif") || extension2.equals("png") || extension2.equals("jpg") || extension2.equals("jpeg"))) {
                        extension = extension2;
                    }
                    method = new GetMethod(this.imageUrl);
                    method.setFollowRedirects(false);
                    method.setRequestHeader("accept", "image/" + extension);
                    method.setRequestHeader("User-Agent", "plog4u.org/3.0");
                    method.setFollowRedirects(false);
                    int statusCode = client.executeMethod((HttpMethod)method);
                    if (statusCode == 200) {
                        InputStream is = method.getResponseBodyAsStream();
                        bis = new BufferedInputStream(is);
                        byte[] b = new byte[8192];
                        int count = bis.read(b);
                        while (count != -1 && count <= 8192) {
                            outputStream.write(b, 0, count);
                            count = bis.read(b);
                        }
                        if (count != -1) {
                            outputStream.write(b, 0, count);
                        }
                    }
                }
                catch (HttpException e) {
                    e.printStackTrace();
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
                catch (IOException e) {
                    block31: {
                        e.printStackTrace();
                        if (bis == null) break block31;
                        try {
                            bis.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
                catch (Exception e) {
                    block32: {
                        e.printStackTrace();
                        if (bis == null) break block32;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            bis.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public int sizeOfLinksList() {
        return this.links.size();
    }

    public Revision getCurrentRevision() {
        return this.revision;
    }

    public void setCurrentRevision(Revision revision) {
        this.revision = revision;
    }

    public String getCurrentContent() {
        String content = "";
        if (this.revision != null) {
            content = this.revision.getContent();
        }
        return content;
    }
}

