/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.diff.HgDiffConsumer;
import org.codehaus.plexus.util.StringUtils;

public class HgUpdateCommand
extends org.apache.maven.scm.provider.hg.command.update.HgUpdateCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion tag) throws ScmException {
        File workingDir = fileSet.getBasedir();
        int previousRevision = HgUtils.getCurrentRevisionNumber((ScmLogger)this.getLogger(), (File)workingDir);
        String[] updateCmd = new String[]{"update", "-r", tag != null && !StringUtils.isEmpty((String)tag.getName()) ? tag.getName() : "tip"};
        ScmResult updateResult = HgUtils.execute((HgConsumer)new HgConsumer(this.getLogger()), (ScmLogger)this.getLogger(), (File)workingDir, (String[])updateCmd);
        if (!updateResult.isSuccess()) {
            return new UpdateScmResult(null, null, updateResult);
        }
        int currentRevision = HgUtils.getCurrentRevisionNumber((ScmLogger)this.getLogger(), (File)workingDir);
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        ArrayList changes = new ArrayList();
        String[] diffCmd = null;
        diffCmd = currentRevision == 0 ? new String[]{"diff", "-c", "" + currentRevision} : new String[]{"diff", "-r", "" + previousRevision, "-r", "" + currentRevision};
        HgDiffConsumer diffConsumer = new HgDiffConsumer(this.getLogger(), workingDir);
        updateResult = HgUtils.execute((HgConsumer)diffConsumer, (ScmLogger)this.getLogger(), (File)workingDir, (String[])diffCmd);
        List diffFiles = diffConsumer.getChangedFiles();
        Map diffChanges = diffConsumer.getDifferences();
        for (ScmFile diffFile : diffFiles) {
            changes.add(diffChanges.get(diffFile.getPath()));
            if (diffFile.getStatus() == ScmFileStatus.MODIFIED) {
                updatedFiles.add(new ScmFile(diffFile.getPath(), ScmFileStatus.PATCHED));
                continue;
            }
            updatedFiles.add(diffFile);
        }
        return new UpdateScmResultWithRevision(updatedFiles, changes, String.valueOf(currentRevision), updateResult);
    }
}

