/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParserFactory;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class JPQLCall
implements Serializable,
Call {
    protected DatabaseQuery query;
    protected String ejbqlString;
    protected boolean isParsed;

    public JPQLCall() {
    }

    public JPQLCall(String ejbqlString) {
        this();
        this.ejbqlString = ejbqlString;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new JPQLCallQueryMechanism(query, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        return this.buildNewQueryMechanism(query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String getCallString() {
        return this.getEjbqlString();
    }

    public String getEjbqlString() {
        return this.ejbqlString;
    }

    private boolean getIsParsed() {
        return this.isParsed;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public String getLogString(Accessor accessor) {
        return this.getSQLString();
    }

    public String getSQLString() {
        return null;
    }

    public boolean isJPQLCall() {
        return true;
    }

    public boolean isFinished() {
        return true;
    }

    public boolean isParsed() {
        return this.getIsParsed();
    }

    public void populateQuery(AbstractSession session) {
        if (!this.isParsed()) {
            new JPQLParserFactory().populateQuery(this.getEjbqlString(), (ObjectLevelReadQuery)this.getQuery(), session);
            this.setIsParsed(true);
        }
    }

    public PreparedStatement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        return null;
    }

    public void setEjbqlString(String newEjbqlString) {
        this.ejbqlString = newEjbqlString;
    }

    public void setIsParsed(boolean newIsParsed) {
        this.isParsed = newIsParsed;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }
}

