/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.interfaces.Requirable;
import com.sardak.antform.types.DefaultProperty;
import com.sardak.antform.util.FontStyleAttribute;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.tools.ant.Task;

public class MultilineTextProperty
extends DefaultProperty
implements Requirable,
ActionListenerComponent {
    private int columns = 40;
    private int rows = 5;
    private boolean required;
    private JTextArea textArea;
    private String fontName;
    private int fontSize = -1;
    private int fontStyle = 0;

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(FontStyleAttribute fsa) {
        this.fontStyle = fsa.getFontStyle();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.textArea = new JTextArea(this.rows, this.columns);
        this.textArea.setEditable(this.isEditable());
        if (this.fontName != null || this.fontSize == -1) {
            Font f = this.textArea.getFont();
            String name = this.fontName == null ? f.getFontName() : this.fontName;
            int size = this.fontSize > 0 ? this.fontSize : f.getSize();
            this.textArea.setFont(new Font(name, this.fontStyle, size));
        }
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        panel.getStylesheetHandler().addMultiLineTextArea(this.textArea);
        panel.getStylesheetHandler().addScrollPane(scrollPane);
        this.initComponent(scrollPane, panel);
    }

    public boolean validate(Task task) {
        return super.validate(task, "MultiLineTextProperty");
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.textArea.getText());
    }

    public void reset() {
        this.textArea.setText(this.getCurrentProjectPropertyValue());
    }

    public boolean requiredStatusOk() {
        boolean ok = true;
        if (this.isRequired() && "".equals(this.textArea.getText())) {
            ok = false;
            this.textArea.requestFocus();
        }
        return ok;
    }

    public JComponent getFocusableComponent() {
        return this.textArea;
    }
}

