/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyTuple;

class MinFunction
extends PyBuiltinFunction {
    MinFunction() {
        super("min", "min(iterable[, key=func]) -> value\nmin(a, b, c, ...[, key=func]) -> value\n\nWith a single iterable argument, return its smallest item.\nWith two or more arguments, return the smallest argument.'");
    }

    public PyObject __call__(PyObject[] args, String[] kwds) {
        int argslen = args.length;
        PyObject key = null;
        if (args.length - kwds.length == 0) {
            throw Py.TypeError(" min() expected 1 arguments, got 0");
        }
        if (kwds.length > 0) {
            if (kwds[0].equals("key")) {
                key = args[argslen - 1];
                PyObject[] newargs = new PyObject[argslen - 1];
                System.arraycopy(args, 0, newargs, 0, argslen - 1);
                args = newargs;
            } else {
                throw Py.TypeError("min() got an unexpected keyword argument");
            }
        }
        if (args.length > 1) {
            return MinFunction.min(new PyTuple(args), key);
        }
        return MinFunction.min(args[0], key);
    }

    private static PyObject min(PyObject o, PyObject key) {
        PyObject min = null;
        PyObject minKey = null;
        for (PyObject item : o.asIterable()) {
            PyObject itemKey = key == null ? item : key.__call__(item);
            if (minKey != null && !itemKey._lt(minKey).__nonzero__()) continue;
            minKey = itemKey;
            min = item;
        }
        if (min == null) {
            throw Py.ValueError("min of empty sequence");
        }
        return min;
    }
}

