/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "rev", "force", "transitive", "changing", "conf"};
    private static final XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private XmlModuleDescriptorParser() {
    }

    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL xmlURL, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = new Parser(this, ivySettings, validate, xmlURL);
        parser.parse(res, validate);
        return parser.getModuleDescriptor();
    }

    ModuleDescriptor parseDescriptor(ParserSettings ivySettings, InputStream descriptor, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = new Parser(this, ivySettings, validate, null);
        parser.parse(descriptor, res, validate);
        return parser.getModuleDescriptor();
    }

    public boolean accept(Resource res) {
        return true;
    }

    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws IOException, ParseException {
        try {
            Namespace ns = null;
            if (md instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
                ns = dmd.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(IvyContext.getContext().getSettings(), is, res, destFile, Collections.EMPTY_MAP, md.getStatus(), md.getResolvedModuleRevisionId().getRevision(), md.getResolvedPublicationDate(), ns, true, null);
        }
        catch (SAXException e) {
            ParseException ex = new ParseException("exception occured while parsing " + res, 0);
            ex.initCause(e);
            throw ex;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        return "ivy parser";
    }

    private static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        private static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0");
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private MDArtifact artifact;
        private String conf;
        private boolean validate = true;
        private ParserSettings ivy;
        private boolean artifactsDeclared = false;
        private PatternMatcher defaultMatcher;
        private static final int NONE = 0;
        private static final int INFO = 1;
        private static final int CONF = 2;
        private static final int PUB = 3;
        private static final int DEP = 4;
        private static final int DEP_ARTIFACT = 5;
        private static final int ARTIFACT_INCLUDE = 6;
        private static final int ARTIFACT_EXCLUDE = 7;
        private static final int CONFLICT = 8;
        private static final int EXCLUDE = 9;
        private static final int DEPS = 10;
        private static final int DESCRIPTION = 11;
        private int state = 0;
        private final URL xmlURL;
        private StringBuffer buffer;

        public Parser(ModuleDescriptorParser parser, ParserSettings ivySettings, boolean validate, URL xmlURL) {
            super(parser);
            this.ivy = ivySettings;
            this.validate = validate;
            this.xmlURL = xmlURL;
        }

        private void parse(Resource res, boolean validate) throws ParseException, IOException {
            try {
                this.setResource(res);
                URL schemaURL = validate ? this.getClass().getResource("ivy.xsd") : null;
                XMLHelper.parse(this.xmlURL, schemaURL, this);
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                this.md.setModuleArtifact(DefaultArtifact.newIvyArtifact(this.md.getResolvedModuleRevisionId(), this.md.getPublicationDate()));
                if (!this.artifactsDeclared) {
                    String[] confs = this.md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.md.addArtifact(confs[i], new MDArtifact(this.md, this.md.getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.md.check();
            }
            catch (ParserConfigurationException ex) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage() + " in " + this.xmlURL);
                ise.initCause(ex);
                throw ise;
            }
            catch (Exception ex) {
                this.checkErrors();
                ParseException pe = new ParseException(ex.getMessage() + " in " + this.xmlURL, 0);
                pe.initCause(ex);
                throw pe;
            }
        }

        private void parse(InputStream descriptor, Resource res, boolean validate) throws ParseException, IOException {
            try {
                this.setResource(res);
                URL schemaURL = validate ? this.getClass().getResource("ivy.xsd") : null;
                XMLHelper.parse(descriptor, schemaURL, (DefaultHandler)this, null);
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                if (!this.artifactsDeclared) {
                    String[] confs = this.md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.md.addArtifact(confs[i], new MDArtifact(this.md, this.md.getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.md.check();
            }
            catch (ParserConfigurationException ex) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage());
                ise.initCause(ex);
                throw ise;
            }
            catch (Exception ex) {
                this.checkErrors();
                ParseException pe = new ParseException(ex.getMessage(), 0);
                pe.initCause(ex);
                throw pe;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("ivy-module".equals(qName)) {
                    this.ivyModuleStarted(attributes);
                } else if ("info".equals(qName)) {
                    this.infoStarted(attributes);
                } else if (this.state == 1 && "license".equals(qName)) {
                    this.md.addLicense(new License(this.ivy.substitute(attributes.getValue("name")), this.ivy.substitute(attributes.getValue("url"))));
                } else if (this.state == 1 && "description".equals(qName)) {
                    this.md.setHomePage(this.ivy.substitute(attributes.getValue("homepage")));
                    this.state = 11;
                } else if (this.state == 1) {
                    this.buffer = new StringBuffer();
                } else if ("configurations".equals(qName)) {
                    this.configurationStarted(attributes);
                } else if ("publications".equals(qName)) {
                    this.state = 3;
                    this.artifactsDeclared = true;
                    this.checkConfigurations();
                } else if ("dependencies".equals(qName)) {
                    this.dependenciesStarted(attributes);
                } else if ("conflicts".equals(qName)) {
                    this.state = 8;
                    this.checkConfigurations();
                } else if ("artifact".equals(qName)) {
                    this.artifactStarted(qName, attributes);
                } else if ("include".equals(qName) && this.state == 4) {
                    this.addIncludeRule(qName, attributes);
                } else if ("exclude".equals(qName) && this.state == 4) {
                    this.addExcludeRule(qName, attributes);
                } else if ("exclude".equals(qName) && this.state == 10) {
                    this.state = 9;
                    this.parseRule(qName, attributes);
                    this.md.addExcludeRule((ExcludeRule)((Object)this.confAware));
                } else if ("dependency".equals(qName)) {
                    this.dependencyStarted(attributes);
                } else if ("conf".equals(qName)) {
                    this.confStarted(attributes);
                } else if ("mapped".equals(qName)) {
                    this.dd.addDependencyConfiguration(this.conf, this.ivy.substitute(attributes.getValue("name")));
                } else if ("manager".equals(qName) && this.state == 8) {
                    this.managerStarted(attributes);
                } else if ("include".equals(qName) && this.state == 2) {
                    this.includeConfStarted(attributes);
                } else if (this.validate && this.state != 1) {
                    this.addError("unknwon tag " + qName);
                }
            }
            catch (Exception ex) {
                if (ex instanceof SAXException) {
                    throw (SAXException)ex;
                }
                throw new SAXException("problem occured while parsing ivy file. message: " + ex.getMessage(), ex);
            }
        }

        private void managerStarted(Attributes attributes) {
            PatternMatcher matcher;
            ConflictManager cm;
            String org = this.ivy.substitute(attributes.getValue("org"));
            org = org == null ? "*" : org;
            String mod = this.ivy.substitute(attributes.getValue("module"));
            mod = mod == null ? "*" : mod;
            String name = this.ivy.substitute(attributes.getValue("name"));
            String rev = this.ivy.substitute(attributes.getValue("rev"));
            if (rev != null) {
                String[] revs = rev.split(",");
                for (int i = 0; i < revs.length; ++i) {
                    revs[i] = revs[i].trim();
                }
                cm = new FixedConflictManager(revs);
            } else if (name != null) {
                cm = this.ivy.getConflictManager(name);
                if (cm == null) {
                    this.addError("unknown conflict manager: " + name);
                    return;
                }
            } else {
                this.addError("bad conflict manager: no name nor rev");
                return;
            }
            String matcherName = this.ivy.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.ivy.getMatcher(matcherName);
            if (matcher == null) {
                this.addError("unknown matcher: " + matcherName);
                return;
            }
            this.md.addConflictManager(new ModuleId(org, mod), matcher, cm);
        }

        private void includeConfStarted(Attributes attributes) throws SAXException, IOException, ParserConfigurationException, ParseException {
            URL url = this.ivy.getRelativeUrlResolver().getURL(this.xmlURL, this.ivy.substitute(attributes.getValue("file")), this.ivy.substitute(attributes.getValue("url")));
            if (url == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = new Parser(this.getModuleDescriptorParser(), this.ivy, false, url);
            parser.md = new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource(url));
            XMLHelper.parse(url, null, parser);
            Configuration[] configs = parser.getModuleDescriptor().getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                this.md.addConfiguration(configs[i]);
            }
            if (parser.getDefaultConfMapping() != null) {
                Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.md.isMappingOverride()) {
                Message.debug("enabling mapping-override from imported configurations file");
                this.md.setMappingOverride(true);
            }
        }

        private void confStarted(Attributes attributes) {
            String conf = this.ivy.substitute(attributes.getValue("name"));
            switch (this.state) {
                case 2: {
                    String visibility = this.ivy.substitute(attributes.getValue("visibility"));
                    String ext = this.ivy.substitute(attributes.getValue("extends"));
                    String transitiveValue = attributes.getValue("transitive");
                    boolean transitive = transitiveValue == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                    String deprecated = attributes.getValue("deprecated");
                    Configuration configuration = new Configuration(conf, Configuration.Visibility.getVisibility(visibility == null ? "public" : visibility), this.ivy.substitute(attributes.getValue("description")), ext == null ? null : ext.split(","), transitive, deprecated);
                    ExtendableItemHelper.fillExtraAttributes(configuration, attributes, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.md.addConfiguration(configuration);
                    break;
                }
                case 3: {
                    if ("*".equals(conf)) {
                        String[] confs = this.md.getConfigurationsNames();
                        for (int i = 0; i < confs.length; ++i) {
                            this.artifact.addConfiguration(confs[i]);
                            this.md.addArtifact(confs[i], this.artifact);
                        }
                        break;
                    }
                    this.artifact.addConfiguration(conf);
                    this.md.addArtifact(conf, this.artifact);
                    break;
                }
                case 4: {
                    this.conf = conf;
                    String mappeds = this.ivy.substitute(attributes.getValue("mapped"));
                    if (mappeds == null) break;
                    String[] mapped = mappeds.split(",");
                    for (int i = 0; i < mapped.length; ++i) {
                        this.dd.addDependencyConfiguration(conf, mapped[i].trim());
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.addConfiguration(conf);
                    break;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + this.state);
                }
            }
        }

        private void dependencyStarted(Attributes attributes) {
            this.state = 4;
            String org = this.ivy.substitute(attributes.getValue("org"));
            if (org == null) {
                org = this.md.getModuleRevisionId().getOrganisation();
            }
            boolean force = Boolean.valueOf(this.ivy.substitute(attributes.getValue("force")));
            boolean changing = Boolean.valueOf(this.ivy.substitute(attributes.getValue("changing")));
            String transitiveValue = this.ivy.substitute(attributes.getValue("transitive"));
            boolean transitive = transitiveValue == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
            String name = this.ivy.substitute(attributes.getValue("name"));
            String branch = this.ivy.substitute(attributes.getValue("branch"));
            String rev = this.ivy.substitute(attributes.getValue("rev"));
            this.dd = new DefaultDependencyDescriptor(this.md, ModuleRevisionId.newInstance(org, name, branch, rev, ExtendableItemHelper.getExtraAttributes(attributes, DEPENDENCY_REGULAR_ATTRIBUTES)), force, changing, transitive);
            this.md.addDependency(this.dd);
            String confs = this.ivy.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                this.parseDepsConfs(confs, this.dd);
            }
        }

        private void artifactStarted(String qName, Attributes attributes) throws MalformedURLException {
            if (this.state == 3) {
                String artName = this.ivy.substitute(attributes.getValue("name"));
                artName = artName == null ? this.md.getModuleRevisionId().getName() : artName;
                String type = this.ivy.substitute(attributes.getValue("type"));
                type = type == null ? "jar" : type;
                String ext = this.ivy.substitute(attributes.getValue("ext"));
                ext = ext != null ? ext : type;
                String url = this.ivy.substitute(attributes.getValue("url"));
                this.artifact = new MDArtifact(this.md, artName, type, ext, url == null ? null : new URL(url), ExtendableItemHelper.getExtraAttributes(attributes, new String[]{"ext", "type", "name", "conf"}));
                String confs = this.ivy.substitute(attributes.getValue("conf"));
                if (confs != null && confs.length() > 0) {
                    String[] conf = "*".equals(confs) ? this.md.getConfigurationsNames() : confs.split(",");
                    for (int i = 0; i < conf.length; ++i) {
                        this.artifact.addConfiguration(conf[i].trim());
                        this.md.addArtifact(conf[i].trim(), this.artifact);
                    }
                }
            } else if (this.state == 4) {
                this.addDependencyArtifacts(qName, attributes);
            } else if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + this.state);
            }
        }

        private void dependenciesStarted(Attributes attributes) {
            String confMappingOverride;
            this.state = 10;
            String defaultConf = this.ivy.substitute(attributes.getValue("defaultconf"));
            if (defaultConf != null) {
                this.setDefaultConf(defaultConf);
            }
            if ((defaultConf = this.ivy.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(defaultConf);
            }
            if ((confMappingOverride = this.ivy.substitute(attributes.getValue("confmappingoverride"))) != null) {
                this.md.setMappingOverride(Boolean.valueOf(confMappingOverride));
            }
            this.checkConfigurations();
        }

        private void configurationStarted(Attributes attributes) {
            this.state = 2;
            this.setDefaultConfMapping(this.ivy.substitute(attributes.getValue("defaultconfmapping")));
            this.md.setMappingOverride(Boolean.valueOf(this.ivy.substitute(attributes.getValue("confmappingoverride"))));
        }

        private void infoStarted(Attributes attributes) {
            String status;
            this.state = 1;
            String org = this.ivy.substitute(attributes.getValue("organisation"));
            String module = this.ivy.substitute(attributes.getValue("module"));
            String revision = this.ivy.substitute(attributes.getValue("revision"));
            String branch = this.ivy.substitute(attributes.getValue("branch"));
            this.md.setModuleRevisionId(ModuleRevisionId.newInstance(org, module, branch, revision, ExtendableItemHelper.getExtraAttributes(attributes, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
            String namespace = this.ivy.substitute(attributes.getValue("namespace"));
            if (namespace != null) {
                Namespace ns = this.ivy.getNamespace(namespace);
                if (ns == null) {
                    Message.warn("namespace not found for " + this.md.getModuleRevisionId() + ": " + namespace);
                } else {
                    this.md.setNamespace(ns);
                }
            }
            this.md.setStatus((status = this.ivy.substitute(attributes.getValue("status"))) == null ? this.ivy.getStatusManager().getDefaultStatus() : status);
            this.md.setDefault(Boolean.valueOf(this.ivy.substitute(attributes.getValue("default"))));
            String pubDate = this.ivy.substitute(attributes.getValue("publication"));
            if (pubDate != null && pubDate.length() > 0) {
                try {
                    this.md.setPublicationDate(Ivy.DATE_FORMAT.parse(pubDate));
                }
                catch (ParseException e) {
                    this.addError("invalid publication date format: " + pubDate);
                    this.md.setPublicationDate(this.getDefaultPubDate());
                }
            } else {
                this.md.setPublicationDate(this.getDefaultPubDate());
            }
        }

        private void ivyModuleStarted(Attributes attributes) throws SAXException {
            String version = attributes.getValue("version");
            int versionIndex = ALLOWED_VERSIONS.indexOf(version);
            if (versionIndex == -1) {
                this.addError("invalid version " + version);
                throw new SAXException("invalid version " + version);
            }
            if (versionIndex >= ALLOWED_VERSIONS.indexOf("1.3")) {
                Message.debug("post 1.3 ivy file: using exact as default matcher");
                this.defaultMatcher = this.ivy.getMatcher("exact");
            } else {
                Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                this.defaultMatcher = this.ivy.getMatcher("exactOrRegexp");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).startsWith("xmlns:")) continue;
                this.md.addExtraAttributeNamespace(attributes.getQName(i).substring("xmlns:".length()), attributes.getValue(i));
            }
        }

        private void addDependencyArtifacts(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 5;
            this.parseRule(tag, attributes);
        }

        private void addIncludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 6;
            this.parseRule(tag, attributes);
        }

        private void addExcludeRule(String tag, Attributes attributes) throws MalformedURLException {
            this.state = 7;
            this.parseRule(tag, attributes);
        }

        private void parseRule(String tag, Attributes attributes) throws MalformedURLException {
            Map extraAtt;
            ArtifactId aid;
            String module;
            String org;
            PatternMatcher matcher;
            String ext;
            String type;
            String name = this.ivy.substitute(attributes.getValue("name"));
            if (name == null && (name = this.ivy.substitute(attributes.getValue("artifact"))) == null) {
                String string = name = "artifact".equals(tag) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((type = this.ivy.substitute(attributes.getValue("type"))) == null) {
                type = "artifact".equals(tag) ? "jar" : "*";
            }
            String string = ext = (ext = this.ivy.substitute(attributes.getValue("ext"))) != null ? ext : type;
            if (this.state == 5) {
                String url = this.ivy.substitute(attributes.getValue("url"));
                Map extraAtt2 = ExtendableItemHelper.getExtraAttributes(attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor(name, type, ext, url == null ? null : new URL(url), extraAtt2);
            } else if (this.state == 6) {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.ivy.substitute(attributes.getValue("org"));
                org = org == null ? "*" : org;
                module = this.ivy.substitute(attributes.getValue("module"));
                module = module == null ? "*" : module;
                aid = new ArtifactId(new ModuleId(org, module), name, type, ext);
                extraAtt = ExtendableItemHelper.getExtraAttributes(attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule(aid, matcher, extraAtt);
            } else {
                matcher = this.getPatternMatcher(attributes.getValue("matcher"));
                org = this.ivy.substitute(attributes.getValue("org"));
                org = org == null ? "*" : org;
                module = this.ivy.substitute(attributes.getValue("module"));
                module = module == null ? "*" : module;
                aid = new ArtifactId(new ModuleId(org, module), name, type, ext);
                extraAtt = ExtendableItemHelper.getExtraAttributes(attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule(aid, matcher, extraAtt);
            }
            String confs = this.ivy.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                String[] conf = "*".equals(confs) ? this.md.getConfigurationsNames() : confs.split(",");
                for (int i = 0; i < conf.length; ++i) {
                    this.addConfiguration(conf[i].trim());
                }
            }
        }

        private void addConfiguration(String c) {
            this.confAware.addConfiguration(c);
            if (this.state != 9) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(c, (DependencyArtifactDescriptor)((Object)this.confAware));
                } else if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(c, (IncludeRule)((Object)this.confAware));
                } else if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(c, (ExcludeRule)((Object)this.confAware));
                }
            }
        }

        private PatternMatcher getPatternMatcher(String m) {
            PatternMatcher matcher;
            String matcherName = this.ivy.substitute(m);
            PatternMatcher patternMatcher = matcher = matcherName == null ? this.defaultMatcher : this.ivy.getMatcher(matcherName);
            if (matcher == null) {
                throw new IllegalArgumentException("unknown matcher " + matcherName);
            }
            return matcher;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.state == 3 && "artifact".equals(qName) && this.artifact.getConfigurations().length == 0) {
                String[] confs = this.md.getConfigurationsNames();
                for (int i = 0; i < confs.length; ++i) {
                    this.artifact.addConfiguration(confs[i]);
                    this.md.addArtifact(confs[i], this.artifact);
                }
            } else if ("configurations".equals(qName)) {
                this.checkConfigurations();
            } else if (this.state == 5 && "artifact".equals(qName) || this.state == 6 && "include".equals(qName) || this.state == 7 && "exclude".equals(qName)) {
                this.state = 4;
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs = this.md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.addConfiguration(confs[i]);
                    }
                }
                this.confAware = null;
            } else if (this.state == 9) {
                if (this.confAware.getConfigurations().length == 0) {
                    String[] confs = this.md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this.addConfiguration(confs[i]);
                    }
                }
                this.confAware = null;
                this.state = 10;
            } else if ("dependency".equals(qName)) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    this.parseDepsConfs(this.getDefaultConf(), this.dd);
                }
                this.state = 10;
            } else if ("dependencies".equals(qName)) {
                this.state = 0;
            } else if (this.state == 1 && "info".equals(qName)) {
                this.state = 0;
            } else if (this.state == 1 && "description".equals(qName)) {
                this.state = 1;
            } else if (this.state == 1) {
                this.md.addExtraInfo(qName, this.buffer == null ? "" : this.buffer.toString());
                this.buffer = null;
            }
        }

        private void checkConfigurations() {
            if (this.md.getConfigurations().length == 0) {
                this.md.addConfiguration(new Configuration("default"));
            }
        }

        private void replaceConfigurationWildcards() {
            Configuration[] configs = this.md.getConfigurations();
            for (int i = 0; i < configs.length; ++i) {
                configs[i].replaceWildcards(this.md);
            }
        }
    }
}

