/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.apache.ivy.util.url.URLHandler;

public class BasicURLHandler
extends AbstractURLHandler {
    private static final int BUFFER_SIZE = 65536;

    public BasicURLHandler() {
        Message.debug("installing " + IvyAuthenticator.INSTANCE.getClass());
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        block17: {
            URLConnection con = null;
            try {
                con = url.openConnection();
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).setRequestMethod("HEAD");
                    int status = ((HttpURLConnection)con).getResponseCode();
                    if (status == 200) {
                        URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, ((HttpURLConnection)con).getContentLength(), con.getLastModified());
                        return uRLInfo;
                    }
                    if (status == 407) {
                        Message.warn("Your proxy requires authentication.");
                    } else if (String.valueOf(status).startsWith("4")) {
                        Message.verbose("CLIENT ERROR: " + ((HttpURLConnection)con).getResponseMessage() + " url=" + url);
                    } else if (String.valueOf(status).startsWith("5")) {
                        Message.error("SERVER ERROR: " + ((HttpURLConnection)con).getResponseMessage() + " url=" + url);
                    }
                    Message.debug("HTTP response status: " + status + " url=" + url);
                    break block17;
                }
                int contentLength = con.getContentLength();
                if (contentLength <= 0) {
                    URLHandler.URLInfo uRLInfo = UNAVAILABLE;
                    return uRLInfo;
                }
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, contentLength, con.getLastModified());
                return uRLInfo;
            }
            catch (UnknownHostException e) {
                Message.warn("Host " + e.getMessage() + " not found. url=" + url);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
            }
            catch (IOException e) {
                Message.error("Server access Error: " + e.getMessage() + " url=" + url);
            }
            finally {
                this.disconnect(con);
            }
        }
        return UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openStream(URL url) throws IOException {
        URLConnection conn = null;
        InputStream inStream = null;
        try {
            int len;
            conn = url.openConnection();
            inStream = conn.getInputStream();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            this.disconnect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        URLConnection srcConn = null;
        try {
            srcConn = src.openConnection();
            int contentLength = srcConn.getContentLength();
            FileUtil.copy(srcConn.getInputStream(), dest, l);
            if (dest.length() != (long)contentLength && contentLength != -1) {
                dest.delete();
                throw new IOException("Downloaded file size doesn't match expected Content Length for " + src + ". Please retry.");
            }
        }
        finally {
            this.disconnect(srcConn);
        }
    }

    private void disconnect(URLConnection con) {
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).disconnect();
        } else if (con != null && "sun.net.www.protocol.file.FileURLConnection".equals(con.getClass().getName())) {
            try {
                con.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class HttpStatus {
        static final int SC_OK = 200;
        static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;

        private HttpStatus() {
        }
    }
}

