/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.latex.PropertyManager;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.WPListElement;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.util.TagStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WPList
extends WPTag {
    private char[] fLastSequence = null;
    private InternalList fNestedElements = null;
    private ArrayList<InternalList> fInternalListStack = new ArrayList();

    public WPList() {
        super("*#");
    }

    public boolean isEmpty() {
        return this.fNestedElements == null;
    }

    public boolean add(WPListElement listElement) {
        char[] sequence = listElement.getSequence();
        int s1Length = 0;
        int s2Length = sequence.length;
        if (this.fLastSequence != null) {
            s1Length = this.fLastSequence.length;
        } else {
            this.fNestedElements = new InternalList(sequence[0]);
            this.fInternalListStack.add(this.fNestedElements);
        }
        int min = 0;
        int level = 0;
        min = s1Length > s2Length ? s2Length : s1Length;
        level = min;
        int i = 0;
        while (i < min) {
            if (sequence[i] != this.fLastSequence[i]) {
                level = i;
                break;
            }
            ++i;
        }
        this.popListStack(level);
        if (level < s2Length) {
            i = level;
            while (i < s2Length) {
                InternalList list = new InternalList(sequence[i]);
                ((List)this.fInternalListStack.get(this.fInternalListStack.size() - 1)).add(list);
                this.fInternalListStack.add(list);
                ++i;
            }
        }
        ((List)this.fInternalListStack.get(this.fInternalListStack.size() - 1)).add(listElement);
        this.fLastSequence = sequence;
        return true;
    }

    private void popListStack(int level) {
        if (this.fInternalListStack.size() > level) {
            int i = this.fInternalListStack.size() - 1;
            while (i > level) {
                this.fInternalListStack.remove(i);
                --i;
            }
        }
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (!this.isEmpty()) {
            this.fInternalListStack = null;
            int i = 0;
            while (i < this.fNestedElements.size()) {
                Object element = this.fNestedElements.get(i);
                if (element instanceof InternalList) {
                    InternalList subList = (InternalList)element;
                    this.beginHTMLTag(buf, subList);
                    this.renderSubListHTML(subList, converter, buf, wikiModel);
                    if (subList.fChar == '*') {
                        buf.append("</ul>");
                    } else {
                        buf.append("</ol>");
                    }
                } else {
                    TagStack stack = ((WPListElement)element).getTagStack();
                    if (stack != null) {
                        converter.nodesToText(stack.getNodeList(), buf, wikiModel);
                    }
                }
                ++i;
            }
        }
    }

    private void beginHTMLTag(Appendable buf, InternalList subList) throws IOException {
        if (subList.fChar == '*') {
            buf.append("\n<ul>");
        } else {
            buf.append("\n<ol>");
        }
    }

    private void endHTMLTag(Appendable buf, InternalList subList) throws IOException {
        if (subList.fChar == '*') {
            buf.append("</ul>");
        } else {
            buf.append("</ol>");
        }
    }

    private void renderSubListHTML(InternalList list, ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (list.size() > 0) {
            buf.append("\n<li>");
        }
        int i = 0;
        while (i < list.size()) {
            Object element = list.get(i);
            if (element instanceof InternalList) {
                InternalList subList = (InternalList)element;
                this.beginHTMLTag(buf, subList);
                this.renderSubListHTML(subList, converter, buf, wikiModel);
                this.endHTMLTag(buf, subList);
            } else {
                TagStack stack = ((WPListElement)element).getTagStack();
                if (stack != null) {
                    converter.nodesToText(stack.getNodeList(), buf, wikiModel);
                }
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof WPListElement) {
                buf.append("</li>\n<li>");
            }
            ++i;
        }
        if (list.size() > 0) {
            buf.append("</li>");
        }
    }

    private void beginLaTeXTag(Appendable _out, InternalList subList) throws IOException {
        if (subList.fChar == '*') {
            _out.append(PropertyManager.get("List.Unnumbered.Begin"));
        } else if (subList.fChar == '#') {
            _out.append(PropertyManager.get("List.Numbered.Begin"));
        }
    }

    private void endLaTeXTag(Appendable _out, InternalList subList) throws IOException {
        if (subList.fChar == '*') {
            _out.append(PropertyManager.get("List.Unnumbered.End"));
        } else if (subList.fChar == '#') {
            _out.append(PropertyManager.get("List.Numbered.End"));
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel wikiModel) throws IOException {
        if (!this.isEmpty()) {
            this.fInternalListStack = null;
            int i = 0;
            while (i < this.fNestedElements.size()) {
                Object element = this.fNestedElements.get(i);
                if (element instanceof InternalList) {
                    InternalList subList = (InternalList)element;
                    this.beginLaTeXTag(_out, subList);
                    this.renderSubListLaTeX(subList, converter, _out, wikiModel);
                    this.endLaTeXTag(_out, subList);
                } else {
                    TagStack stack = ((WPListElement)element).getTagStack();
                    if (stack != null) {
                        converter.nodesToText(stack.getNodeList(), _out, wikiModel);
                    }
                }
                ++i;
            }
        }
    }

    private void renderSubListLaTeX(InternalList list, ITextConverter converter, Appendable _out, IWikiModel wikiModel) throws IOException {
        if (list.size() > 0) {
            _out.append(PropertyManager.get("List.Item.Begin"));
        }
        String itemStr = String.valueOf(PropertyManager.get("List.Item.Begin")) + PropertyManager.get("List.Item.End");
        int i = 0;
        while (i < list.size()) {
            Object element = list.get(i);
            if (element instanceof InternalList) {
                InternalList subList = (InternalList)element;
                this.beginLaTeXTag(_out, subList);
                this.renderSubListLaTeX(subList, converter, _out, wikiModel);
                _out.append(PropertyManager.get("List.Item.End"));
            } else {
                TagStack stack = ((WPListElement)element).getTagStack();
                converter.nodesToText(stack.getNodeList(), _out, wikiModel);
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof WPListElement) {
                _out.append(itemStr);
            }
            ++i;
        }
        if (list.size() > 0) {
            _out.append(PropertyManager.get("List.Item.End"));
        }
    }

    public Object clone() {
        WPList tt = (WPList)super.clone();
        tt.fNestedElements = this.fNestedElements == null ? null : (InternalList)this.fNestedElements.clone();
        tt.fInternalListStack = (ArrayList)this.fInternalListStack.clone();
        if (this.fLastSequence == null) {
            tt.fLastSequence = null;
        } else {
            tt.fLastSequence = new char[this.fLastSequence.length];
            System.arraycopy(this.fLastSequence, 0, tt.fLastSequence, 0, this.fLastSequence.length);
        }
        return tt;
    }

    public boolean isReduceTokenStack() {
        return true;
    }

    public String getParents() {
        return "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalList
    extends ArrayList<Object> {
        private static final long serialVersionUID = -3760843632697162014L;
        char fChar;

        public InternalList(char ch) {
            this.fChar = ch;
        }
    }
}

