/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.init;

import com.nokia.maven.scm.command.init.InitScmResult;
import com.nokia.maven.scm.provider.hg.repository.HgScmProviderRepository;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;

public class HgInitCommand
extends AbstractCommand
implements Command {
    private static Logger log = Logger.getLogger(HgInitCommand.class);

    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet basedir, CommandParameters args) throws ScmException {
        return this.executeInitCommand(repository);
    }

    public InitScmResult executeInitCommand(ScmProviderRepository repository) throws ScmException {
        boolean workingDirReady;
        log.info((Object)("executeInitCommand: " + repository));
        HgScmProviderRepository hgRepo = (HgScmProviderRepository)repository;
        String uri = hgRepo.getURI();
        log.info((Object)uri);
        File hgRepoDir = new File(uri);
        File hgRepoRootDir = hgRepoDir.getParentFile();
        if (!hgRepoRootDir.exists() && !(workingDirReady = hgRepoRootDir.mkdirs())) {
            throw new ScmException("Could not initiate test branch at: " + hgRepoRootDir);
        }
        String[] initCmd = new String[]{"init", hgRepoDir.getName()};
        ScmResult result = HgUtils.execute((File)hgRepoRootDir, (String[])initCmd);
        return new InitScmResult(result.getCommandLine(), result.getProviderMessage(), result.getCommandOutput(), result.isSuccess());
    }
}

