/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.core.PropertiesSource;
import com.nokia.helium.core.TemplateProcessorException;
import com.nokia.helium.core.XMLTemplateSource;
import com.nokia.helium.diamonds.DiamondsConfig;
import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsListenerImpl;
import com.nokia.helium.diamonds.Target;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Project;

public class TargetDiamondsListener
extends DiamondsListenerImpl {
    private Project project;
    private Logger log = Logger.getLogger(TargetDiamondsListener.class);
    private Map<String, Target> targetsMap = DiamondsConfig.getTargets();
    private String currentTarget;

    private boolean isTargetsToExecute(BuildEvent buildEvent) {
        this.project = buildEvent.getProject();
        org.apache.tools.ant.Target target = buildEvent.getTarget();
        boolean retValue = false;
        Target currentTarget = this.targetsMap.get(target.getName());
        String currentTargetName = null;
        if (currentTarget != null) {
            currentTargetName = currentTarget.getTargetName();
        }
        if (currentTargetName != null) {
            String ifCondition = target.getIf();
            String unlessCondition = target.getUnless();
            if (ifCondition == null && unlessCondition == null) {
                retValue = true;
            } else {
                String ifProperty = this.project.getProperty(ifCondition);
                String unlessProperty = this.project.getProperty(unlessCondition);
                if (ifProperty != null || unlessProperty == null) {
                    retValue = true;
                }
            }
        }
        return retValue;
    }

    @Override
    public void targetBegin(BuildEvent buildEvent) throws DiamondsException {
        String targetName = buildEvent.getTarget().getName();
        if (this.isTargetsToExecute(buildEvent)) {
            this.currentTarget = targetName;
            Target target = this.targetsMap.get(this.currentTarget);
            if (!target.isDefer()) {
                this.initDiamondsClient();
            }
        }
    }

    @Override
    public void targetEnd(BuildEvent buildEvent) throws DiamondsException {
        String targetName = buildEvent.getTarget().getName();
        if (this.currentTarget != null && this.currentTarget.equals(targetName)) {
            if (this.getIsInitialized()) {
                this.log.debug((Object)("diamonds:TargetDiamondsListener:finished recording, sending data to diamonds for target: " + buildEvent.getTarget().getName()));
                this.sendTargetData(buildEvent, buildEvent.getTarget().getProject());
            }
            this.currentTarget = null;
        }
    }

    private void sendTargetData(BuildEvent buildEvent, Project project) throws DiamondsException {
        Target target = this.targetsMap.get(this.currentTarget);
        String sourceFile = target.getSource();
        if (sourceFile == null) {
            sourceFile = this.getSourceFile(target.getTargetName());
        }
        Object antProperties = null;
        String targetTemplateFile = target.getTemplateFile();
        if (targetTemplateFile == null) {
            targetTemplateFile = target.getTargetName() + ".xml.ftl";
        }
        String output = DiamondsConfig.getOutputDir() + File.separator + target.getTargetName() + ".xml";
        File templateFile = new File(DiamondsConfig.getTemplateDir(), targetTemplateFile);
        ArrayList<Object> sourceList = new ArrayList<Object>();
        if (sourceFile == null) {
            this.log.debug((Object)"diamonds:TargetDiamondsListener:sourceFile not defined.");
        } else {
            sourceList.add(new XMLTemplateSource("doc", new File(sourceFile)));
        }
        if (target.isAntPropertiesRequired()) {
            sourceList.add(new PropertiesSource("ant", (Map)project.getProperties()));
        }
        try {
            if (templateFile.exists()) {
                if (antProperties != null || sourceFile != null) {
                    this.getTemplateProcessor().convertTemplate(DiamondsConfig.getTemplateDir(), targetTemplateFile, output, sourceList);
                }
            } else {
                this.log.debug((Object)("sendTargetData: exists(" + templateFile.getAbsolutePath() + ") => false"));
            }
        }
        catch (TemplateProcessorException e1) {
            throw new DiamondsException("template conversion error while sending data for target:" + target + ":" + e1.getMessage());
        }
        File outputFile = new File(output);
        if (outputFile.exists()) {
            TargetDiamondsListener.mergeToFullResults(outputFile);
            if (!target.isDefer()) {
                this.getDiamondsClient().sendData(outputFile.getAbsolutePath(), DiamondsConfig.getDiamondsProperties().getDiamondsBuildID());
            } else {
                this.log.debug((Object)("diamonds:TargetDiamondsListener:defer logging for: " + outputFile));
                this.getDeferLogList().add(output);
            }
        } else {
            this.log.debug((Object)("diamonds:TargetDiamondsListener:outputfile " + outputFile + " does not exist"));
        }
    }
}

