/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform;

import com.sardak.antform.gui.CallBack;
import com.sardak.antform.gui.Control;
import com.sardak.antform.interfaces.ActionComponent;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.interfaces.DummyComponent;
import com.sardak.antform.interfaces.Focusable;
import com.sardak.antform.interfaces.Requirable;
import com.sardak.antform.types.AntMenuItem;
import com.sardak.antform.types.BaseType;
import com.sardak.antform.types.Button;
import com.sardak.antform.types.ButtonBar;
import com.sardak.antform.types.Label;
import com.sardak.antform.util.ActionRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public abstract class AbstractTaskWindow
extends Task
implements CallBack {
    protected String title = null;
    private String stylesheet = null;
    protected String image = null;
    private File iconFile = null;
    private int height = -1;
    private int width = -1;
    protected Control control;
    protected boolean needFail = false;
    protected String lookAndFeel = null;
    protected List widgets;
    protected List displayedWidgets;
    protected boolean dynamic = false;
    protected boolean tabbed = false;
    private ActionRegistry actionRegistry;
    private boolean loop = false;
    private ActionComponent actionSource = null;
    private boolean showWhenEmpty = false;

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setFalse(String propertyName) {
        if (this.getProject().getProperties().containsKey(propertyName)) {
            this.getProject().setProperty(propertyName, Boolean.FALSE + "");
        }
    }

    protected void build() {
        this.displayedWidgets = new ArrayList();
        for (int i = 0; i < this.widgets.size(); ++i) {
            BaseType o = (BaseType)((Object)this.widgets.get(i));
            if (o.validate(this)) {
                if (o.shouldBeDisplayed(this.getProject())) {
                    if (o instanceof DummyComponent) {
                        o = ((DummyComponent)((Object)o)).getRealType();
                        this.widgets.set(i, o);
                    }
                    o.addToControlPanel(this.control.getPanel());
                    this.displayedWidgets.add(o);
                }
                if (o.getIf() == null && o.getUnless() == null) continue;
                this.dynamic = true;
                continue;
            }
            this.needFail = true;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Control getControl() {
        return this.control;
    }

    public void addConfiguredAntMenuItem(AntMenuItem menuItem) {
        if (menuItem.validate(this)) {
            this.widgets.add(menuItem);
        } else {
            this.needFail = true;
        }
    }

    public void addConfiguredButtonBar(ButtonBar buttonBar) {
        this.widgets.add(buttonBar);
        buttonBar.register(this.getActionRegistry());
    }

    public void addConfiguredButton(Button button) {
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setProject(this.getProject());
        buttonBar.addConfiguredButton(button);
        buttonBar.setMargins(0, 100, 0, 100);
        this.addConfiguredButtonBar(buttonBar);
    }

    public void addConfiguredLabel(Label label) {
        this.widgets.add(label);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void preliminaries() {
        if (this.control == null) {
            this.control = new Control(this, this.title, this.iconFile, this.image, this.tabbed);
            if (this.lookAndFeel != null) {
                this.control.updateLookAndFeel(this.lookAndFeel);
            }
        }
    }

    public void execute() throws BuildException {
        this.control.setWidth(this.width);
        this.control.setHeight(this.height);
        if (this.needFail) {
            throw new BuildException("certain properties where not correctly set.");
        }
        this.control.setTitle(this.getTitle());
        if (this.stylesheet != null) {
            try {
                this.control.setStyleSheet(this.stylesheet);
                this.control.getPanel().setStyleSheet(this.stylesheet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.control.setFocusedComponent(this.getFocusedComponent());
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public Target findTargetByName(String target) {
        Target targetToFind = null;
        Hashtable targets = this.getProject().getTargets();
        Iterator i = targets.keySet().iterator();
        while (i.hasNext()) {
            String targetName = (String)i.next();
            Target aTarget = (Target)targets.get(targetName);
            if (!aTarget.getName().equals(target)) continue;
            targetToFind = aTarget;
        }
        return targetToFind;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public File getIcon() {
        return this.iconFile;
    }

    public void setIcon(File icon) {
        this.iconFile = icon;
    }

    public boolean showWhenEmpty() {
        return this.showWhenEmpty;
    }

    public void setShowWhenEmpty(boolean showWhenEmpty) {
        this.showWhenEmpty = showWhenEmpty;
    }

    protected boolean shouldShow() {
        return this.showWhenEmpty() || !this.displayedWidgets.isEmpty();
    }

    public ActionComponent getActionSource() {
        return this.actionSource;
    }

    public void setActionSource(ActionComponent actionSource) {
        this.actionSource = actionSource;
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry(this);
        }
        return this.actionRegistry;
    }

    public boolean requiredStatusOk() {
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Requirable) || ((Requirable)o).requiredStatusOk()) continue;
            return false;
        }
        return true;
    }

    public void ok() {
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ActionListenerComponent)) continue;
            ((ActionListenerComponent)o).ok();
        }
    }

    public void cancel() {
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ActionListenerComponent)) continue;
            ((ActionListenerComponent)o).cancel();
        }
    }

    public void reset() {
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ActionListenerComponent)) continue;
            ((ActionListenerComponent)o).reset();
        }
    }

    private JComponent getFocusedComponent() {
        JComponent focusableComponent = null;
        JComponent firstFocusableComponent = null;
        Iterator iter = this.displayedWidgets.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Focusable)) continue;
            Focusable f = (Focusable)o;
            if (firstFocusableComponent == null) {
                firstFocusableComponent = f.getFocusableComponent();
            }
            if (!f.isFocus()) continue;
            focusableComponent = f.getFocusableComponent();
            break;
        }
        if (focusableComponent == null && firstFocusableComponent != null) {
            focusableComponent = firstFocusableComponent;
        }
        return focusableComponent;
    }
}

