/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.StringUtils;

public final class PomModuleDescriptorWriter {
    private static boolean addIvyVersion = true;
    public static final ConfigurationScopeMapping DEFAULT_MAPPING = new ConfigurationScopeMapping(new HashMap(){
        {
            this.put("compile, runtime", "compile");
            this.put("runtime", "runtime");
            this.put("provided", "provided");
            this.put("test", "test");
            this.put("system", "system");
        }
    });

    static void setAddIvyVersion(boolean addIvyVersion) {
        PomModuleDescriptorWriter.addIvyVersion = addIvyVersion;
    }

    private PomModuleDescriptorWriter() {
    }

    public static void write(ModuleDescriptor md, ConfigurationScopeMapping mapping, File output) throws IOException {
        PomModuleDescriptorWriter.write(md, null, mapping, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor md, String licenseHeader, ConfigurationScopeMapping mapping, File output) throws IOException {
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        try {
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (licenseHeader != null) {
                out.print(licenseHeader);
            }
            out.println("<!--");
            out.println("   Apache Maven 2 POM generated by Apache Ivy");
            out.println("   " + Ivy.getIvyHomeURL());
            if (addIvyVersion) {
                out.println("   Apache Ivy version: " + Ivy.getIvyVersion() + " " + Ivy.getIvyDate());
            }
            out.println("-->");
            out.println("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            out.println("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n");
            out.println("  <modelVersion>4.0.0</modelVersion>");
            PomModuleDescriptorWriter.printModuleId(md, out);
            PomModuleDescriptorWriter.printDependencies(md, mapping, out);
            out.println("</project>");
        }
        finally {
            out.close();
        }
    }

    private static void printModuleId(ModuleDescriptor md, PrintWriter out) {
        ModuleRevisionId mrid = md.getModuleRevisionId();
        out.println("  <groupId>" + mrid.getOrganisation() + "</groupId>");
        out.println("  <artifactId>" + mrid.getName() + "</artifactId>");
        out.println("  <packaging>jar</packaging>");
        if (mrid.getRevision() != null) {
            out.println("  <version>" + mrid.getRevision() + "</version>");
        }
        if (md.getHomePage() != null) {
            out.println("  <url>" + md.getHomePage() + "</url>");
        }
    }

    private static void printDependencies(ModuleDescriptor md, ConfigurationScopeMapping mapping, PrintWriter out) {
        DependencyDescriptor[] dds = md.getDependencies();
        if (dds.length > 0) {
            out.println("  <dependencies>");
            for (int i = 0; i < dds.length; ++i) {
                ModuleRevisionId mrid = dds[i].getDependencyRevisionId();
                out.println("    <dependency>");
                out.println("      <groupId>" + mrid.getOrganisation() + "</groupId>");
                out.println("      <artifactId>" + mrid.getName() + "</artifactId>");
                out.println("      <version>" + mrid.getRevision() + "</version>");
                String scope = mapping.getScope(dds[i].getModuleConfigurations());
                if (scope != null) {
                    out.println("      <scope>" + scope + "</scope>");
                }
                if (mapping.isOptional(dds[i].getModuleConfigurations())) {
                    out.println("      <optional>true</optional>");
                }
                out.println("    </dependency>");
            }
            out.println("  </dependencies>");
        }
    }

    public static class ConfigurationScopeMapping {
        private Map scopes;

        public ConfigurationScopeMapping(Map scopesMapping) {
            this.scopes = new HashMap(scopesMapping);
        }

        public String getScope(String[] confs) {
            return (String)this.scopes.get(StringUtils.join(confs, ", "));
        }

        public boolean isOptional(String[] confs) {
            return this.getScope(confs) == null;
        }
    }
}

