/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class FromTable
extends ResultSetNode
implements Optimizable {
    Properties tableProperties;
    String correlationName;
    TableName corrTableName;
    int tableNumber;
    int level;
    int[] hashKeyColumns;
    int initialCapacity = -1;
    float loadFactor = -1.0f;
    int maxCapacity = -1;
    AccessPathImpl currentAccessPath;
    AccessPathImpl bestAccessPath;
    AccessPathImpl bestSortAvoidancePath;
    AccessPathImpl trulyTheBestAccessPath;
    private int joinStrategyNumber;
    protected String userSpecifiedJoinStrategy;
    protected CostEstimate bestCostEstimate;
    private FormatableBitSet refCols;
    private double perRowUsage = -1.0;
    private boolean considerSortAvoidancePath;
    private HashMap bestPlanMap;
    protected static final short REMOVE_PLAN = 0;
    protected static final short ADD_PLAN = 1;
    protected static final short LOAD_PLAN = 2;
    protected TableName origTableName;

    FromTable() {
    }

    public void init(Object object, Object object2) {
        this.correlationName = (String)object;
        this.tableProperties = (Properties)object2;
        this.tableNumber = -1;
        this.bestPlanMap = null;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        this.updateBestPlanMap((short)1, this);
        CostEstimate costEstimate2 = this.estimateCost(optimizablePredicateList, null, costEstimate, optimizer, rowOrdering);
        this.getCostEstimate(optimizer);
        this.setCostEstimate(costEstimate2);
        this.optimizeSubqueries(this.getDataDictionary(), this.costEstimate.rowCount());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, optimizablePredicateList, this.getCostEstimate(), costEstimate);
        return this.getCostEstimate();
    }

    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, RowOrdering rowOrdering) throws StandardException {
        int n = optimizer.getNumberOfJoinStrategies();
        boolean bl = false;
        AccessPath accessPath = this.getCurrentAccessPath();
        if (this.userSpecifiedJoinStrategy != null) {
            if (accessPath.getJoinStrategy() != null) {
                accessPath.setJoinStrategy(null);
                bl = false;
            } else {
                accessPath.setJoinStrategy(optimizer.getJoinStrategy(this.userSpecifiedJoinStrategy));
                if (accessPath.getJoinStrategy() == null) {
                    throw StandardException.newException("42Y56", (Object)this.userSpecifiedJoinStrategy, (Object)this.getBaseTableName());
                }
                bl = true;
            }
        } else if (this.joinStrategyNumber < n) {
            accessPath.setJoinStrategy(optimizer.getJoinStrategy(this.joinStrategyNumber));
            ++this.joinStrategyNumber;
            bl = true;
            optimizer.trace(28, this.tableNumber, 0, 0.0, accessPath.getJoinStrategy());
        }
        this.tellRowOrderingAboutConstantColumns(rowOrdering, optimizablePredicateList);
        return bl;
    }

    protected boolean canBeOrdered() {
        return false;
    }

    public AccessPath getCurrentAccessPath() {
        return this.currentAccessPath;
    }

    public AccessPath getBestAccessPath() {
        return this.bestAccessPath;
    }

    public AccessPath getBestSortAvoidancePath() {
        return this.bestSortAvoidancePath;
    }

    public AccessPath getTrulyTheBestAccessPath() {
        return this.trulyTheBestAccessPath;
    }

    public void rememberSortAvoidancePath() {
        this.considerSortAvoidancePath = true;
    }

    public boolean considerSortAvoidancePath() {
        return this.considerSortAvoidancePath;
    }

    public void rememberJoinStrategyAsBest(AccessPath accessPath) {
        Optimizer optimizer = accessPath.getOptimizer();
        accessPath.setJoinStrategy(this.getCurrentAccessPath().getJoinStrategy());
        optimizer.trace(49, this.tableNumber, 0, 0.0, this.getCurrentAccessPath().getJoinStrategy());
        if (accessPath == this.bestAccessPath) {
            optimizer.trace(50, this.tableNumber, 0, 0.0, accessPath);
        } else if (accessPath == this.bestSortAvoidancePath) {
            optimizer.trace(51, this.tableNumber, 0, 0.0, accessPath);
        } else {
            optimizer.trace(52, this.tableNumber, 0, 0.0, accessPath);
        }
    }

    public TableDescriptor getTableDescriptor() {
        return null;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        return this;
    }

    public boolean isCoveringIndex(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        return false;
    }

    public Properties getProperties() {
        return this.tableProperties;
    }

    public void setProperties(Properties properties) {
        this.tableProperties = properties;
    }

    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean bl = false;
        Enumeration<Object> enumeration = this.tableProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.tableProperties.get(string);
            if (string.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(string2);
                continue;
            }
            if (string.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(string2, string);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (string.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.valueOf(string2).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("42Y58", (Object)string2, (Object)string);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", string2);
            }
            if (string.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(string2, string);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            throw StandardException.newException("42Y44", (Object)string, (Object)"joinStrategy");
        }
    }

    public String getName() throws StandardException {
        return this.getExposedName();
    }

    public String getBaseTableName() {
        return "";
    }

    public int convertAbsoluteToRelativeColumnPosition(int n) {
        return n;
    }

    public void updateBestPlanMap(short s, Object object) throws StandardException {
        if (s == 0) {
            if (this.bestPlanMap != null) {
                this.bestPlanMap.remove(object);
                if (this.bestPlanMap.size() == 0) {
                    this.bestPlanMap = null;
                }
            }
            return;
        }
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        AccessPathImpl accessPathImpl = null;
        if (s == 1) {
            if (accessPath == null) {
                return;
            }
            if (this.bestPlanMap == null) {
                this.bestPlanMap = new HashMap();
            } else {
                accessPathImpl = (AccessPathImpl)this.bestPlanMap.get(object);
            }
            if (accessPathImpl == null) {
                accessPathImpl = object instanceof Optimizer ? new AccessPathImpl((Optimizer)object) : new AccessPathImpl(null);
            }
            accessPathImpl.copy(accessPath);
            this.bestPlanMap.put(object, accessPathImpl);
            return;
        }
        if (this.bestPlanMap == null) {
            return;
        }
        accessPathImpl = (AccessPathImpl)this.bestPlanMap.get(object);
        if (accessPathImpl == null || accessPathImpl.getCostEstimate() == null) {
            return;
        }
        accessPath.copy(accessPathImpl);
    }

    public void rememberAsBest(int n, Optimizer optimizer) throws StandardException {
        Object object;
        AccessPath accessPath = null;
        switch (n) {
            case 1: {
                accessPath = this.getBestAccessPath();
                break;
            }
            case 2: {
                accessPath = this.getBestSortAvoidancePath();
                break;
            }
        }
        this.getTrulyTheBestAccessPath().copy(accessPath);
        if (!(this instanceof ProjectRestrictNode)) {
            this.updateBestPlanMap((short)1, optimizer);
        } else {
            object = (ProjectRestrictNode)this;
            if (!(((SingleChildResultSetNode)object).getChildResult() instanceof Optimizable)) {
                this.updateBestPlanMap((short)1, optimizer);
            }
        }
        object = accessPath.getConglomerateDescriptor();
        if (this.isBaseTable()) {
            DataDictionary dataDictionary = this.getDataDictionary();
            TableDescriptor tableDescriptor = this.getTableDescriptor();
            this.getTrulyTheBestAccessPath().initializeAccessPathName(dataDictionary, tableDescriptor);
        }
        this.setCostEstimate(accessPath.getCostEstimate());
        accessPath.getOptimizer().trace(29, this.tableNumber, n, 0.0, accessPath);
    }

    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        this.resetJoinStrategies(optimizer);
        this.considerSortAvoidancePath = false;
        CostEstimate costEstimate = this.getBestAccessPath().getCostEstimate();
        if (costEstimate != null) {
            costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if ((costEstimate = this.getBestSortAvoidancePath().getCostEstimate()) != null) {
            costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (!this.canBeOrdered()) {
            rowOrdering.addUnorderedOptimizable(this);
        }
    }

    protected void resetJoinStrategies(Optimizer optimizer) {
        this.joinStrategyNumber = 0;
        this.getCurrentAccessPath().setJoinStrategy(null);
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        return null;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getTrulyTheBestAccessPath() == null ? this.costEstimate : this.getTrulyTheBestAccessPath().getCostEstimate();
        return this.finalCostEstimate;
    }

    public boolean isBaseTable() {
        return false;
    }

    public boolean isMaterializable() throws StandardException {
        HasCorrelatedCRsVisitor hasCorrelatedCRsVisitor = new HasCorrelatedCRsVisitor();
        this.accept(hasCorrelatedCRsVisitor);
        return !hasCorrelatedCRsVisitor.hasCorrelatedCRs();
    }

    public boolean supportsMultipleInstantiations() {
        return true;
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public boolean hasTableNumber() {
        return this.tableNumber >= 0;
    }

    public boolean forUpdate() {
        return false;
    }

    public int initialCapacity() {
        return 0;
    }

    public float loadFactor() {
        return 0.0f;
    }

    public int maxCapacity(JoinStrategy joinStrategy, int n) throws StandardException {
        return joinStrategy.maxCapacity(this.maxCapacity, n, this.getPerRowUsage());
    }

    private double getPerRowUsage() throws StandardException {
        if (this.perRowUsage < 0.0) {
            FormatableBitSet formatableBitSet = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
            this.perRowUsage = 0.0;
            for (int i = 0; i < formatableBitSet.size(); ++i) {
                ResultColumn resultColumn;
                DataTypeDescriptor dataTypeDescriptor;
                if (!formatableBitSet.isSet(i) || (dataTypeDescriptor = (resultColumn = (ResultColumn)this.resultColumns.elementAt(i)).getExpression().getTypeServices()) == null) continue;
                this.perRowUsage += dataTypeDescriptor.estimatedMemoryUsage();
            }
            ConglomerateDescriptor conglomerateDescriptor = this.getCurrentAccessPath().getConglomerateDescriptor();
            if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                this.perRowUsage += 12.0;
            }
        }
        return this.perRowUsage;
    }

    public int[] hashKeyColumns() {
        return this.hashKeyColumns;
    }

    public void setHashKeyColumns(int[] nArray) {
        this.hashKeyColumns = nArray;
    }

    public boolean feasibleJoinStrategy(OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        return this.getCurrentAccessPath().getJoinStrategy().feasible(this, optimizablePredicateList, optimizer);
    }

    public boolean memoryUsageOK(double d, int n) throws StandardException {
        if (this.userSpecifiedJoinStrategy != null) {
            return true;
        }
        int n2 = d > 2.147483647E9 ? Integer.MAX_VALUE : (int)d;
        return n2 <= this.maxCapacity(this.getCurrentAccessPath().getJoinStrategy(), n);
    }

    public boolean legalJoinOrder(JBitSet jBitSet) {
        return true;
    }

    public int getNumColumnsReturned() {
        return this.resultColumns.size();
    }

    public boolean isTargetTable() {
        return false;
    }

    public boolean isOneRowScan() throws StandardException {
        return this.isOneRowResultSet();
    }

    public void initAccessPaths(Optimizer optimizer) {
        if (this.currentAccessPath == null) {
            this.currentAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestAccessPath == null) {
            this.bestAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestSortAvoidancePath == null) {
            this.bestSortAvoidancePath = new AccessPathImpl(optimizer);
        }
        if (this.trulyTheBestAccessPath == null) {
            this.trulyTheBestAccessPath = new AccessPathImpl(optimizer);
        }
    }

    public double uniqueJoin(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        return -1.0;
    }

    private FormatableBitSet getRefCols() {
        if (this.refCols == null) {
            this.refCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
        }
        return this.refCols;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.tableProperties == null) {
            return null;
        }
        return this.tableProperties.getProperty("joinStrategy");
    }

    protected boolean cursorTargetTable() {
        return false;
    }

    protected CostEstimate getCostEstimate(Optimizer optimizer) {
        if (this.costEstimate == null) {
            this.costEstimate = optimizer.newCostEstimate();
        }
        return this.costEstimate;
    }

    protected CostEstimate getScratchCostEstimate(Optimizer optimizer) {
        if (this.scratchCostEstimate == null) {
            this.scratchCostEstimate = optimizer.newCostEstimate();
        }
        return this.scratchCostEstimate;
    }

    protected void setCostEstimate(CostEstimate costEstimate) {
        this.costEstimate = this.getCostEstimate();
        this.costEstimate.setCost(costEstimate);
    }

    protected void assignCostEstimate(CostEstimate costEstimate) {
        this.costEstimate = costEstimate;
    }

    public String toString() {
        return "";
    }

    public ResultColumnList getResultColumnsForList(TableName tableName, ResultColumnList resultColumnList, TableName tableName2) throws StandardException {
        ResultColumnList resultColumnList2 = null;
        TableName tableName3 = this.correlationName == null ? tableName2 : (tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName));
        if (tableName != null && !tableName.equals(tableName3)) {
            return null;
        }
        TableName tableName4 = this.correlationName == null ? tableName2 : this.makeTableName(null, this.correlationName);
        resultColumnList2 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, string, tableName4, this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, valueNode, this.getContextManager());
            resultColumnList2.addResultColumn(resultColumn);
        }
        return resultColumnList2;
    }

    void pushExpressions(PredicateList predicateList) throws StandardException {
    }

    public String getExposedName() throws StandardException {
        return null;
    }

    public void setTableNumber(int n) {
        this.tableNumber = n;
    }

    public TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    void decrementLevel(int n) {
        if (this.level > 0) {
            this.level -= n;
        }
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(this.corrTableName);
    }

    public SchemaDescriptor getSchemaDescriptor(TableName tableName) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(tableName.getSchemaName());
        return schemaDescriptor;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        if (string2 != null) {
            return null;
        }
        if (this.getExposedName().equals(string)) {
            return this;
        }
        return null;
    }

    public boolean isFlattenableJoinNode() {
        return false;
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        return false;
    }

    public FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        return this;
    }

    public void fillInReferencedTableMap(JBitSet jBitSet) {
        if (this.tableNumber != -1) {
            jBitSet.set(this.tableNumber);
        }
    }

    protected void markUpdatableByCursor(Vector vector) {
        this.resultColumns.markUpdatableByCursor(vector);
    }

    public FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList) throws StandardException {
        return null;
    }

    void optimizeSubqueries(DataDictionary dataDictionary, double d) throws StandardException {
    }

    protected void tellRowOrderingAboutConstantColumns(RowOrdering rowOrdering, OptimizablePredicateList optimizablePredicateList) {
        if (optimizablePredicateList != null) {
            for (int i = 0; i < optimizablePredicateList.size(); ++i) {
                ColumnReference columnReference;
                Predicate predicate = (Predicate)optimizablePredicateList.getOptPredicate(i);
                if (!predicate.equalsComparisonWithConstantExpression(this) || (columnReference = predicate.getRelop().getColumnOperand(this)) == null) continue;
                rowOrdering.columnAlwaysOrdered(this, columnReference.getColumnNumber());
            }
        }
    }

    public boolean needsSpecialRCLBinding() {
        return false;
    }

    public void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    public TableName getOrigTableName() {
        return this.origTableName;
    }
}

