/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.plexus;

import com.nokia.helium.core.plexus.StreamMultiplexer;
import com.nokia.helium.core.plexus.StreamRecorder;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class CommandBase<T extends Exception> {
    private final Logger log = Logger.getLogger(this.getClass());
    private Vector<StreamConsumer> outputHandlers = new Vector();
    private Vector<StreamConsumer> errorHandlers = new Vector();

    protected abstract String getExecutable();

    protected abstract void throwException(String var1, Throwable var2) throws T;

    protected void throwException(String message) throws T {
        this.throwException(message, null);
    }

    public File getWorkingDir() {
        return new File(".");
    }

    public void addOutputLineHandler(StreamConsumer lineHandler) {
        if (lineHandler != null) {
            this.outputHandlers.add(lineHandler);
        }
    }

    public void addErrorLineHandler(StreamConsumer lineHandler) {
        if (lineHandler != null) {
            this.errorHandlers.add(lineHandler);
        }
    }

    public void execute(String[] args) throws T {
        this.execute(args, null);
    }

    public void execute(String[] args, StreamConsumer output) throws T {
        this.execute(args, null, output);
    }

    public void executeCmdLine(String argLine, Map<String, String> env, StreamConsumer output) throws T {
        Commandline cmdLine = new Commandline();
        cmdLine.createArg().setValue(this.getExecutable());
        if (argLine != null) {
            cmdLine.createArg().setLine(argLine);
        }
        this.executeCmd(cmdLine, env, output);
    }

    private void executeCmd(Commandline cmdLine, Map<String, String> env, StreamConsumer output) throws T {
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                cmdLine.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cmdLine.setWorkingDirectory(this.getWorkingDir());
        if (Os.isFamily((String)"windows")) {
            cmdLine.createArg().setLine("&& exit %%ERRORLEVEL%%");
        }
        StreamMultiplexer inputMux = new StreamMultiplexer();
        if (output != null) {
            inputMux.addHandler(output);
        }
        for (StreamConsumer lh : this.outputHandlers) {
            inputMux.addHandler(lh);
        }
        StreamMultiplexer errorMux = new StreamMultiplexer();
        StreamRecorder errorRecorder = new StreamRecorder();
        errorMux.addHandler(errorRecorder);
        for (StreamConsumer lh : this.errorHandlers) {
            errorMux.addHandler(lh);
        }
        try {
            int err = CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)inputMux, (StreamConsumer)errorMux);
            this.log.debug((Object)("Execution of " + this.getExecutable() + " returned: " + err));
            if (err != 0) {
                this.throwException(errorRecorder.getBuffer() + " (return code: " + err + ")");
            }
        }
        catch (CommandLineException e) {
            this.throwException("Error executing " + this.getExecutable() + ": " + e.toString());
        }
    }

    public void execute(String[] args, Map<String, String> env, StreamConsumer output) throws T {
        Commandline cmdLine = new Commandline();
        cmdLine.createArg().setValue(this.getExecutable());
        if (args != null) {
            cmdLine.addArguments(args);
        }
        this.executeCmd(cmdLine, env, output);
    }
}

