/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.Set;

public class UnusedImportsCheck
extends Check {
    private boolean mCollect;
    private final Set<FullIdent> mImports = Sets.newHashSet();
    private final Set<String> mReferenced = Sets.newHashSet();

    public void beginTree(DetailAST aRootAST) {
        this.mCollect = false;
        this.mImports.clear();
        this.mReferenced.clear();
    }

    public void finishTree(DetailAST aRootAST) {
        for (FullIdent imp : this.mImports) {
            if (this.mReferenced.contains(Utils.baseClassname(imp.getText()))) continue;
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", imp.getText());
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{16, 157, 14, 154, 58, 30, 15, 152};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 58) {
            if (this.mCollect) {
                this.processIdent(aAST);
            }
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else if (aAST.getType() == 152) {
            this.processStaticImport(aAST);
        } else if (aAST.getType() == 14 || aAST.getType() == 15 || aAST.getType() == 154 || aAST.getType() == 157 || aAST.getType() == 16) {
            this.mCollect = true;
        }
    }

    private void processIdent(DetailAST aAST) {
        DetailAST parent = aAST.getParent();
        int parentType = parent.getType();
        if (parentType != 59 && parentType != 9 || parentType == 59 && aAST.getNextSibling() != null) {
            this.mReferenced.add(aAST.getText());
        }
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }

    private void processStaticImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling());
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }
}

