/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.jpa.entity.metadata;

import com.nokia.helium.jpa.entity.metadata.Component;
import com.nokia.helium.jpa.entity.metadata.LogFile;
import com.nokia.helium.jpa.entity.metadata.Priority;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class MetadataEntry {
    public static final int TEXT_LENGTH = 500;
    @Id
    @Column(name="ENTRY_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    private int id;
    @Basic
    private int lineNumber;
    @Basic
    @Column(length=500)
    private String text;
    @Basic
    @Column(name="COMPONENT_ID", insertable=false, updatable=false)
    private int componentId;
    @Basic
    @Column(name="PRIORITY_ID", insertable=false, updatable=false)
    private int priorityId;
    @ManyToOne(cascade={CascadeType.REMOVE}, optional=false)
    @JoinColumn(name="COMPONENT_ID", referencedColumnName="COMPONENT_ID")
    private Component component;
    @ManyToOne(cascade={CascadeType.REMOVE}, optional=false)
    @JoinColumn(name="PRIORITY_ID", referencedColumnName="PRIORITY_ID")
    private Priority priority;
    @Column(name="LOGPATH_ID", insertable=false, updatable=false)
    private int logPathId;
    @ManyToOne(cascade={CascadeType.REMOVE}, optional=false)
    @JoinColumn(name="LOGPATH_ID", referencedColumnName="LOGPATH_ID")
    private LogFile logFile;

    public int getId() {
        return this.id;
    }

    public void setLogFile(LogFile file) {
        this.logFile = file;
    }

    public void setPriority(Priority prty) {
        this.priority = prty;
    }

    public void setComponent(Component cmpt) {
        this.component = cmpt;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setText(String txt) {
        if (txt.length() > 500) {
            txt = txt.substring(0, 500);
        }
        this.text = txt;
    }

    public void setLineNumber(int number) {
        this.lineNumber = number;
    }

    public String getText() {
        return this.text;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLogPathId() {
        return this.logPathId;
    }

    public void setLogPathId(int id) {
        this.logPathId = id;
    }
}

