/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.ant.data.taskdefs;

import com.nokia.helium.ant.data.Database;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class DatabaseTask
extends Task {
    private File outputFile;
    private String scope = "public";
    private List<ResourceCollection> rcs = new ArrayList<ResourceCollection>();

    public DatabaseTask() {
        this.setTaskName("database");
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public void setOutput(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void execute() {
        if (this.outputFile == null) {
            throw new BuildException("'output' must be defined.");
        }
        this.log("Building Ant project database", 4);
        try {
            ArrayList<String> antFilePaths = new ArrayList<String>();
            for (ResourceCollection rc : this.rcs) {
                if (!(rc instanceof FileSet)) continue;
                FileSet fs = (FileSet)rc;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                String basedir = ds.getBasedir().getPath();
                for (int i = 0; i < srcFiles.length; ++i) {
                    String fileName = basedir + File.separator + srcFiles[i];
                    antFilePaths.add(fileName);
                }
            }
            Database db = new Database(this.getProject());
            db.setScope(this.scope);
            db.addAntFilePaths(antFilePaths);
            FileWriter out = new FileWriter(this.outputFile);
            db.toXML(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException("Not able to build the ANT project Database " + e.getMessage());
        }
    }
}

