/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.quality.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class CodeScanner
extends Task {
    private Vector<Path> paths = new Vector();
    private File configuration;
    private String dest;
    private String format = "xml,html";
    private boolean auto;
    private File log;
    private boolean failonerror;

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void add(Path path) {
        this.paths.add(path);
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public File getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(File configuration) {
        this.configuration = configuration;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public void execute() {
        String osType = System.getProperty("os.name");
        if (!osType.toLowerCase().startsWith("win")) {
            this.log("CODESCANNER: run in windows only");
            return;
        }
        ExecTask task = new ExecTask();
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        task.setFailonerror(this.failonerror);
        task.setExecutable("codescanner");
        task.setDir(new File("."));
        if (this.dest == null) {
            throw new BuildException("'dest' attribute must be defined");
        }
        if (this.configuration != null) {
            if (!this.configuration.exists()) {
                throw new BuildException("Could not find the file " + this.configuration);
            }
        } else {
            throw new BuildException("'configuration' attribute must be defined");
        }
        task.createArg().setValue("-c");
        task.createArg().setValue(this.configuration.getAbsolutePath());
        if (!this.format.contains("xml")) {
            this.setFormat("xml," + this.format);
        }
        this.log("Output format: " + this.format);
        task.createArg().setValue("-t");
        task.createArg().setValue(this.auto ? "on" : "off");
        if (this.log != null) {
            this.log("Output log: " + this.log.getAbsolutePath());
            task.createArg().setValue("-l");
            task.createArg().setValue(this.log.getAbsolutePath());
        }
        task.createArg().setValue("-o");
        task.createArg().setValue(this.format);
        if (this.paths.isEmpty()) {
            throw new BuildException("No input directory defined");
        }
        Vector<String> srcs = new Vector<String>();
        for (Path path : this.paths) {
            if (path.isReference()) {
                path = (Path)path.getRefid().getReferencedObject();
            }
            for (String apath : path.list()) {
                srcs.add(apath);
            }
        }
        for (int i = 0; i < srcs.size(); ++i) {
            if (i != srcs.size() - 1) {
                task.createArg().setValue("-i");
                task.createArg().setValue((String)srcs.elementAt(i));
                continue;
            }
            task.createArg().setValue((String)srcs.elementAt(i));
            task.createArg().setValue(this.dest.toString());
        }
        this.log("Output dir " + this.dest);
        task.execute();
        this.log("Successfully executed codescanner");
    }
}

