/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.ant.engines;

import com.nokia.helium.core.plexus.AntStreamConsumer;
import com.nokia.helium.core.plexus.FileStreamConsumer;
import com.nokia.helium.imaker.IMakerException;
import com.nokia.helium.imaker.ant.Command;
import com.nokia.helium.imaker.ant.Engine;
import com.nokia.helium.imaker.ant.engines.Emake;
import com.nokia.helium.imaker.ant.taskdefs.IMakerTask;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class EmakeEngine
extends DataType
implements Engine {
    private Logger log = Logger.getLogger(this.getClass());
    private IMakerTask task;
    private List<Arg> customArgs = new ArrayList<Arg>();
    private File template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(List<List<Command>> cmdSet) throws IMakerException {
        File makefile = null;
        try {
            makefile = this.writeMakefile(cmdSet);
            this.runEmake(makefile);
        }
        finally {
            if (makefile != null) {
                makefile.delete();
            }
        }
    }

    protected File getJarFile() throws IMakerException {
        URL url = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
        if (url.getProtocol().equals("jar") && url.getPath().contains("!/")) {
            String fileUrl = url.getPath().split("!/")[0];
            try {
                return new File(new URL(fileUrl).getPath());
            }
            catch (MalformedURLException e) {
                throw new IMakerException("Error determining the jar file where " + this.getClass().getName() + " is located.", e);
            }
        }
        return null;
    }

    private void runEmake(File makefile) throws IMakerException {
        FileStreamConsumer output = null;
        if (this.task.getOutput() != null) {
            try {
                output = new FileStreamConsumer(this.task.getOutput());
            }
            catch (FileNotFoundException e) {
                throw new IMakerException("Error creating the stream recorder: " + e.getMessage(), e);
            }
        }
        try {
            Emake emake = new Emake();
            emake.setWorkingDir(this.task.getEpocroot());
            ArrayList<String> args = new ArrayList<String>();
            for (Arg arg : this.customArgs) {
                if (arg.getValue() == null) continue;
                args.add(arg.getValue());
            }
            args.add("-f");
            args.add(makefile.getAbsolutePath());
            args.add("all");
            if (this.task.isVerbose()) {
                emake.addOutputLineHandler((StreamConsumer)new AntStreamConsumer((Task)this.task));
            }
            emake.addErrorLineHandler((StreamConsumer)new AntStreamConsumer((Task)this.task, 0));
            if (output != null) {
                emake.addOutputLineHandler((StreamConsumer)output);
                emake.addErrorLineHandler((StreamConsumer)output);
            }
            emake.execute(args.toArray(new String[args.size()]));
        }
        catch (IMakerException e) {
            throw new IMakerException("Error executing emake: " + e.getMessage(), e);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private File writeMakefile(List<List<Command>> cmdSet) throws IMakerException {
        try {
            Configuration cfg = new Configuration();
            Template template = null;
            if (this.template != null) {
                if (!this.template.exists()) {
                    throw new IMakerException("Could not find template file: " + this.template.getAbsolutePath());
                }
                this.task.log("Loading template: " + this.template.getAbsolutePath());
                cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(this.template.getParentFile()));
                template = cfg.getTemplate(this.template.getName());
            } else {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), ""));
                template = cfg.getTemplate("build_imaker_roms_signing.mk.ftl");
            }
            File makefile = File.createTempFile("helium-imaker", ".mk", this.task.getEpocroot());
            makefile.deleteOnExit();
            StringWriter out = new StringWriter();
            Hashtable<String, Object> data = new Hashtable<String, Object>();
            data.put("cmdSets", cmdSet);
            data.put("makefile", makefile.getAbsoluteFile());
            data.put("java_home", System.getProperty("java.home"));
            File jar = this.getJarFile();
            if (jar != null) {
                this.task.log("Using " + jar + " as the utility container, make sure the file is available under an emake root.");
                data.put("java_utils_classpath", jar.getAbsolutePath());
            }
            template.process(data, (Writer)out);
            this.log.debug((Object)out.getBuffer().toString());
            OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(makefile));
            output.append(out.getBuffer().toString());
            output.close();
            return makefile;
        }
        catch (IOException e) {
            throw new IMakerException("Error generating the makefile: " + e.getMessage(), e);
        }
        catch (TemplateException e) {
            throw new IMakerException("Error while rendering the makefile template: " + e.getMessage(), e);
        }
    }

    public Arg createArg() {
        Arg arg = new Arg();
        this.customArgs.add(arg);
        return arg;
    }

    @Override
    public void setTask(IMakerTask task) {
        this.task = task;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public class Arg {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

