/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultilineDetector {
    private final DetectorOptions mOptions;
    private int mCurrentMatches;
    private final List<Integer[]> mCharacters = Lists.newArrayList();
    private Matcher mMatcher;

    public MultilineDetector(DetectorOptions aOptions) {
        this.mOptions = aOptions;
    }

    public void processLines(List<String> aLines) {
        this.resetState();
        StringBuffer sb = new StringBuffer();
        int lineno = 1;
        for (String line : aLines) {
            sb.append(line);
            sb.append('\n');
            for (int j = 0; j < line.length() + 1; ++j) {
                this.mCharacters.add(new Integer[]{lineno, j});
            }
            ++lineno;
        }
        this.mMatcher = this.mOptions.getPattern().matcher(sb.toString());
        this.findMatch();
        this.finish();
    }

    private void findMatch() {
        boolean foundMatch = this.mMatcher.find();
        if (!foundMatch) {
            return;
        }
        int startLine = this.mCharacters.get(this.mMatcher.start())[0];
        int startColumn = this.mCharacters.get(this.mMatcher.start())[1];
        int endLine = this.mCharacters.get(this.mMatcher.end() - 1)[0];
        int endColumn = this.mCharacters.get(this.mMatcher.end() - 1)[1];
        if (!this.mOptions.getSuppressor().shouldSuppress(startLine, startColumn, endLine, endColumn)) {
            ++this.mCurrentMatches;
            if (this.mCurrentMatches > this.mOptions.getMaximum()) {
                if ("".equals(this.mOptions.getMessage())) {
                    this.mOptions.getReporter().log(startLine, "regexp.exceeded", this.mMatcher.pattern().toString());
                } else {
                    this.mOptions.getReporter().log(startLine, this.mOptions.getMessage(), new Object[0]);
                }
            }
        }
        this.findMatch();
    }

    private void finish() {
        if (this.mCurrentMatches < this.mOptions.getMinimum()) {
            if ("".equals(this.mOptions.getMessage())) {
                this.mOptions.getReporter().log(0, "regexp.minimum", this.mOptions.getMinimum(), this.mOptions.getFormat());
            } else {
                this.mOptions.getReporter().log(0, this.mOptions.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.mCurrentMatches = 0;
        this.mCharacters.clear();
    }
}

