/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQueryImpl<X>
implements JpaQuery<X> {
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map<String, Object> parameterValues = new HashMap<String, Object>();
    protected Map<Parameter<?>, Parameter<?>> parameters;
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected LockModeType lockMode = null;
    protected boolean isShared;

    protected EJBQueryImpl(EntityManagerImpl entityManager) {
        this.entityManager = entityManager;
        this.isShared = true;
    }

    public EJBQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        this(entityManager);
        this.databaseQuery = query;
    }

    public EJBQueryImpl(String jpql, EntityManagerImpl entityManager) {
        this(jpql, entityManager, false);
    }

    public EJBQueryImpl(String queryDescription, EntityManagerImpl entityManager, boolean isNamedQuery) {
        this(entityManager);
        if (isNamedQuery) {
            this.queryName = queryDescription;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(queryDescription, this.entityManager.getServerSession());
        }
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQuery().isDataReadQuery()) {
            DataModifyQuery query = new DataModifyQuery();
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.copyFromQuery(this.databaseQuery);
            query.setDatasourceCall((Call)this.databaseQuery.getDatasourceCall().clone());
            this.databaseQuery = query;
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQuery().isDataModifyQuery()) {
            DataReadQuery query = new DataReadQuery();
            query.setResultType(4);
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.copyFromQuery(this.databaseQuery);
            this.databaseQuery = query;
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String jpql, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, jpql, session, null, null, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String queryName, String jpql, Session session, Enum lockMode, Map<String, Object> hints, ClassLoader classLoader) {
        boolean isCacheable = queryName == null && hints == null;
        DatabaseQuery databaseQuery = null;
        if (isCacheable) {
            databaseQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get(jpql);
        }
        if (databaseQuery == null || !databaseQuery.isPrepared()) {
            ReadAllQuery readAllQuery;
            JPQLParseTree parseTree = JPQLParser.buildParseTree(queryName, jpql);
            parseTree.setClassLoader(classLoader);
            databaseQuery = parseTree.createDatabaseQuery();
            databaseQuery.setJPQLString(jpql);
            parseTree.populateQuery(databaseQuery, (AbstractSession)session);
            if (databaseQuery.isReadAllQuery() && (readAllQuery = (ReadAllQuery)databaseQuery).hasJoining() && readAllQuery.getDistinctState() == 2) {
                readAllQuery.setShouldFilterDuplicates(false);
            }
            parseTree.addParametersToQuery(databaseQuery);
            ((JPQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            if (databaseQuery.isReadQuery()) {
                databaseQuery.cascadeByMapping();
            }
            if (lockMode != null && !lockMode.name().equals("NONE")) {
                if (databaseQuery.isObjectLevelReadQuery()) {
                    if (((ObjectLevelReadQuery)databaseQuery).setLockModeType(lockMode.name(), (AbstractSession)session)) {
                        throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
                    }
                } else {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
                }
            }
            databaseQuery = EJBQueryImpl.applyHints(hints, databaseQuery, classLoader);
            if (isCacheable) {
                databaseQuery.prepareCall(session, new DatabaseRecord());
                session.getProject().getJPQLParseCache().put(jpql, databaseQuery);
            }
        }
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(resultClass, sqlString, null, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class resultClass, String sqlString, Map<String, Object> hints, ClassLoader classLoader) {
        ReadAllQuery query = new ReadAllQuery(resultClass);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlResultSetMappingName, sqlString, null, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlResultSetMappingName, String sqlString, Map<String, Object> hints, ClassLoader classLoader) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader);
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class resultClass, StoredProcedureCall call, List<String> arguments, Map<String, Object> hints, ClassLoader classLoader) {
        DatabaseQuery query = new ReadAllQuery(resultClass);
        query.setCall(call);
        query.setIsUserDefined(true);
        query = EJBQueryImpl.applyHints(hints, query, classLoader);
        EJBQueryImpl.applyArguments(arguments, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, List<String> arguments, Map<String, Object> hints, ClassLoader classLoader) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = EJBQueryImpl.applyHints(hints, query, classLoader);
        EJBQueryImpl.applyArguments(arguments, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, List<String> arguments, Map<String, Object> hints, ClassLoader classLoader) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = EJBQueryImpl.applyHints(hints, query, classLoader);
        EJBQueryImpl.applyArguments(arguments, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(sqlString, new HashMap<String, Object>(), classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String sqlString, Map<String, Object> hints, ClassLoader classLoader) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(hints, query, classLoader);
    }

    protected Object executeReadQuery() {
        List<Object> parameterValues = this.processParameters();
        boolean shouldResetConformResultsInUnitOfWork = false;
        if (this.isFlushModeAUTO()) {
            this.performPreQueryFlush();
            if (this.getDatabaseQuery().isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.getDatabaseQuery()).shouldConformResultsInUnitOfWork()) {
                this.cloneSharedQuery();
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).setCacheUsage(-1);
                shouldResetConformResultsInUnitOfWork = true;
            }
        }
        if (this.lockMode != null) {
            this.entityManager.checkForTransaction(true);
            this.cloneSharedQuery();
            if (((ObjectLevelReadQuery)this.getDatabaseQuery()).setLockModeType(this.lockMode.name(), (AbstractSession)this.getActiveSession())) {
                throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
            }
        }
        Session session = this.getActiveSession();
        try {
            if (this.getDatabaseQuery().isUserDefined() && this.entityManager.checkForTransaction(false) != null && session.isUnitOfWork() && !((UnitOfWorkImpl)session).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)session).beginEarlyTransaction();
            }
            Object object = session.executeQuery(this.getDatabaseQuery(), parameterValues);
            return object;
        }
        catch (DatabaseException e) {
            if (this.lockMode != null && this.lockMode.name().contains("PESSIMISTIC_")) {
                if (session.getPlatform().isLockTimeoutException(e)) {
                    throw new LockTimeoutException(e);
                }
                throw new PessimisticLockException(e);
            }
            this.setRollbackOnly();
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            this.lockMode = null;
            if (shouldResetConformResultsInUnitOfWork) {
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQuery() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            List<Object> parameterValues = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer changedRows = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, parameterValues);
            return changedRows;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public DatabaseQuery getDatabaseQuery() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.entityManager.getServerSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.prepareCall(this.entityManager.getServerSession(), new DatabaseRecord());
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    @Override
    public JpaEntityManager getEntityManager() {
        return this.entityManager;
    }

    public LockModeType getLockMode() {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQuery().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            return this.lockMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Cursor getResultCursor() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            if (!((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().isCursorPolicy()) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                throw QueryException.invalidContainerClass(containerClass, Cursor.class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        try {
            Object result = this.executeReadQuery();
            return (Cursor)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Collection getResultCollection() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface(containerClass, ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass(containerClass, ClassConstants.Collection_Class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        try {
            Object result = this.executeReadQuery();
            return (Collection)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public List getResultList() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                Class containerClass = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else {
                if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                    throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
                }
                if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_list"));
                }
            }
            Object result = this.executeReadQuery();
            return (List)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public X getSingleResult() {
        boolean rollbackOnException = true;
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_single_result"));
            }
            Object result = this.executeReadQuery();
            if (result instanceof List) {
                List results = (List)result;
                if (results.isEmpty()) {
                    rollbackOnException = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                } else if (results.size() > 1) {
                    rollbackOnException = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                return (X)results.get(0);
            }
            if (result == null) {
                rollbackOnException = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
            }
            return (X)result;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (rollbackOnException) {
                this.setRollbackOnly();
            }
            throw e;
        }
    }

    protected List<Object> processParameters() {
        DatabaseQuery query = this.getDatabaseQuery();
        List<String> arguments = query.getArguments();
        if (arguments.isEmpty()) {
            arguments = new ArrayList<String>(this.parameterValues.keySet());
            query.setArguments(arguments);
        }
        int size = arguments.size();
        ArrayList<Object> parameterValues = new ArrayList<Object>(size);
        for (int index = 0; index < size; ++index) {
            String name = arguments.get(index);
            Object parameter = this.parameterValues.get(name);
            if (parameter == null && !this.parameterValues.containsKey(name)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("missing_parameter_value", new Object[]{name}));
            }
            parameterValues.add(parameter);
        }
        return parameterValues;
    }

    @Override
    public void setDatabaseQuery(DatabaseQuery query) {
        this.databaseQuery = query;
    }

    @Override
    public TypedQuery setFirstResult(int startPosition) {
        try {
            this.entityManager.verifyOpen();
            this.setFirstResultInternal(startPosition);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getFirstResult() {
        return this.firstResultIndex;
    }

    protected void setFirstResultInternal(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        this.firstResultIndex = startPosition;
    }

    @Override
    public TypedQuery setFlushMode(FlushModeType flushMode) {
        try {
            this.entityManager.verifyOpen();
            if (flushMode == null) {
                this.getDatabaseQuery().setFlushOnExecute(null);
            } else {
                this.cloneSharedQuery();
                this.getDatabaseQuery().setFlushOnExecute(flushMode == FlushModeType.AUTO);
            }
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected static void applyArguments(List<String> arguments, DatabaseQuery query) {
        for (String argument : arguments) {
            query.addArgument(argument);
        }
    }

    protected static DatabaseQuery applyHints(Map<String, Object> hints, DatabaseQuery query, ClassLoader classLoader) {
        return QueryHintsHandler.apply(hints, query, classLoader);
    }

    public boolean isBound(Parameter<?> param) {
        if (param == null) {
            return false;
        }
        return this.parameterValues.containsKey(param.getName());
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQuery().getFlushOnExecute() != null) {
            return this.getDatabaseQuery().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    @Override
    public TypedQuery setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setHintInternal(String hintName, Object value) {
        this.cloneSharedQuery();
        ClassLoader loader = this.getEntityManager().getServerSession().getLoader();
        DatabaseQuery hintQuery = QueryHintsHandler.apply(hintName, value, this.getDatabaseQuery(), loader);
        if (hintQuery != null) {
            this.setDatabaseQuery(hintQuery);
        }
    }

    @Override
    public TypedQuery setLockMode(LockModeType lockMode) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQuery().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            this.lockMode = lockMode;
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void cloneSharedQuery() {
        DatabaseQuery query = this.getDatabaseQuery();
        if (this.isShared) {
            query = (DatabaseQuery)this.databaseQuery.clone();
            this.setDatabaseQuery(query);
            this.isShared = false;
        }
    }

    protected Object convertTemporalType(Object value, TemporalType type) {
        ConversionManager conversionManager = ((AbstractSession)this.getEntityManager().getActiveSession()).getDatasourcePlatform().getConversionManager();
        if (type == TemporalType.TIME) {
            return conversionManager.convertObject(value, ClassConstants.TIME);
        }
        if (type == TemporalType.TIMESTAMP) {
            return conversionManager.convertObject(value, ClassConstants.TIMESTAMP);
        }
        if (type == TemporalType.DATE) {
            return conversionManager.convertObject(value, ClassConstants.SQLDATE);
        }
        return value;
    }

    @Override
    public TypedQuery setMaxResults(int maxResult) {
        try {
            this.entityManager.verifyOpen();
            this.setMaxResultsInternal(maxResult);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResultsInternal(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        this.maxResults = maxResult;
    }

    @Override
    public TypedQuery setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value, false);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public TypedQuery setParameter(String name, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public TypedQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    @Override
    public TypedQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                int maxRows = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(maxRows);
                this.maxResults = -1;
            }
            if (this.firstResultIndex > -1) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                readQuery.setFirstResult(this.firstResultIndex);
                this.firstResultIndex = -1;
            }
        }
    }

    protected void setParameterInternal(String name, Object value, boolean isIndex) {
        DatabaseQuery query = this.getDatabaseQuery();
        int index = query.getArguments().indexOf(name);
        if (query.getQueryMechanism().isJPQLCallQueryMechanism()) {
            if (index == -1) {
                if (isIndex) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{name, query.getEJBQLString()}));
                }
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{name, query.getEJBQLString()}));
            }
            Class type = query.getArgumentTypes().get(index);
            if (!this.isValidActualParameter(value, type)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{name, value.getClass(), query.getArgumentTypes().get(index), query.getEJBQLString()}));
            }
        }
        this.parameterValues.put(name, value);
    }

    protected void setParameterInternal(int position, Object value) {
        this.setParameterInternal(String.valueOf(position), value, true);
    }

    protected boolean isValidActualParameter(Object value, Class parameterType) {
        if (value == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom(parameterType, value.getClass());
    }

    protected Session getActiveSession() {
        DatabaseQuery query = this.getDatabaseQuery();
        if (query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)query).isReadOnly()) {
            return this.entityManager.getReadOnlySession();
        }
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }

    protected void throwNoResultException(String message) {
        throw new NoResultException(message);
    }

    protected void throwNonUniqueResultException(String message) {
        throw new NonUniqueResultException(message);
    }

    public FlushModeType getFlushMode() {
        try {
            this.entityManager.verifyOpen();
            if (this.getDatabaseQuery().getFlushOnExecute().booleanValue()) {
                return FlushModeType.AUTO;
            }
            return FlushModeType.COMMIT;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Map<String, Object> getHints() {
        return (Map)this.getDatabaseQuery().getProperty("eclipselink.query.hints");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.parameters.get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.parameters.get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_INDEX", new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(String name) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.parameters.get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(int position) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.parameters.get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_INDEX", new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PARAMETER_NILL_NOT_FOUND"));
        }
        return (T)this.getParameterValue(param.getName());
    }

    public Object getParameterValue(String name) {
        try {
            this.entityManager.verifyOpen();
            if (!this.parameters.containsKey(new ParameterExpressionImpl(null, null, name))) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            if (!this.parameterValues.containsKey(name)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("NO_VALUE_BOUND", new Object[]{name}));
            }
            return this.parameterValues.get(name);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getParameterValue(int position) {
        String param = String.valueOf(position);
        if (!this.parameterValues.containsKey(param)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("position_param_not_found", new Object[]{position}));
        }
        return this.parameterValues.get(param);
    }

    public Set<Parameter<?>> getParameters() {
        if (this.parameters == null) {
            DatabaseQuery query = this.getDatabaseQuery();
            int count = 0;
            if (query.getArguments() != null && !query.getArguments().isEmpty()) {
                this.parameters = new HashMap();
                for (String argName : query.getArguments()) {
                    ParameterExpressionImpl param = new ParameterExpressionImpl(null, query.getArgumentTypes().get(count), argName);
                    this.parameters.put((Parameter<?>)((Object)param), (Parameter<?>)((Object)param));
                    ++count;
                }
            }
        }
        return this.parameters.keySet();
    }

    public Set<String> getSupportedHints() {
        return QueryHintsHandler.getSupportedHints();
    }

    @Override
    public <T> TypedQuery setParameter(Parameter<T> param, T value) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value);
    }

    @Override
    public TypedQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    @Override
    public TypedQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (cls.isAssignableFrom(this.getDatabaseQuery().getClass())) {
            return (T)this.getDatabaseQuery();
        }
        throw new PersistenceException("Could not unwrap query to: " + cls);
    }
}

