/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.types.DummyNumberProperty;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.tools.ant.Task;

public class NumberProperty
extends DummyNumberProperty
implements ActionListenerComponent {
    private double min = 0.0;
    private double max = 100.0;
    private double step = 1.0;
    private SpinnerNumberModel model;
    private JSpinner spinner;

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.model = new SpinnerNumberModel(this.min, this.min, this.max, this.step);
        this.spinner = new JSpinner(this.model);
        panel.getStylesheetHandler().addSpinner(this.spinner);
        this.spinner.setEnabled(this.isEditable());
        this.initComponent(this.spinner, panel);
    }

    public boolean validate(Task task) {
        return super.validate(task, "NumberProperty");
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.spinner.getValue().toString());
    }

    public void reset() {
        if (this.isDouble(this.getCurrentProjectPropertyValue())) {
            this.spinner.setValue(new Double(this.getCurrentProjectPropertyValue()));
        } else {
            this.spinner.setValue(new Double(0.0));
        }
    }

    private boolean isDouble(String s) {
        boolean isDouble = true;
        try {
            Double.parseDouble(s);
        }
        catch (Exception e) {
            isDouble = false;
        }
        return isDouble;
    }

    public JComponent getFocusableComponent() {
        return this.spinner;
    }
}

