/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.tags.util.WikiTagNode;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class AbstractParser
extends WikipediaScanner {
    protected char fCurrentCharacter;
    protected int fCurrentPosition;
    protected boolean fWhiteStart = false;
    protected int fWhiteStartPosition = 0;

    public AbstractParser(String stringSource) {
        super(stringSource);
    }

    public void initialize(String src) {
        super.initialize(src, 0);
        this.fCurrentPosition = 0;
        this.fCurrentCharacter = '\u0000';
        this.fWhiteStart = false;
        this.fWhiteStartPosition = 0;
    }

    protected final boolean readUntil(String untilString) {
        int index = this.fStringSource.indexOf(untilString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + untilString.length();
            return true;
        }
        return false;
    }

    protected final boolean readUntilIgnoreCase(String startString, String endString) {
        int index = Utils.indexOfIgnoreCase(this.fStringSource, startString, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + startString.length() + endString.length();
            return true;
        }
        return false;
    }

    protected final boolean readUntilChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) != testedChar) {
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean readUntilEOL() {
        try {
            while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                if (this.fCurrentCharacter == '\n' || this.fCurrentCharacter == '\r') {
                    return true;
                }
                if (this.fCurrentCharacter != '<') continue;
                this.readSpecialWikiTags();
            }
        }
        catch (IndexOutOfBoundsException e) {
            --this.fCurrentPosition;
            return true;
        }
    }

    protected boolean readSpecialWikiTags() {
        block7: {
            String tagName;
            block9: {
                block8: {
                    WikiTagNode tagNode;
                    if (this.fSource[this.fCurrentPosition] == '/' || (tagNode = this.parseTag(this.fCurrentPosition)) == null) break block7;
                    tagName = tagNode.getTagName();
                    if (!tagName.equals("nowiki")) break block8;
                    if (this.readUntilIgnoreCase("</", "nowiki>")) {
                        return true;
                    }
                }
                if (!tagName.equals("source")) break block9;
                if (this.readUntilIgnoreCase("</", "source>")) {
                    return true;
                }
            }
            try {
                if (tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")) {
                    return true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEmptyLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        try {
            while (true) {
                char ch;
                if (!Character.isWhitespace(ch = this.fSource[temp])) {
                    return false;
                }
                if (ch == '\n') {
                    return true;
                }
                ++temp;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    protected int readWhitespaceUntilEndOfLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        while (this.fSource.length > temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch == '\n') {
                this.fCurrentPosition = temp;
                return temp;
            }
            ++temp;
        }
        this.fCurrentPosition = temp - 1;
        return temp;
    }

    protected int readWhitespaceUntilStartOfLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        while (temp >= 0) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch == '\n') {
                return temp;
            }
            --temp;
        }
        return temp;
    }

    protected boolean parsePHPBBCode(String name, StringBuilder bbCode) {
        int index = 1;
        char ch = ' ';
        while (index < name.length()) {
            if (97 > (ch = (char)name.charAt(index++)) || ch > 122) break;
            bbCode.append(ch);
        }
        if (ch != '=' && index != name.length()) {
            return false;
        }
        String bbStr = bbCode.toString();
        String bbEndStr = String.valueOf(bbStr) + "]";
        int startPos = this.fCurrentPosition;
        if (!this.readUntilIgnoreCase("[/", bbEndStr)) {
            return false;
        }
        String bbAttr = null;
        if (ch == '=' && (bbAttr = name.substring(index, name.length())) != null) {
            bbAttr = bbAttr.trim();
        }
        int endPos = this.fCurrentPosition - bbEndStr.length() - 2;
        String innerTag = new String(this.fSource, startPos, endPos - startPos);
        return this.createBBCode(bbStr, bbAttr, innerTag);
    }

    private int parsePHPBBCodeRecursive(String rawWikitext, int index) {
        char ch = ' ';
        StringBuilder bbCode = new StringBuilder(10);
        while (index < rawWikitext.length()) {
            if (97 > (ch = (char)rawWikitext.charAt(index++)) || ch > 122) break;
            bbCode.append(ch);
        }
        String bbStr = bbCode.toString();
        String bbEndStr = String.valueOf(bbStr) + "]";
        int startPos = index;
        int endIndex = Utils.indexOfIgnoreCase(rawWikitext, "[/", bbEndStr, index);
        if (endIndex != -1) {
            String innerTag;
            String bbAttr = null;
            if (ch == '=' && (bbAttr = rawWikitext.substring(index, endIndex)) != null) {
                bbAttr = bbAttr.trim();
            }
            if (this.createBBCode(bbStr, bbAttr, innerTag = rawWikitext.substring(startPos, endIndex))) {
                return endIndex + 3 + bbStr.length();
            }
        }
        return -1;
    }

    private boolean createBBCode(String bbStr, String bbAttr, String innerTag) {
        if (bbStr.equals("code")) {
            TagNode preTagNode = new TagNode("pre");
            preTagNode.addAttribute("class", "code", true);
            preTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(preTagNode);
            return true;
        }
        if (bbStr.equals("color")) {
            if (bbAttr == null) {
                return false;
            }
            TagNode fontTagNode = new TagNode("font");
            fontTagNode.addAttribute("color", bbAttr, true);
            fontTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(fontTagNode);
            return true;
        }
        if (bbStr.equals("email")) {
            TagNode aTagNode = new TagNode("a");
            aTagNode.addAttribute("href", "emailto:" + innerTag.trim(), true);
            aTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(aTagNode);
            return true;
        }
        if (bbStr.equals("list")) {
            block31: {
                int listStart = 0;
                int listEnd = 0;
                TagNode listTagNode = bbAttr != null ? (bbAttr.equals("a") ? new TagNode("ul") : new TagNode("ol")) : new TagNode("ul");
                this.fWikiModel.pushNode(listTagNode);
                try {
                    while (listEnd >= 0) {
                        listEnd = innerTag.indexOf("[*]", listStart);
                        if (listEnd <= listStart) continue;
                        if (listStart == 0) {
                            this.parseNextPHPBBCode(innerTag.substring(0, listEnd));
                        } else {
                            listTagNode = new TagNode("li");
                            this.fWikiModel.pushNode(listTagNode);
                            try {
                                this.parseNextPHPBBCode(innerTag.substring(listStart, listEnd));
                            }
                            finally {
                                this.fWikiModel.popNode();
                            }
                        }
                        listStart = listEnd + 3;
                    }
                    if (listStart == 0) {
                        this.parseNextPHPBBCode(innerTag);
                        break block31;
                    }
                    if (listStart >= innerTag.length()) break block31;
                    listTagNode = new TagNode("li");
                    this.fWikiModel.pushNode(listTagNode);
                    try {
                        this.parseNextPHPBBCode(innerTag.substring(listStart, innerTag.length()));
                    }
                    finally {
                        this.fWikiModel.popNode();
                    }
                }
                finally {
                    this.fWikiModel.popNode();
                }
            }
            return true;
        }
        if (bbStr.equals("img")) {
            TagNode imgTagNode = new TagNode("img");
            imgTagNode.addAttribute("src", innerTag.trim(), true);
            imgTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(imgTagNode);
            return true;
        }
        if (bbStr.equals("quote")) {
            TagNode quoteTagNode = new TagNode("blockquote");
            this.fWikiModel.pushNode(quoteTagNode);
            try {
                this.parseNextPHPBBCode(innerTag);
            }
            finally {
                this.fWikiModel.popNode();
            }
            return true;
        }
        if (bbStr.equals("size")) {
            if (bbAttr == null) {
                return false;
            }
            TagNode fontTagNode = new TagNode("font");
            fontTagNode.addAttribute("size", bbAttr, true);
            fontTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(fontTagNode);
            return true;
        }
        if (bbStr.equals("url")) {
            if (bbAttr != null) {
                TagNode aTagNode = new TagNode("a");
                aTagNode.addAttribute("href", bbAttr, true);
                aTagNode.addChild(new ContentToken(innerTag));
                this.fWikiModel.append(aTagNode);
                return true;
            }
            TagNode aTagNode = new TagNode("a");
            aTagNode.addAttribute("href", innerTag.trim(), true);
            aTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(aTagNode);
            return true;
        }
        if (bbStr.equals("b")) {
            TagNode boldTagNode = new TagNode("b");
            boldTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(boldTagNode);
            return true;
        }
        if (bbStr.equals("i")) {
            TagNode italicTagNode = new TagNode("i");
            italicTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(italicTagNode);
            return true;
        }
        if (bbStr.equals("u")) {
            TagNode underlineTagNode = new TagNode("u");
            underlineTagNode.addChild(new ContentToken(innerTag));
            this.fWikiModel.append(underlineTagNode);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void parseNextPHPBBCode(String rawWikitext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected TagStack parseRecursiveInternal(String rawWikitext, IWikiModel wikiModel, boolean createOnlyLocalStack, boolean noTOC) {
        TagStack localStack = new TagStack();
        TagStack globalWikiModelStack = wikiModel.swapStack(localStack);
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 25) {
                TagNode error = new TagNode("span");
                error.addAttribute("class", "error", true);
                error.addChild(new ContentToken("Error - recursion limit exceeded parsing wiki tags."));
                localStack.append(error);
                TagStack tagStack = localStack;
                return tagStack;
            }
            this.setModel(wikiModel);
            this.setNoToC(noTOC);
            this.runParser();
            TagStack tagStack = localStack;
            return tagStack;
        }
        catch (Exception e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        catch (Error e) {
            e.printStackTrace();
            TagNode error = new TagNode("span");
            error.addAttribute("class", "error", true);
            error.addChild(new ContentToken(e.getClass().getSimpleName()));
            localStack.append(error);
        }
        finally {
            wikiModel.decrementRecursionLevel();
            if (!createOnlyLocalStack) {
                globalWikiModelStack.append(localStack);
            }
            wikiModel.swapStack(globalWikiModelStack);
        }
        return localStack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean findWikiLinkEnd() {
        int level = 1;
        int position = this.fCurrentPosition;
        boolean pipeSymbolFound = false;
        try {
            while (true) {
                char ch;
                if ((ch = this.fSource[position++]) == '|') {
                    pipeSymbolFound = true;
                    continue;
                }
                if (ch == '[' && this.fSource[position] == '[') {
                    if (!pipeSymbolFound) {
                        return false;
                    }
                    ++level;
                    ++position;
                    continue;
                }
                if (ch != ']' || this.fSource[position] != ']') continue;
                ++position;
                if (--level == 0) break;
            }
            this.fCurrentPosition = position;
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public abstract void setNoToC(boolean var1);

    public abstract void runParser();
}

